/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.sslsockets.utils;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.sslsockets.Connection;
import com.eibus.exception.BusException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketCreation {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.sslsockets.utils", "SocketCreation");

    public static ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException, BusException {
        SSLServerSocket sSLServerSocket = null;
        s_logger.message("Creating SSLServerSocket on port " + n);
        SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        if (sSLServerSocketFactory == null) {
            throw new BusException("Failed to retrieve default SSLServerSocketFactory");
        }
        sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n, n2, inetAddress);
        if (sSLServerSocket == null) {
            throw new BusException("Failed to create an SSL server socket");
        }
        sSLServerSocket.setEnabledCipherSuites(Connection.ENABLED_CIPHER_SUITES);
        return sSLServerSocket;
    }

    public static Socket createClientSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, BusException {
        SSLSocket sSLSocket = null;
        s_logger.message("Creating SSLSocket on port " + n2);
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        if (sSLSocketFactory == null) {
            throw new BusException("Failed to retrieve default SSLSocketFactory");
        }
        sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        if (sSLSocket == null) {
            throw new BusException("Failed to create an SSL server socket");
        }
        sSLSocket.setEnabledCipherSuites(Connection.ENABLED_CIPHER_SUITES);
        return sSLSocket;
    }
}

