/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.sockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.Message;
import com.eibus.connection.sockets.MessageProtocol;
import com.eibus.exception.BusException;
import com.eibus.services.directory.URI;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Dictionary;

class MessageWriter
extends Thread {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.sockets", "MessageWriter");
    private static int threadInstance = 0;
    private static final int BUFFER_SIZE = 100000;
    private Socket writerSocket;
    private DataOutputStream dos;
    private DataInputStream inputStream;
    private URI uri;
    private Dictionary writerCache;

    MessageWriter(URI uRI, Dictionary dictionary) throws BusException {
        super("MessageWriter" + threadInstance++);
        this.setDaemon(true);
        this.uri = uRI;
        this.writerCache = dictionary;
        try {
            this.openSocket();
            this.inputStream = new DataInputStream(this.writerSocket.getInputStream());
            this.start();
        }
        catch (UnknownHostException unknownHostException) {
            BusException busException = new BusException("Failed to connect to uri " + uRI + ": " + unknownHostException);
            s_logger.errorException(busException);
            throw busException;
        }
        catch (IOException iOException) {
            BusException busException = new BusException("Failed to connect to uri " + uRI + ": " + iOException);
            s_logger.errorException(busException);
            throw busException;
        }
    }

    void send(Message message) throws BusException {
        try {
            MessageProtocol.write(this.dos, message);
        }
        catch (IOException iOException) {
            s_logger.message("couldn't reuse existing socket connection. Trying to reestablish the connection.");
            try {
                this.openSocket();
            }
            catch (UnknownHostException unknownHostException) {
                BusException busException = new BusException("Failed to connect to uri " + this.uri + ": " + unknownHostException);
                s_logger.errorException(busException);
                throw busException;
            }
            catch (IOException iOException2) {
                BusException busException = new BusException("Failed to connect to uri " + this.uri + ": " + iOException2);
                s_logger.errorException(busException);
                throw busException;
            }
            try {
                MessageProtocol.write(this.dos, message);
            }
            catch (IOException iOException3) {
                BusException busException = new BusException("Failed to connect to uri " + this.uri + ": " + iOException3);
                s_logger.errorException(busException);
                throw busException;
            }
        }
    }

    private void openSocket() throws UnknownHostException, IOException {
        String string = this.uri.getHost();
        int n = this.uri.getPort();
        if (string == null) {
            UnknownHostException unknownHostException = new UnknownHostException("Host not specified in uri " + this.uri);
            s_logger.errorException(unknownHostException);
            throw unknownHostException;
        }
        if (n <= 0) {
            IOException iOException = new IOException("Missing or negative port number in uri " + this.uri);
            s_logger.errorException(iOException);
            throw iOException;
        }
        try {
            this.writerSocket = new Socket(string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("Illegal argument: " + illegalArgumentException);
            s_logger.errorException(iOException);
            throw iOException;
        }
        catch (SocketException socketException) {
            IOException iOException = new IOException("Error opening socket: " + socketException);
            s_logger.errorException(iOException);
            throw iOException;
        }
        try {
            this.writerSocket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            s_logger.message("Could not set tcp-no-delay: " + socketException);
        }
        this.dos = new DataOutputStream(new BufferedOutputStream(this.writerSocket.getOutputStream(), 100000));
    }

    void close() {
        try {
            if (this.dos != null) {
                this.dos.close();
                this.dos = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.writerSocket != null) {
                this.writerSocket.close();
                this.writerSocket = null;
            }
        }
        catch (IOException iOException) {
            s_logger.errorException(iOException);
        }
    }

    public void run() {
        try {
            int n = this.inputStream.read();
        }
        catch (IOException iOException) {
            s_logger.message("Thread stopped due to " + iOException.getMessage());
        }
        if (this.writerCache != null) {
            this.writerCache.remove(this.uri);
        }
    }
}

