/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.sockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.Message;
import com.eibus.connection.NotHandledException;
import com.eibus.connection.sockets.MessageProtocol;
import com.eibus.exception.BusException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

class MessageReader
extends Thread {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.sockets", "MessageReader");
    private static int threadInstance = 0;
    Socket readingSocket;
    private BusListener listener;
    private Vector readerAdministration;
    private DataInputStream is;
    private boolean running = true;
    public static final int SOCKET_TIMEOUT = 0;
    static final int BUFFER_SIZE = 100000;

    MessageReader(Socket socket, BusListener busListener, Vector vector) throws BusException {
        super("MessageReader" + threadInstance++);
        this.setDaemon(true);
        this.readingSocket = socket;
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            s_logger.message("Could not set tcp-no-delay: " + socketException);
        }
        this.listener = busListener;
        this.readerAdministration = vector;
        try {
            this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 100000));
            socket.setSoTimeout(0);
            vector.addElement(this);
        }
        catch (IOException iOException) {
            BusException busException = new BusException("Could not open stream on current serving socket " + iOException);
            s_logger.errorException(busException);
            throw busException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this.running) {
                    break;
                }
                try {
                    Message message = MessageProtocol.read(this.is);
                    s_logger.message("Received a message of size " + message.getText().length + " on " + this.readingSocket);
                    if (s_logger.isFlowEnabled()) {
                        s_logger.flowBytes(message.getText());
                    }
                    if (this.listener == null) continue;
                    try {
                        this.listener.onReceive(message);
                    }
                    catch (NotHandledException notHandledException) {
                        s_logger.message("Listener did not handle message. Ignoring it. Exception: " + notHandledException);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    s_logger.flowMessage("MessageReader.run(): Ignoring InterruptedIOEXception.");
                    break;
                }
                catch (IOException iOException) {
                    s_logger.flowMessage("Ignoring IO/Socket Exception, " + iOException.getMessage());
                    break;
                }
            }
            Object var4_5 = null;
            s_logger.flowMessage("remove from readerAdministration");
            this.readerAdministration.removeElement(this);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            s_logger.flowMessage("remove from readerAdministration");
            this.readerAdministration.removeElement(this);
            throw throwable;
        }
    }

    void close() {
        s_logger.flowMessage("Closing Reading Socket.");
        this.running = false;
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            if (this.readingSocket != null) {
                this.readingSocket.close();
                this.readingSocket = null;
            }
        }
        catch (IOException iOException) {
            s_logger.errorMessage("MessageReader.close(): Failed to close reading socket");
            s_logger.errorException(iOException);
        }
    }
}

