/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.sockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.Message;
import com.eibus.services.profiling.DefaultTimerFactory;
import com.eibus.services.profiling.ITimer;
import com.eibus.services.profiling.Timer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class MessageProtocol {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.sockets", "MessageProtocol");
    private static final int STREAM_CLOSED = -1;
    private static final byte MAGIC_NUMBER = 5;
    private static final DefaultTimerFactory s_timerFactory = DefaultTimerFactory.getInstance();

    MessageProtocol() {
    }

    public static void write(DataOutputStream dataOutputStream, Message message) throws IOException {
        dataOutputStream.write(5);
        byte[] byArray = message.getText();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        ITimer iTimer = message.getITimer();
        if (iTimer != null) {
            iTimer.split("message sent");
        }
        s_logger.flowMessage("Busdoc sent");
    }

    public static Message read(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        if (n == -1) {
            throw new IOException("Encountered a closed message-stream ?!");
        }
        if (n != 5) {
            s_logger.message("Client uses invalid or outdated protocol");
        }
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        Message message = new Message(byArray);
        Timer timer = DefaultTimerFactory.newTimer("handle request");
        message.setITimer(timer);
        return message;
    }
}

