/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.sockets;

import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.sockets.MessageReader;
import com.eibus.connection.sockets.MessageWriter;
import com.eibus.exception.BusException;
import com.eibus.exception.NestedBusException;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import com.eibus.services.profiling.DefaultTimerFactory;
import com.eibus.services.profiling.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Connection
extends Thread
implements IConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.sockets", "Connection");
    private static final String protocol = "socket";
    private static final boolean PRINT_DEBUG_INFO = false;
    private static int threadInstance = 0;
    private static Dictionary activeConnections = new Hashtable();
    private BusListener listener;
    private ServerSocket socketServer;
    int port = 0;
    int backlog = 50;
    private BusComponent id;
    private URI servingURI;
    private Vector messageReaderAdministration = new Vector();
    private Hashtable messageWriters;
    private boolean available;
    private static final DefaultTimerFactory s_timerFactory = DefaultTimerFactory.getInstance();

    public Connection() {
        super("SocketConn" + threadInstance++);
        this.setDaemon(true);
    }

    public synchronized void initialize(BusComponent busComponent) throws BusException {
        this.id = busComponent;
        this.initialize(this.getSocketCP(busComponent));
    }

    public synchronized void initialize(ConnectionPoint connectionPoint) throws BusException {
        Object object;
        InetAddress inetAddress;
        this.servingURI = connectionPoint.getURI();
        if (!protocol.equals(this.servingURI.getProtocol())) {
            BusException busException = new BusException("Connection does not support protocol " + this.servingURI.getProtocol());
            s_logger.errorException(busException);
            throw busException;
        }
        if (activeConnections.get(this.servingURI) != null) {
            BusException busException = new BusException("Socket connection for uri " + this.servingURI + " already present");
            s_logger.errorException(busException);
            throw busException;
        }
        this.messageWriters = new Hashtable();
        try {
            inetAddress = InetAddress.getByName(this.servingURI.getHost());
        }
        catch (NullPointerException nullPointerException) {
            BusException busException = new BusException("Failed to locate host for " + this.servingURI + ": " + nullPointerException);
            s_logger.errorException(busException);
            throw busException;
        }
        catch (UnknownHostException unknownHostException) {
            BusException busException = new BusException("Failed to find host: " + unknownHostException);
            s_logger.errorException(busException);
            throw busException;
        }
        this.port = this.servingURI.getPort();
        try {
            object = AdapterClientContext.getCurrent();
            this.backlog = ((AdapterClientConfiguration)object).getMaxReaders();
        }
        catch (OWConfigurationException oWConfigurationException) {
            // empty catch block
        }
        object = "";
        try {
            object = connectionPoint.getPolicy();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        if (new String("variable").equalsIgnoreCase((String)object)) {
            if (this.port < 0) {
                this.port = 0;
            }
            try {
                this.socketServer = new ServerSocket(this.port, this.backlog, inetAddress);
            }
            catch (IOException iOException) {
                try {
                    this.socketServer = new ServerSocket(0, this.backlog, inetAddress);
                }
                catch (IOException iOException2) {
                    NestedBusException nestedBusException = new NestedBusException("Cannot start socket server " + iOException);
                    s_logger.errorException(nestedBusException);
                    throw nestedBusException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    NestedBusException nestedBusException = new NestedBusException(illegalArgumentException, "Failed to open Connection for uri " + this.servingURI);
                    s_logger.errorException(nestedBusException);
                    throw nestedBusException;
                }
            }
            this.servingURI.setPort(this.socketServer.getLocalPort());
            connectionPoint.setURI(this.servingURI);
        } else {
            if (this.port <= 0) {
                throw new BusException("Cannot start listening on socket " + this.port);
            }
            try {
                this.socketServer = new ServerSocket(this.port, this.backlog, inetAddress);
            }
            catch (IOException iOException) {
                NestedBusException nestedBusException = new NestedBusException(iOException, "Failed to open Connection for uri " + this.servingURI);
                s_logger.errorException(nestedBusException);
                throw nestedBusException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NestedBusException nestedBusException = new NestedBusException(illegalArgumentException, "Failed to open Connection for uri " + this.servingURI);
                s_logger.errorException(nestedBusException);
                throw nestedBusException;
            }
        }
        activeConnections.put(this.servingURI, this);
        s_logger.message("SocketServer constructed for uri " + this.servingURI);
    }

    public void run() {
        block9: {
            try {
                s_logger.flowMessage("Opening Connection to the Bus");
                if (this.listener == null) break block9;
                while (true) {
                    try {
                        while (true) {
                            Socket socket = this.socketServer.accept();
                            MessageReader messageReader = new MessageReader(socket, this.listener, this.messageReaderAdministration);
                            messageReader.start();
                        }
                    }
                    catch (BusException busException) {
                        s_logger.errorException(busException);
                        continue;
                    }
                    catch (SocketException socketException) {
                        s_logger.message("Socket listen thread stopped due to " + socketException.getMessage());
                    }
                    catch (IOException iOException) {
                        s_logger.errorException(iOException);
                    }
                    break;
                }
            }
            catch (ThreadDeath threadDeath) {
                s_logger.message("Socket listen thread stopped due to " + threadDeath);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                s_logger.message("Socket listen thread stoped due to " + throwable);
            }
        }
        this.available = false;
    }

    public synchronized void send(Message message) throws BusException {
        MessageWriter messageWriter;
        Connection connection;
        if (!this.available) {
            throw new BusException("Connection not initialized");
        }
        URI uRI = message.getURI();
        if (uRI == null) {
            uRI = this.getSocketURI(message.getReceiver());
        }
        if ((connection = (Connection)activeConnections.get(uRI)) != null) {
            Message message2 = message.copy();
            Timer timer = DefaultTimerFactory.newTimer("handle request");
            message2.setITimer(timer);
            connection.listener.onReceive(message2);
            return;
        }
        MessageWriter messageWriter2 = (MessageWriter)this.messageWriters.get(uRI);
        if (messageWriter2 == null && (messageWriter = this.messageWriters.put(uRI, messageWriter2 = new MessageWriter(uRI, this.messageWriters))) != null) {
            messageWriter.close();
        }
        s_logger.message("Now sending " + message.getText().length + " bytes to " + uRI);
        if (s_logger.isFlowEnabled()) {
            s_logger.flowBytes(message.getText());
        }
        messageWriter2.send(message);
    }

    public synchronized void close() {
        s_logger.flowMessage("Closing socket connection on uri " + this.servingURI);
        this.stop();
        this.available = false;
        try {
            s_logger.flowMessage("Closing SocketServer ");
            this.socketServer.close();
            s_logger.flowMessage("SocketServer Closed!");
        }
        catch (IOException iOException) {
            s_logger.message("Could not close socketserver");
            s_logger.errorException(iOException);
        }
        s_logger.message("CONNECTION: Processing messageWriters.");
        Hashtable hashtable = (Hashtable)this.messageWriters.clone();
        this.messageWriters.clear();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            ((MessageWriter)enumeration2.nextElement()).close();
        }
        s_logger.message("CONNECTION: Message Writers Processed!");
        s_logger.message("CONNECTION: Processing Message Readers.");
        int n = this.messageReaderAdministration.size();
        s_logger.message("There are " + n + " clients connected");
        Vector vector = (Vector)this.messageReaderAdministration.clone();
        this.messageReaderAdministration.removeAllElements();
        while (!vector.isEmpty()) {
            MessageReader messageReader = (MessageReader)vector.firstElement();
            vector.removeElement(messageReader);
            s_logger.message("Closing reader on port: " + messageReader.readingSocket);
            messageReader.close();
        }
        s_logger.message("CONNECTION: Message Readers & Administration Processed.");
        activeConnections.remove(this.servingURI);
        Thread.yield();
        s_logger.flowMessage("Closed socket connection on uri " + this.servingURI);
    }

    public synchronized void installBusListener(BusListener busListener) {
        this.listener = busListener;
    }

    public synchronized void open() {
        this.start();
        this.available = true;
        s_logger.flowMessage("Opened socket connection on uri " + this.servingURI);
    }

    public String getProtocol() {
        return protocol;
    }

    private URI getSocketURI(BusComponent busComponent) throws BusException {
        Object object;
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (enumeration2.hasMoreElements()) {
            try {
                object = ((ConnectionPoint)enumeration2.nextElement()).getURI();
                if (!protocol.equals(((URI)object).getProtocol())) continue;
                return object;
            }
            catch (MalformedURIException malformedURIException) {
                s_logger.errorException(malformedURIException);
            }
        }
        object = new BusException("Cannot find sockets URI for component " + busComponent.getIdentifier());
        s_logger.errorException((Throwable)object);
        throw object;
    }

    private ConnectionPoint getSocketCP(BusComponent busComponent) throws BusException {
        Serializable serializable;
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (enumeration2.hasMoreElements()) {
            try {
                serializable = (ConnectionPoint)enumeration2.nextElement();
                URI uRI = serializable.getURI();
                if (!protocol.equals(uRI.getProtocol())) continue;
                return serializable;
            }
            catch (MalformedURIException malformedURIException) {
                s_logger.errorException(malformedURIException);
            }
        }
        serializable = new BusException("Cannot find socket Connection Point for component " + busComponent.getIdentifier());
        s_logger.errorException((Throwable)serializable);
        throw serializable;
    }

    public boolean isURIVariable(URI uRI) {
        return uRI.getPort() < 0 || uRI.getPort() != uRI.getEndPort();
    }
}

