/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.inproc;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.Message;
import com.eibus.connection.inproc.Connection;
import com.eibus.exception.BusException;
import com.eibus.services.directory.URI;

class MessageWriter {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.inproc", "MessageWriter");
    private URI uri;
    private Connection.LocalMessage m_LL = null;

    MessageWriter(URI uRI) throws BusException {
        this.uri = uRI;
        String string = uRI.getProtocol();
        int n = uRI.getPort();
        s_logger.message("Creating inproc MessageWriter for uri:'" + uRI.toString() + "', localport = " + n);
        this.m_LL = Connection.getLocalListener(n);
        if (this.m_LL == null) {
            s_logger.message("Local Inproc Connection not Found for port '" + n + "'");
            BusException busException = new BusException("Failed to connect to uri :'" + uRI.toString() + "'");
            s_logger.errorException(busException);
            throw busException;
        }
    }

    void send(Message message) throws BusException {
        if (this.m_LL == null) {
            BusException busException = new BusException("Local (inproc) Connection not Found");
            s_logger.errorException(busException);
            throw busException;
        }
        this.m_LL.putMessage(message);
    }
}

