/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.inproc;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.inproc.MessageReader;
import com.eibus.connection.inproc.MessageWriter;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import java.util.Enumeration;
import java.util.Hashtable;

public class Connection
implements IConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.inproc", "Connection");
    private static final String s_protocol = "inproc";
    private static final boolean PRINT_DEBUG_INFO = false;
    private static Hashtable s_listenerStorage = new Hashtable();
    private static int s_NextPortNo = 1;
    private BusListener m_listener = null;
    private URI m_servingURI = null;
    private int m_localPort = -1;
    private MessageReader m_inprocMessageReader = null;

    public static synchronized LocalMessage getLocalListener(int n) {
        if (Connection.hasLL(n)) {
            return Connection.getLL(n);
        }
        return null;
    }

    private static synchronized void removeLL(int n) {
        s_listenerStorage.remove("" + n);
    }

    private static synchronized boolean hasLL(int n) {
        return s_listenerStorage.containsKey("" + n);
    }

    private static synchronized void putLL(int n, LocalMessage localMessage) {
        s_listenerStorage.put("" + n, localMessage);
    }

    private static synchronized LocalMessage getLL(int n) {
        return (LocalMessage)s_listenerStorage.get("" + n);
    }

    public void initialize(BusComponent busComponent) throws BusException {
        this.initialize(this.getInprocCP(busComponent));
    }

    private static synchronized int getNextPortNo() {
        return s_NextPortNo++;
    }

    public void initialize(ConnectionPoint connectionPoint) throws BusException {
        this.m_servingURI = connectionPoint.getURI();
        if (!s_protocol.equals(this.m_servingURI.getProtocol())) {
            throw new BusException("Connection does not support protocol: '" + this.m_servingURI.getProtocol() + "'");
        }
        this.m_localPort = Connection.getNextPortNo();
        this.m_servingURI.setPort(this.m_localPort);
        connectionPoint.setURI(this.m_servingURI);
        s_logger.flowMessage("Start local inproc listener '" + this.m_localPort + "'");
        LocalMessage localMessage = new LocalMessage();
        Connection.putLL(this.m_localPort, localMessage);
        this.m_inprocMessageReader = new MessageReader(this.m_listener, localMessage, this.m_localPort);
        s_logger.flowMessage("InprocServer constructed for uri '" + this.m_servingURI + "'");
    }

    public void send(Message message) throws BusException {
        URI uRI = message.getURI();
        MessageWriter messageWriter = new MessageWriter(uRI);
        s_logger.message("Now sending " + message.getText().length + " bytes to " + uRI);
        if (s_logger.isFlowEnabled()) {
            s_logger.flowBytes(message.getText());
        }
        messageWriter.send(message);
    }

    public void close() {
        s_logger.flowMessage("Closing inproc connection on uri " + this.m_servingURI + ", nproc listener '" + this.m_localPort + "'");
        this.m_inprocMessageReader.setFinish();
        Connection.removeLL(this.m_localPort);
        s_logger.flowMessage("Closed inproc connection on uri " + this.m_servingURI);
        this.m_listener = null;
        this.m_servingURI = null;
        this.m_localPort = -1;
        this.m_inprocMessageReader = null;
    }

    public void installBusListener(BusListener busListener) {
        this.m_listener = busListener;
        this.m_inprocMessageReader.SetListener(busListener);
    }

    public void open() {
        this.m_inprocMessageReader.start();
        s_logger.message("Opened inproc connection on uri " + this.m_servingURI);
    }

    public String getProtocol() {
        return s_protocol;
    }

    private URI getInprocURI(BusComponent busComponent) throws BusException {
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (enumeration2.hasMoreElements()) {
            try {
                URI uRI = ((ConnectionPoint)enumeration2.nextElement()).getURI();
                if (!s_protocol.equals(uRI.getProtocol())) continue;
                return uRI;
            }
            catch (MalformedURIException malformedURIException) {
                s_logger.errorException(malformedURIException);
            }
        }
        throw new BusException("Cannot find Inprocs URI for component " + busComponent.getIdentifier());
    }

    private ConnectionPoint getInprocCP(BusComponent busComponent) throws BusException {
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (enumeration2.hasMoreElements()) {
            try {
                ConnectionPoint connectionPoint = (ConnectionPoint)enumeration2.nextElement();
                URI uRI = connectionPoint.getURI();
                if (!s_protocol.equals(uRI.getProtocol())) continue;
                return connectionPoint;
            }
            catch (MalformedURIException malformedURIException) {
                s_logger.errorException(malformedURIException);
            }
        }
        throw new BusException("Cannot find inproc Connection Point for component " + busComponent.getIdentifier());
    }

    public boolean isURIVariable(URI uRI) {
        return uRI.getPort() < 0 || uRI.getPort() != uRI.getEndPort();
    }

    class LocalMessage {
        private Message m_message = null;

        LocalMessage() {
        }

        public synchronized void putMessage(Message message) {
            if (this.m_message != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_message = message;
            this.notify();
        }

        public synchronized Message getMessage() {
            if (this.m_message == null) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Message message = this.m_message;
            this.m_message = null;
            this.notify();
            return message;
        }
    }
}

