/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.bidisockets;

import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.bidisockets.Connection;
import com.eibus.connection.bidisockets.MessageReader;
import com.eibus.connection.bidisockets.MessageWriter;
import com.eibus.exception.BusException;
import com.eibus.exception.NestedBusException;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServerConnection
extends Thread
implements IConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.bidisockets", "ServerConnection");
    private static int s_threadInstance = 0;
    private String m_protocol = null;
    private URI m_servingURI = null;
    private ServerSocket m_serverSocket = null;
    private BusListener m_listener = null;
    private Vector m_readers = new Vector();
    private Hashtable m_writers = new Hashtable();

    public ServerConnection(String string) {
        super("ServerConnectionThread-" + s_threadInstance++);
        this.setDaemon(true);
        this.m_protocol = string;
    }

    public void initialize(BusComponent busComponent) throws BusException {
        s_logger.message("ServerConnection.initialize(BusComponent)");
        BusException busException = new BusException("Unexpected invocation");
    }

    public synchronized void initialize(ConnectionPoint connectionPoint) throws BusException {
        Object object;
        InetAddress inetAddress;
        s_logger.message("ServerConnection.initialize(ConnectionPoint)");
        this.m_servingURI = connectionPoint.getURI();
        if (!this.m_protocol.equals(this.m_servingURI.getProtocol())) {
            BusException busException = new BusException("Connection does not support protocol " + this.m_servingURI.getProtocol());
            s_logger.errorException(busException);
            throw busException;
        }
        try {
            inetAddress = InetAddress.getByName(Connection.getHost(this.m_servingURI));
        }
        catch (NullPointerException nullPointerException) {
            BusException busException = new BusException("Failed to locate host for " + this.m_servingURI + ": " + nullPointerException);
            s_logger.errorException(busException);
            throw busException;
        }
        catch (UnknownHostException unknownHostException) {
            BusException busException = new BusException("Failed to find host: " + unknownHostException);
            s_logger.errorException(busException);
            throw busException;
        }
        int n = this.m_servingURI.getPort();
        int n2 = 0;
        try {
            object = AdapterClientContext.getCurrent();
            n2 = ((AdapterClientConfiguration)object).getMaxReaders();
        }
        catch (OWConfigurationException oWConfigurationException) {
            n2 = 50;
        }
        object = "";
        try {
            object = connectionPoint.getPolicy();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        if ("variable".equalsIgnoreCase((String)object) && n == this.m_servingURI.getEndPort()) {
            if (n < 0) {
                n = 0;
            }
            try {
                this.m_serverSocket = this.createServerSocket(n, n2, inetAddress);
            }
            catch (IOException iOException) {
                try {
                    this.m_serverSocket = this.createServerSocket(0, n2, inetAddress);
                }
                catch (IOException iOException2) {
                    throw new NestedBusException("Cannot start socket server " + iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new NestedBusException(illegalArgumentException, "Failed to open Connection for uri " + this.m_servingURI);
                }
            }
            this.m_servingURI.setPort(this.m_serverSocket.getLocalPort());
            connectionPoint.setURI(this.m_servingURI);
        } else {
            try {
                this.m_serverSocket = this.createServerSocketInRange(n, n2, inetAddress, this.m_servingURI.getEndPort());
                this.m_servingURI.setPort(this.m_serverSocket.getLocalPort());
                connectionPoint.setURI(this.m_servingURI);
            }
            catch (IOException iOException) {
                NestedBusException nestedBusException = new NestedBusException(iOException, "Failed to open connection for uri " + this.m_servingURI);
                s_logger.errorException(nestedBusException);
                throw nestedBusException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NestedBusException nestedBusException = new NestedBusException(illegalArgumentException, "Failed to open connection for uri " + this.m_servingURI);
                s_logger.errorException(nestedBusException);
                throw nestedBusException;
            }
        }
        s_logger.message("SocketServer constructed for uri " + this.m_servingURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws BusException {
        Object object;
        s_logger.message("ServerConnection.close");
        Thread.yield();
        if (this.m_serverSocket != null) {
            try {
                this.m_serverSocket.close();
            }
            catch (IOException iOException) {
                s_logger.message("serverSocket.close");
                s_logger.errorException(iOException);
            }
            this.m_serverSocket = null;
        }
        Vector vector = this.m_readers;
        synchronized (vector) {
            while (!this.m_readers.isEmpty()) {
                object = (MessageReader)this.m_readers.firstElement();
                ((MessageReader)object).close();
            }
        }
        object = this.m_writers;
        synchronized (object) {
            while (!this.m_writers.isEmpty()) {
                Enumeration enumeration2 = this.m_writers.elements();
                if (!enumeration2.hasMoreElements()) continue;
                MessageWriter messageWriter = (MessageWriter)enumeration2.nextElement();
                messageWriter.close();
            }
        }
        Thread.yield();
    }

    public void installBusListener(BusListener busListener) throws BusException {
        s_logger.message("ServerConnection.installBusListener");
        this.m_listener = busListener;
    }

    public void send(Message message) throws BusException {
        s_logger.message("ServerConnection.send");
        MessageWriter messageWriter = MessageWriter.getMessageWriter(message, this.m_writers);
        messageWriter.send(message);
    }

    public void open() throws BusException {
        s_logger.message("ServerConnection.open");
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        block7: {
            s_logger.message("ServerConnection.run");
            try {
                if (this.m_listener == null) break block7;
                try {
                    while (true) {
                        Socket socket = this.m_serverSocket.accept();
                        MessageReader messageReader = new MessageReader(socket, this.m_listener, this, this.m_readers, this.m_writers);
                    }
                }
                catch (SocketException socketException) {
                    s_logger.message("Socket listen thread stopped due to " + socketException.getMessage());
                }
                catch (IOException iOException) {
                    s_logger.errorException(iOException);
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                s_logger.errorException(throwable);
            }
        }
    }

    private ServerSocket createServerSocketInRange(int n, int n2, InetAddress inetAddress, int n3) throws IOException, BusException {
        ServerSocket serverSocket = null;
        int n4 = n;
        while (n4 <= n3 && serverSocket == null) {
            block4: {
                try {
                    s_logger.message("Trying to open server port " + n4);
                    serverSocket = this.createServerSocket(n4, n2, inetAddress);
                    s_logger.message("Server port " + n4 + " has been opened succesfully");
                }
                catch (IOException iOException) {
                    if (n != n3) break block4;
                    throw iOException;
                }
            }
            ++n4;
        }
        if (serverSocket == null) {
            throw new IOException("Failed to open a server socket in range " + n + "-" + n3);
        }
        return serverSocket;
    }

    protected ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException, BusException {
        s_logger.message("Creating ServerSocket on port " + n);
        return new ServerSocket(n, n2, inetAddress);
    }

    public boolean isURIVariable(URI uRI) {
        return uRI.getPort() < 0 || uRI.getPort() != uRI.getEndPort();
    }
}

