/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.bidisockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.bidisockets.MessageProtocol;
import com.eibus.exception.BusException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

class MessageWriter {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.bidisockets", "MessageWriter");
    private static int s_noSent = 0;
    private Socket m_socket = null;
    private DataOutputStream m_dos = null;
    private IConnection m_connection = null;
    private Hashtable m_writers = null;
    private String m_component = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageWriter(String string, Socket socket, IConnection iConnection, Hashtable hashtable) throws BusException {
        s_logger.message("MessageWriter, Component is: " + string);
        try {
            this.m_dos = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 100000));
        }
        catch (IOException iOException) {
            throw new BusException(iOException);
        }
        this.m_component = string;
        this.m_socket = socket;
        this.m_connection = iConnection;
        Hashtable hashtable2 = this.m_writers = hashtable;
        synchronized (hashtable2) {
            this.m_writers.put(string, this);
            s_logger.flowMessage("No of writers: " + this.m_writers.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MessageWriter getMessageWriter(Message message, Hashtable hashtable) throws BusException {
        s_logger.flowMessage("MessageWriter.getMessageWriter");
        String string = MessageWriter.getReceiverComponent(message);
        s_logger.flowMessage("Find writer for component " + string);
        MessageWriter messageWriter = null;
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            messageWriter = (MessageWriter)hashtable.get(string);
        }
        if (messageWriter == null) {
            throw new BusException("No writer for component " + string);
        }
        return messageWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Message message, Socket socket, IConnection iConnection, Hashtable hashtable) throws BusException {
        s_logger.flowMessage("MessageWriter.register");
        String string = MessageWriter.getSenderComponent(message);
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            MessageWriter messageWriter = (MessageWriter)hashtable.get(string);
            if (messageWriter == null) {
                s_logger.message("Register writer for component: " + string);
                messageWriter = new MessageWriter(string, socket, iConnection, hashtable);
            }
        }
    }

    void send(Message message) throws BusException {
        s_logger.message("MessageWriter.send");
        try {
            MessageProtocol.write(this.m_dos, message);
        }
        catch (IOException iOException) {
            BusException busException = new BusException(iOException);
            s_logger.errorException(busException);
            throw busException;
        }
        s_logger.flowMessage("No of messages sent: " + ++s_noSent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() {
        s_logger.flowMessage("MessageWriter.close");
        try {
            this.m_socket.close();
            this.m_dos.close();
        }
        catch (IOException iOException) {
            s_logger.errorException(iOException);
        }
        Hashtable hashtable = this.m_writers;
        synchronized (hashtable) {
            this.m_writers.remove(this.m_component);
            s_logger.flowMessage("No of writers: " + this.m_writers.size());
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(Socket socket, Hashtable hashtable) {
        s_logger.flowMessage("MessageWriter.close");
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Enumeration enumeration2 = hashtable.elements();
            MessageWriter messageWriter = null;
            while (enumeration2.hasMoreElements()) {
                messageWriter = (MessageWriter)enumeration2.nextElement();
                if (messageWriter.m_socket == socket) break;
                messageWriter = null;
            }
            if (messageWriter != null) {
                messageWriter.close();
            }
        }
    }

    private static String getSenderComponent(Message message) throws BusException {
        s_logger.flowMessage("MessageWriter.getSenderComponent");
        return MessageWriter.getComponent(message, "sender");
    }

    private static String getReceiverComponent(Message message) throws BusException {
        s_logger.flowMessage("MessageWriter.getReceiverComponent");
        return MessageWriter.getComponent(message, "receiver");
    }

    private static String getComponent(Message message, String string) throws BusException {
        s_logger.flowMessage("MessageWriter.getComponent");
        byte[] byArray = message.getText();
        byte[] byArray2 = MessageWriter.getElement(byArray, string);
        byte[] byArray3 = MessageWriter.getElement(byArray2, "component");
        String string2 = new String(byArray3);
        s_logger.message("Component name is: " + string2);
        return string2;
    }

    private static int indexOf(byte[] byArray, byte[] byArray2) {
        return MessageWriter.indexOf(byArray, byArray2, 0);
    }

    private static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < byArray.length - byArray2.length) {
            if (MessageWriter.equals(byArray, n2, byArray2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static boolean equals(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray[n + n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static byte[] substring(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n + n3 > byArray.length) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4] = byArray[n + n4];
            ++n4;
        }
        return byArray2;
    }

    private static byte[] getElement(byte[] byArray, String string) throws BusException {
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = new String("<" + string + ">").getBytes();
        byte[] byArray4 = new String("</" + string + ">").getBytes();
        int n = MessageWriter.indexOf(byArray, byArray3);
        if (n < 0) {
            throw new BusException("Tag not found: " + byArray3);
        }
        int n2 = MessageWriter.indexOf(byArray, byArray4, n += byArray3.length);
        if (n2 < 0) {
            throw new BusException("Tag not found: " + byArray4);
        }
        byte[] byArray5 = MessageWriter.substring(byArray, n, n2);
        return byArray5;
    }
}

