/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.bidisockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.NotHandledException;
import com.eibus.connection.bidisockets.MessageProtocol;
import com.eibus.connection.bidisockets.MessageWriter;
import com.eibus.connection.bidisockets.ServerConnection;
import com.eibus.exception.BusException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Vector;

class MessageReader
extends Thread {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.bidisockets", "MessageReader");
    private static int s_threadInstance = 0;
    private static int s_noReceived = 0;
    private Socket m_socket;
    private DataInputStream m_inputStream;
    private BusListener m_listener;
    private IConnection m_connection = null;
    private Vector m_readers = null;
    private Hashtable m_writers = null;
    private boolean running = true;

    MessageReader(Socket socket, BusListener busListener) throws BusException {
        this(socket, busListener, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageReader(Socket socket, BusListener busListener, IConnection iConnection, Vector vector, Hashtable hashtable) throws BusException {
        super("MessageReader" + s_threadInstance++);
        this.setDaemon(true);
        this.m_listener = busListener;
        this.m_socket = socket;
        this.m_connection = iConnection;
        this.m_readers = vector;
        this.m_writers = hashtable;
        try {
            this.m_socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            s_logger.errorMessage("Could not set tcp-no-delay: " + socketException);
        }
        try {
            this.m_inputStream = new DataInputStream(new BufferedInputStream(this.m_socket.getInputStream(), 100000));
            this.m_socket.setSoTimeout(0);
        }
        catch (IOException iOException) {
            BusException busException = new BusException("Could not open input stream on reading socket " + iOException);
            s_logger.errorException(busException);
            throw busException;
        }
        if (this.m_readers != null) {
            Vector vector2 = this.m_readers;
            synchronized (vector2) {
                this.m_readers.addElement(this);
                s_logger.flowMessage("Added reader, no of readers: " + this.m_readers.size());
            }
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        s_logger.flowMessage("MessageReader.run");
        try {
            while (this.running) {
                try {
                    Message message = MessageProtocol.read(this.m_inputStream);
                    s_logger.flowMessage("No of messages received: " + ++s_noReceived);
                    s_logger.message("Received " + message.getText().length + " on " + this.m_socket);
                    if (s_logger.isFlowEnabled()) {
                        s_logger.flowBytes(message.getText());
                    }
                    if (this.m_connection instanceof ServerConnection) {
                        MessageWriter.register(message, this.m_socket, this.m_connection, this.m_writers);
                    }
                    if (this.m_listener == null) continue;
                    try {
                        this.m_listener.onReceive(message);
                    }
                    catch (NotHandledException notHandledException) {
                        s_logger.errorMessage("Listener did not handle message. Ignoring it. Exception: " + notHandledException);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    s_logger.errorMessage("Timeout for waiting on data expired." + interruptedIOException);
                    break;
                }
                catch (IOException iOException) {
                    s_logger.flowMessage("Ignoring IO/Socket Exception, " + iOException.getMessage());
                    break;
                }
                catch (Exception exception) {
                    s_logger.errorException(exception);
                    break;
                }
            }
            s_logger.flowMessage("Ready processing, stopping reader thread");
            Object var5_6 = null;
            this.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() {
        s_logger.flowMessage("MessageReader.close");
        if (this.m_socket != null) {
            try {
                this.running = false;
                this.m_socket.close();
                this.m_inputStream.close();
            }
            catch (IOException iOException) {
                s_logger.errorException(iOException);
            }
        }
        if (this.m_readers != null) {
            Vector vector = this.m_readers;
            synchronized (vector) {
                this.m_readers.removeElement(this);
                s_logger.flowMessage("Removed reader, no of readers: " + this.m_readers.size());
            }
        }
        if (this.m_writers != null) {
            MessageWriter.close(this.m_socket, this.m_writers);
        }
        this.m_inputStream = null;
        this.m_socket = null;
        Thread.yield();
    }
}

