/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.bidisockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.Message;
import com.eibus.services.profiling.DefaultTimerFactory;
import com.eibus.services.profiling.Timer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class MessageProtocol {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.bidisockets", "MessageProtocol");
    private static final int STREAM_CLOSED = -1;
    private static final byte MAGIC_NUMBER = 7;
    private static final DefaultTimerFactory s_timerFactory = DefaultTimerFactory.getInstance();

    MessageProtocol() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(DataOutputStream dataOutputStream, Message message) throws IOException {
        Object object;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        synchronized (dataOutputStream2) {
            dataOutputStream.write(7);
            object = message.getText();
            dataOutputStream.writeInt(((byte[])object).length);
            dataOutputStream.write((byte[])object);
            dataOutputStream.flush();
        }
        object = message.getITimer();
        if (object != null) {
            object.split("message sent");
        }
    }

    static Message read(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        if (n == -1) {
            throw new IOException("Encountered a closed message-stream ?!");
        }
        if (n != 7) {
            s_logger.errorMessage("Client uses invalid or outdated protocol");
        }
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        Message message = new Message(byArray);
        Timer timer = DefaultTimerFactory.newTimer("handle request");
        message.setITimer(timer);
        return message;
    }
}

