/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.bidisockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.bidisockets.ClientConnection;
import com.eibus.connection.bidisockets.ServerConnection;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class Connection
implements IConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.bidisockets", "Connection");
    protected String m_protocol = "bidisocket";
    static final String VARIABLE_POLICY = "variable";
    static final int BUFFER_SIZE = 100000;
    static final int DEFAULT_BACKLOG = 50;
    static final int SOCKET_TIMEOUT = 0;
    private static final String LOCALHOST = "localhost";
    protected boolean m_isClientConnection = false;
    protected IConnection m_connection = null;

    public Connection() {
        s_logger.flowMessage("Connection()");
    }

    public Connection(String string) {
        s_logger.flowMessage("Connection(String)");
        this.m_protocol = string;
    }

    public void initialize(BusComponent busComponent) throws BusException {
        s_logger.flowMessage("Connection.initialize(BusComponent)");
        ConnectionPoint connectionPoint = this.getBiDiSocketCP(busComponent);
        connectionPoint.isClientConnection(busComponent.isClientComponent());
        this.initialize(connectionPoint);
    }

    public void initialize(ConnectionPoint connectionPoint) throws BusException {
        s_logger.flowMessage("Connection.initialize(ConnectionPoint)");
        URI uRI = connectionPoint.getURI();
        uRI.setHost(Connection.getHost(uRI));
        connectionPoint.setURI(uRI);
        this.m_isClientConnection = connectionPoint.isClientConnection();
        if (this.m_isClientConnection) {
            this.m_connection = new ClientConnection();
            this.m_connection.initialize(connectionPoint);
        } else {
            this.m_connection = new ServerConnection(this.m_protocol);
            this.m_connection.initialize(connectionPoint);
        }
    }

    public void close() throws BusException {
        s_logger.flowMessage("Connection.close");
        this.m_connection.close();
    }

    public void open() throws BusException {
        s_logger.flowMessage("Connection.open");
        this.m_connection.open();
    }

    public void installBusListener(BusListener busListener) throws BusException {
        s_logger.flowMessage("Connection.installBusListener");
        this.m_connection.installBusListener(busListener);
    }

    public void send(Message message) throws BusException {
        String string = "*unknown*";
        URI uRI = message.getURI();
        if (uRI != null) {
            string = "" + uRI;
        }
        s_logger.message("Sending " + message.getText().length + " bytes to " + string);
        if (s_logger.isFlowEnabled()) {
            s_logger.flowBytes(message.getText());
        }
        this.m_connection.send(message);
    }

    private ConnectionPoint getBiDiSocketCP(BusComponent busComponent) throws BusException {
        Serializable serializable;
        s_logger.flowMessage("Connection.getBiDiSocketCP");
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        while (enumeration2.hasMoreElements()) {
            try {
                serializable = (ConnectionPoint)enumeration2.nextElement();
                if (!this.m_protocol.equals(((ConnectionPoint)serializable).getURI().getProtocol())) continue;
                s_logger.flowMessage("Found connectionpoint with URI: " + ((ConnectionPoint)serializable).getURI());
                return serializable;
            }
            catch (MalformedURIException malformedURIException) {
                s_logger.errorException(malformedURIException);
            }
        }
        serializable = new BusException("Cannot find matching connectionpoint for buscomponent " + busComponent.getIdentifier());
        s_logger.errorException((Throwable)serializable);
        throw serializable;
    }

    protected static String getHost(URI uRI) throws BusException {
        String string = uRI.getHost();
        if (LOCALHOST.equals(string)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                BusException busException = new BusException(unknownHostException);
                s_logger.errorException(busException);
                throw busException;
            }
        }
        return string;
    }

    public boolean isURIVariable(URI uRI) {
        return uRI.getPort() < 0 || uRI.getPort() != uRI.getEndPort();
    }
}

