/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection.bidisockets;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.bidisockets.Connection;
import com.eibus.connection.bidisockets.MessageProtocol;
import com.eibus.connection.bidisockets.MessageReader;
import com.eibus.exception.BusException;
import com.eibus.exception.NestedBusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;

public class ClientConnection
implements IConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection.bidisockets", "ClientConnection");
    private ConnectionPoint m_connectionPoint = null;
    private Socket m_clientSocket = null;
    private DataOutputStream m_dos = null;
    private BusListener m_listener = null;
    private MessageReader m_reader = null;

    public ClientConnection() {
        s_logger.message("ClientConnection");
    }

    public void initialize(BusComponent busComponent) throws BusException {
        s_logger.flowMessage("ClientConnection.initialize(BusComponent)");
        BusException busException = new BusException("Unexpected invocation");
    }

    public void initialize(ConnectionPoint connectionPoint) throws BusException {
        s_logger.flowMessage("ClientConnection.initialize(ConnectionPoint)");
        this.m_connectionPoint = connectionPoint;
    }

    public void close() throws BusException {
        s_logger.flowMessage("ClientConnection.close");
        if (this.m_reader != null) {
            Thread.yield();
            this.m_reader.close();
        }
        if (this.m_dos != null) {
            try {
                this.m_dos.close();
            }
            catch (IOException iOException) {
                s_logger.errorException(iOException);
            }
        }
        this.m_reader = null;
        this.m_dos = null;
        Thread.yield();
    }

    public void open() throws BusException {
        s_logger.message("ClientConnection.open");
    }

    public void installBusListener(BusListener busListener) throws BusException {
        s_logger.flowMessage("ClientConnection.installBusListener");
        this.m_listener = busListener;
    }

    public void send(Message message) throws BusException {
        s_logger.flowMessage("ClientConnection.send");
        try {
            if (this.m_reader != null && !this.m_reader.isAlive()) {
                this.m_clientSocket = null;
                this.m_dos = null;
                this.m_reader = null;
            }
            if (this.m_clientSocket == null) {
                this.m_clientSocket = this.openSocket(message);
                this.m_dos = new DataOutputStream(new BufferedOutputStream(this.m_clientSocket.getOutputStream(), 100000));
                this.m_reader = new MessageReader(this.m_clientSocket, this.m_listener);
            }
            MessageProtocol.write(this.m_dos, message);
        }
        catch (IOException iOException) {
            s_logger.errorException(iOException);
        }
    }

    private Socket openSocket(Message message) throws BusException {
        s_logger.flowMessage("ClientConnection.openSocket");
        Socket socket = null;
        URI uRI = this.m_connectionPoint.getURI();
        String string = Connection.getHost(uRI);
        int n = uRI.getPort();
        int n2 = uRI.getEndPort();
        URI uRI2 = message.getURI();
        String string2 = Connection.getHost(uRI2);
        int n3 = uRI2.getPort();
        String string3 = this.m_connectionPoint.getPolicy();
        s_logger.message("Client URI: " + uRI);
        s_logger.message("Server URI: " + uRI2);
        s_logger.message("Policy: " + string3);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if ("variable".equalsIgnoreCase(string3)) {
                if (n < 0) {
                    n = 0;
                }
                try {
                    socket = this.createSocket(string2, n3, inetAddress, n);
                }
                catch (IOException iOException) {
                    socket = this.createSocket(string2, n3, inetAddress, 0);
                }
            } else {
                if (n <= 0 || n2 > 0 && n >= n2) {
                    throw new BusException("Invalid port in uri " + uRI);
                }
                socket = this.createSocketInRange(string2, n3, inetAddress, n, n2 < 0 ? n : n2);
            }
            URI uRI3 = this.m_connectionPoint.getURI();
            uRI3.setPort(socket.getLocalPort());
            this.m_connectionPoint.setURI(uRI3);
        }
        catch (IOException iOException) {
            NestedBusException nestedBusException = new NestedBusException(iOException, "Failed to open connection");
            s_logger.errorException(nestedBusException);
            throw nestedBusException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NestedBusException nestedBusException = new NestedBusException(illegalArgumentException, "Failed to open connection");
            s_logger.errorException(nestedBusException);
            throw nestedBusException;
        }
        catch (BusException busException) {
            throw busException;
        }
        s_logger.message("Client socket opened on local port " + socket.getLocalPort());
        return socket;
    }

    private Socket createSocketInRange(String string, int n, InetAddress inetAddress, int n2, int n3) throws IOException, BusException {
        Socket socket = null;
        int n4 = n2;
        while (n4 <= n3 && socket == null) {
            try {
                s_logger.flowMessage("Trying to open port " + n4);
                socket = this.createSocket(string, n, inetAddress, n4);
                s_logger.flowMessage("Port " + n4 + " has been opened succesfully");
            }
            catch (ConnectException connectException) {
                s_logger.errorMessage("Failed to connect to remote host using local port " + n4 + ": " + connectException);
                throw connectException;
            }
            catch (IOException iOException) {
                if (n2 == n3) {
                    throw iOException;
                }
            }
            catch (BusException busException) {
                throw busException;
            }
            ++n4;
        }
        if (socket == null) {
            throw new IOException("Failed to open a socket in range " + n2 + "-" + n3);
        }
        return socket;
    }

    protected Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, BusException {
        return new Socket(string, n, inetAddress, n2);
    }

    public boolean isURIVariable(URI uRI) {
        return uRI.getPort() < 0 || uRI.getPort() != uRI.getEndPort();
    }
}

