/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.ConnectionProvider;
import com.eibus.connection.IConnection;
import com.eibus.exception.BusException;
import com.eibus.exception.ExceptionGroup;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Middleware {
    private static final String EXID_STARTFAILED = "com.eibus.connection.Middleware.startFailed";
    private static final String EXDM_STARTFAILED = "Failed to start connection point";
    private static final String EXID_CLOSEFAILED = "com.eibus.connection.Middleware.closeFailed";
    private static final String EXDM_CLOSEFAILED = "Could not close connection for protocol {0}";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.connection", "Middleware");
    private static final boolean PRINT_DEBUG_INFO = false;
    Dictionary connectionsPerProtocol = new Hashtable();
    BusComponent component;
    BusListener listener;

    public Middleware(BusComponent busComponent, BusListener busListener) throws ExceptionGroup {
        Object[] objectArray;
        Cloneable cloneable;
        s_logger.message("Starting middleware for component " + busComponent.getIdentifier());
        this.component = busComponent;
        this.listener = busListener;
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        Vector<BusException> vector = new Vector<BusException>();
        Vector<Cloneable> vector2 = new Vector<Cloneable>();
        while (enumeration2.hasMoreElements()) {
            cloneable = (ConnectionPoint)enumeration2.nextElement();
            ((ConnectionPoint)cloneable).isClientConnection(busComponent.isClientComponent());
            try {
                if (((ConnectionPoint)cloneable).getURI().getProtocol().equals("socket")) {
                    vector2.insertElementAt(cloneable, 0);
                    continue;
                }
                vector2.addElement(cloneable);
            }
            catch (BusException busException) {
                vector2.addElement(cloneable);
            }
        }
        enumeration2 = vector2.elements();
        cloneable = new Vector();
        while (enumeration2.hasMoreElements()) {
            objectArray = (Object[])enumeration2.nextElement();
            try {
                String string = objectArray.getURI().getProtocol();
                IConnection iConnection = ConnectionProvider.getConnection(string, busComponent);
                String string2 = objectArray.getURI().toString();
                iConnection.initialize((ConnectionPoint)objectArray);
                String string3 = objectArray.getURI().toString();
                if (string2 != null && !string2.equalsIgnoreCase(string3)) {
                    s_logger.message("URI Before initialization '" + string2 + "', after '" + string3 + "'");
                }
                ((Vector)cloneable).addElement(objectArray);
                iConnection.installBusListener(busListener);
                iConnection.open();
                this.connectionsPerProtocol.put(string, iConnection);
                s_logger.message("Started and stored a connection for protocol " + string);
            }
            catch (BusException busException) {
                vector.addElement(busException);
                s_logger.errorMessage("com.eibus.connection.Middleware.startFailed, Failed to start connection point");
                s_logger.errorException(busException);
            }
        }
        s_logger.flowMessage("Storing the (changed) Connections back into the buscomponent");
        busComponent.setConnectionPoints((Vector)cloneable);
        if (this.connectionsPerProtocol.size() <= 0) {
            objectArray = new Throwable[vector.size()];
            vector.copyInto(objectArray);
            throw new ExceptionGroup("Failed to start any connection point: ", (Throwable[])objectArray);
        }
    }

    public void close() throws BusException {
        s_logger.message("Closing middleware for component " + this.component.getIdentifier());
        Enumeration enumeration2 = this.connectionsPerProtocol.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            IConnection iConnection = (IConnection)this.connectionsPerProtocol.remove(string);
            try {
                iConnection.close();
            }
            catch (BusException busException) {
                s_logger.errorMessage("com.eibus.connection.Middleware.closeFailed, Could not close connection for protocol {0}");
                s_logger.errorException(busException);
                this.connectionsPerProtocol.put(string, iConnection);
            }
        }
    }

    public IConnection getConnected(URI uRI) throws BusException {
        if (uRI == null) {
            throw new BusException();
        }
        String string = uRI.getProtocol();
        if (string == null) {
            String string2 = "Cannot connect to a URI without a protocol (" + uRI + ")";
            s_logger.errorMessage(string2);
            throw new BusException(string2);
        }
        IConnection iConnection = (IConnection)this.connectionsPerProtocol.get(string);
        if (iConnection == null) {
            String string3 = "Cannot connect to uri (" + uRI + "), protocol not supported or protocol mismatch between client and server";
            s_logger.errorMessage(string3);
            throw new BusException(string3);
        }
        s_logger.flowMessage("Found middleware for uri " + uRI);
        return iConnection;
    }

    public BusListener getBusListener() {
        return this.listener;
    }
}

