/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.connection;

import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.URI;
import com.eibus.services.profiling.DefaultTimerFactory;
import com.eibus.services.profiling.ITimer;
import com.eibus.services.security.BusDocDigest;
import java.io.UnsupportedEncodingException;

public class Message {
    private static final DefaultTimerFactory s_timerFactory = DefaultTimerFactory.getInstance();
    private BusComponent receiver;
    private URI uri;
    private byte[] text;
    private int _iMDStart = 0;
    private ITimer m_timer = DefaultTimerFactory.newTimer("message object created");

    public Message(byte[] byArray, BusComponent busComponent) {
        this.text = byArray;
        this.receiver = busComponent;
    }

    public Message(byte[] byArray) {
        this.text = byArray;
    }

    public Message(byte[] byArray, URI uRI) {
        this.text = byArray;
        this.uri = uRI;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uRI) {
        this.uri = uRI;
    }

    public BusComponent getReceiver() {
        return this.receiver;
    }

    public void setReceiver(BusComponent busComponent) {
        this.receiver = busComponent;
    }

    public void setText(byte[] byArray) {
        this.text = byArray;
    }

    public byte[] getText() {
        return this.text;
    }

    public Message copy() {
        byte[] byArray = new byte[this.text.length];
        System.arraycopy(this.text, 0, byArray, 0, this.text.length);
        Message message = new Message(byArray);
        message.uri = this.uri;
        message.receiver = this.receiver;
        return message;
    }

    public String toString() {
        try {
            return new String(this.text, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.text);
        }
    }

    public boolean HasMessageDigest() {
        if (this._iMDStart == 0) {
            this._iMDStart = BusDocDigest.hasBusDocDigest(this.text);
        }
        return this._iMDStart != -1;
    }

    public boolean CheckMessageDigest() {
        if (this.HasMessageDigest()) {
            return BusDocDigest.checkBusDocDigest(this.text, this._iMDStart);
        }
        return false;
    }

    public boolean addMessageDigest() {
        if (this.HasMessageDigest()) {
            return BusDocDigest.addBusDocDigest2BusDocText(this.text, this._iMDStart);
        }
        return false;
    }

    public String findBusDocMessageID() {
        try {
            int n = this.indexOfMsgIDStart();
            if (n < 0) {
                return null;
            }
            int n2 = this.indexOfMsgIDEnd(n);
            if (n2 < 0) {
                return null;
            }
            int n3 = n2 - n;
            byte[] byArray = new byte[n3];
            int n4 = 0;
            while (n4 < n3) {
                byArray[n4] = this.text[n + n4];
                ++n4;
            }
            String string = new String(byArray);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int indexOfMsgIDStart() {
        int n = 15;
        while (n < this.text.length) {
            if (this.text[n] == 60 && this.text[n + 1] == 109 && this.text[n + 2] == 115 && this.text[n + 3] == 103 && this.text[n + 4] == 45 && this.text[n + 5] == 105 && this.text[n + 6] == 100 && this.text[n + 7] == 62) {
                return n + 8;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfMsgIDEnd(int n) {
        int n2 = n;
        while (n2 < this.text.length) {
            if (this.text[n2] == 60 && this.text[n2 + 1] == 47 && this.text[n2 + 2] == 109 && this.text[n2 + 3] == 115 && this.text[n2 + 4] == 103 && this.text[n2 + 5] == 45 && this.text[n2 + 6] == 105 && this.text[n2 + 7] == 100 && this.text[n2 + 8] == 62) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setITimer(ITimer iTimer) {
        this.m_timer = iTimer;
    }

    public ITimer getITimer() {
        return this.m_timer;
    }
}

