/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.co.BusinessElement;
import com.eibus.co.BusinessElementLink;
import com.eibus.co.SynchronizationError;
import com.eibus.co.Tuple;
import com.eibus.co.parser.BusinessElementHandler;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.GenericHandler;
import com.eibus.co.parser.SAXHandler;
import com.eibus.co.parser.SynchronizationErrorHandler;

public class TupleHandler
extends SAXHandler {
    static final int TUPLE = 2;
    static final int ORIGINAL = 3;
    static final int CURRENT = 4;
    static final int BUSINESS_ELEMENT_IN_ORIGINAL = 5;
    static final int BUSINESS_ELEMENT_IN_CURRENT = 6;
    static final int ERROR = 7;
    static final int WARNING = 8;
    private BusinessElementHandler businessElementHandler;
    private SynchronizationErrorHandler errorHandler;
    private GenericHandler genericHandler;
    private Tuple current = null;

    public TupleHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
        this.businessElementHandler = new BusinessElementHandler(eventDelegator);
        this.errorHandler = new SynchronizationErrorHandler(eventDelegator);
        this.genericHandler = new GenericHandler(eventDelegator);
    }

    public Tuple getTuple() {
        return this.current;
    }

    public void reset() {
        this.context = 1;
        this.current = null;
        this.businessElementHandler.reset();
        this.errorHandler.reset();
        this.genericHandler.reset();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.context) {
            case 1: {
                this.delegator.activate(this);
                this.context = 2;
                this.current = this.delegator.factory.createTuple();
                int n = attributeList.getLength();
                if (n <= 0) break;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = attributeList.getName(n2);
                    String string3 = attributeList.getValue(n2);
                    if (string2.equals("id")) {
                        BusinessElementLink businessElementLink = this.delegator.busdoc.getLink(string3);
                        businessElementLink.setTuple(this.current);
                        this.current.setLink(businessElementLink);
                    } else {
                        this.current.setAttribute(string2, string3);
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                if (string.equals("old")) {
                    this.context = 3;
                    break;
                }
                if (string.equals("new")) {
                    this.context = 4;
                    break;
                }
                if (string.equals("error")) {
                    this.context = 7;
                    break;
                }
                if (string.equals("warning")) {
                    this.context = 8;
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                this.current.appendChild(this.genericHandler.getElement());
                break;
            }
            case 3: {
                this.businessElementHandler.context = 1;
                this.businessElementHandler.startElement(string, attributeList);
                BusinessElement businessElement = this.businessElementHandler.getBusinessElement();
                this.current.setOriginal(businessElement);
                break;
            }
            case 4: {
                this.businessElementHandler.context = 1;
                this.businessElementHandler.startElement(string, attributeList);
                BusinessElement businessElement = this.businessElementHandler.getBusinessElement();
                this.current.setCurrent(businessElement);
                break;
            }
            case 7: 
            case 8: {
                this.errorHandler.context = 1;
                this.errorHandler.startElement(string, attributeList);
                SynchronizationError synchronizationError = this.errorHandler.getError();
                this.current.addError(synchronizationError);
                if (!synchronizationError.isError()) break;
                this.delegator.busdoc.addError(synchronizationError);
                break;
            }
            default: {
                this.genericHandler.startElement(string, attributeList);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        switch (this.context) {
            case 2: {
                this.delegator.deActivate(this);
                this.context = 1;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.context = 2;
                break;
            }
            case 5: {
                this.context = 3;
                break;
            }
            case 6: {
                this.context = 4;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public String toString() {
        return "TupleHandler(" + this.context + ")";
    }
}

