/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.GenericHandler;
import com.eibus.co.parser.SAXHandler;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;

public class ReceiverHandler
extends SAXHandler {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.co.parser", "ReceiverHandler");
    static final int RECEIVER = 2;
    static final int COMPONENT = 3;
    static final int SENT_TO = 4;
    private GenericHandler genericHandler;
    private BusComponent component = null;
    private URI sentTo = null;

    public ReceiverHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
        this.genericHandler = new GenericHandler(eventDelegator);
    }

    public BusComponent getComponent() {
        return this.component;
    }

    public URI getSentTo() {
        return this.sentTo;
    }

    public void reset() {
        this.context = 1;
        this.component = null;
        this.sentTo = null;
        this.genericHandler.reset();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.context) {
            case 1: {
                this.delegator.activate(this);
                this.context = 2;
                break;
            }
            case 2: {
                if (string.equals("component")) {
                    this.context = 3;
                    break;
                }
                if (string.equals("sent-to")) {
                    this.context = 4;
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                break;
            }
            default: {
                this.genericHandler.startElement(string, attributeList);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        switch (this.context) {
            case 2: {
                this.delegator.deActivate(this);
                this.context = 1;
                break;
            }
            case 3: 
            case 4: {
                this.context = 2;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.context) {
            case 3: {
                String string = new String(cArray, n, n2);
                this.component = new BusComponent(string, string);
                break;
            }
            case 4: {
                try {
                    String string = new String(cArray, n, n2);
                    this.sentTo = URI.createURI(string);
                }
                catch (MalformedURIException malformedURIException) {
                    s_logger.message("Warning: sent-to is not a valid uri: " + malformedURIException);
                }
                break;
            }
        }
    }

    public String toString() {
        return "ReceiverHandler(" + this.context + ")";
    }
}

