/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.co.Header;
import com.eibus.co.Receiver;
import com.eibus.co.Sender;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.GenericHandler;
import com.eibus.co.parser.ReceiverHandler;
import com.eibus.co.parser.SAXHandler;
import com.eibus.co.parser.SenderHandler;
import com.eibus.exception.BusException;
import com.eibus.services.guid.Guid;

public class HeaderHandler
extends SAXHandler {
    static final int HEADER = 2;
    static final int MESSAGE_ID = 3;
    static final int TRANSACTION_ID = 4;
    static final int PROCESS_ID = 5;
    private SenderHandler senderHandler;
    private ReceiverHandler receiverHandler;
    private GenericHandler genericHandler;
    private String transactionId = null;
    private Guid guid = null;
    private String processId;

    public HeaderHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
        this.senderHandler = new SenderHandler(eventDelegator);
        this.receiverHandler = new ReceiverHandler(eventDelegator);
        this.genericHandler = new GenericHandler(eventDelegator);
    }

    public void reset() {
        this.context = 1;
        this.guid = null;
        this.transactionId = null;
        this.processId = null;
        this.senderHandler.reset();
        this.receiverHandler.reset();
        this.genericHandler.reset();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.context) {
            case 1: {
                this.delegator.activate(this);
                this.context = 2;
                break;
            }
            case 2: {
                if (string.equals("sender")) {
                    this.senderHandler.context = 1;
                    this.senderHandler.startElement(string, attributeList);
                    break;
                }
                if (string.equals("receiver")) {
                    this.receiverHandler.context = 1;
                    this.receiverHandler.startElement(string, attributeList);
                    break;
                }
                if (string.equals("msg-id")) {
                    this.context = 3;
                    break;
                }
                if (string.equals("transaction-id")) {
                    this.context = 4;
                    break;
                }
                if (string.equals("process-id")) {
                    this.context = 5;
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                break;
            }
            default: {
                this.genericHandler.startElement(string, attributeList);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        switch (this.context) {
            case 2: {
                this.delegator.deActivate(this);
                this.context = 1;
                try {
                    this.delegator.setManager(this.guid);
                }
                catch (BusException busException) {
                    throw new SAXException("Failed to find a manager for message with id " + this.guid + ", exception is: " + busException.toString());
                }
                this.delegator.busdoc = this.delegator.factory.createBusDoc();
                Header header = this.delegator.busdoc.getHeader();
                if (this.guid != null) {
                    header.setCorrelationId(this.guid);
                }
                if (this.transactionId != null) {
                    header.setTransactionId(this.transactionId);
                }
                if (this.processId != null) {
                    header.setProcessId(this.processId);
                }
                Sender sender = header.getSender();
                if (this.senderHandler.getComponent() != null) {
                    sender.setComponent(this.senderHandler.getComponent());
                }
                if (this.senderHandler.getReplyTo() != null) {
                    sender.setReplyTo(this.senderHandler.getReplyTo());
                }
                Receiver receiver = header.getReceiver();
                if (this.receiverHandler.getComponent() != null) {
                    receiver.setComponent(this.receiverHandler.getComponent());
                }
                if (this.receiverHandler.getSentTo() != null) {
                    receiver.setSentTo(this.receiverHandler.getSentTo());
                }
                this.reset();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.context = 2;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.context) {
            case 3: {
                String string = new String(cArray, n, n2);
                this.guid = Guid.createGuid(string);
                break;
            }
            case 4: {
                this.transactionId = new String(cArray, n, n2);
                break;
            }
            case 5: {
                this.processId = new String(cArray, n, n2);
                break;
            }
        }
    }

    public String toString() {
        return "HeaderHandler(" + this.context + ")";
    }
}

