/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.parser.BusDocHandler;
import com.eibus.co.parser.SAXHandler;
import com.eibus.exception.BusException;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.Registry;

public class EventDelegator
extends SAXHandler {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.co.parser", "EventDelegator");
    BusDocHandler busdocHandler;
    BusDoc busdoc;
    Guid guid;
    BusDocFactory factory;
    BusinessDocumentManager manager;
    int topPointer = -1;
    SAXHandler[] stack = new SAXHandler[256];

    public EventDelegator() throws BusException {
        this.busdocHandler = new BusDocHandler(this);
        this.activate(this.busdocHandler);
    }

    public BusDoc getBusDoc() {
        return this.busdoc;
    }

    public void startDocument() throws SAXException {
        this.busdocHandler.context = 1;
    }

    public void reset() {
        this.clearStack();
        this.busdoc = null;
        this.guid = null;
        this.busdocHandler.reset();
        this.activate(this.busdocHandler);
    }

    void setManager(Guid guid) throws BusException {
        this.manager = (BusinessDocumentManager)Registry.getManager(guid, null, null);
        if (this.manager == null) {
            s_logger.flowMessage("Using default manager and factory to parse message with id " + guid);
            this.manager = (BusinessDocumentManager)Registry.getDefaultManager();
        }
        this.factory = this.manager.getFactory();
    }

    public void endDocument() throws SAXException {
        if (this.busdoc == null) {
            throw new SAXException("Failed to construct a BusDoc, although document was parsed");
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.stack[this.topPointer].startElement(string, attributeList);
    }

    String printStackTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= this.topPointer) {
            stringBuffer.append("[" + n + "-" + this.stack[n] + "],");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void endElement(String string) throws SAXException {
        this.stack[this.topPointer].endElement(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stack[this.topPointer].characters(cArray, n, n2);
    }

    private void push(SAXHandler sAXHandler) {
        if (this.topPointer >= this.stack.length) {
            this.enlarge();
        }
        ++this.topPointer;
        this.stack[this.topPointer] = sAXHandler;
    }

    private void pop() {
        this.topPointer = this.topPointer > 0 ? --this.topPointer : -1;
    }

    private void clearStack() {
        this.topPointer = -1;
    }

    private void enlarge() {
        SAXHandler[] sAXHandlerArray = this.stack;
        this.stack = new SAXHandler[sAXHandlerArray.length * 2];
        System.arraycopy(sAXHandlerArray, 0, this.stack, 0, this.stack.length);
    }

    public void activate(SAXHandler sAXHandler) {
        this.push(sAXHandler);
    }

    public void deActivate(SAXHandler sAXHandler) {
        if (this.stack[this.topPointer] == sAXHandler) {
            this.pop();
        }
    }
}

