/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.co.BusError;
import com.eibus.co.Constructor;
import com.eibus.co.Data;
import com.eibus.co.DataSet;
import com.eibus.co.MetaData;
import com.eibus.co.SQLError;
import com.eibus.co.Tuple;
import com.eibus.co.Update;
import com.eibus.co.parser.ConstructorHandler;
import com.eibus.co.parser.DataHandler;
import com.eibus.co.parser.ErrorHandler;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.GenericHandler;
import com.eibus.co.parser.MetaDataHandler;
import com.eibus.co.parser.SAXHandler;
import com.eibus.co.parser.SQLErrorHandler;
import com.eibus.co.parser.TupleHandler;

public class DataSetHandler
extends SAXHandler {
    static final int DATASET = 2;
    private TupleHandler tupleHandler;
    private DataHandler dataHandler;
    private SQLErrorHandler sqlErrorHandler;
    private ErrorHandler errorHandler;
    private ConstructorHandler constructorHandler;
    private MetaDataHandler metaDataHandler;
    private GenericHandler genericHandler;
    private DataSet current;

    public DataSetHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
        this.tupleHandler = new TupleHandler(eventDelegator);
        this.dataHandler = new DataHandler(eventDelegator);
        this.sqlErrorHandler = new SQLErrorHandler(eventDelegator);
        this.errorHandler = new ErrorHandler(eventDelegator);
        this.constructorHandler = new ConstructorHandler(eventDelegator);
        this.metaDataHandler = new MetaDataHandler(eventDelegator);
        this.genericHandler = new GenericHandler(eventDelegator);
    }

    public DataSet getDataSet() {
        return this.current;
    }

    public void reset() {
        this.context = 1;
        this.current = null;
        this.tupleHandler.reset();
        this.dataHandler.reset();
        this.sqlErrorHandler.reset();
        this.errorHandler.reset();
        this.constructorHandler.reset();
        this.metaDataHandler.reset();
        this.genericHandler.reset();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.context) {
            case 1: {
                this.delegator.activate(this);
                this.context = 2;
                if (string.equals("dataset")) {
                    this.current = this.delegator.factory.createDataSet();
                    this.delegator.busdoc.addCO(this.current);
                    break;
                }
                this.current = this.delegator.factory.createUpdate();
                this.delegator.busdoc.addCO(this.current);
                int n = attributeList.getLength();
                if (n <= 0) break;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = attributeList.getName(n2);
                    String string3 = attributeList.getValue(n2);
                    if (string2.equals("unconditional") && string3.equals("true")) {
                        ((Update)this.current).setUnconditional(true);
                    }
                    if (string2.equals("transactionscope")) {
                        if (string3.equalsIgnoreCase("global")) {
                            ((Update)this.current).setTransactionScope(1);
                        } else if (string3.equalsIgnoreCase("manager")) {
                            ((Update)this.current).setTransactionScope(2);
                        } else if (string3.equalsIgnoreCase("businessobject")) {
                            ((Update)this.current).setTransactionScope(3);
                        } else {
                            ((Update)this.current).setTransactionScope(2);
                        }
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                if (string.equals("constructor")) {
                    this.constructorHandler.context = 1;
                    this.constructorHandler.startElement(string, attributeList);
                    Constructor constructor = this.constructorHandler.getConstructor();
                    this.current.setRequest(constructor);
                    break;
                }
                if (string.equals("tuple")) {
                    this.tupleHandler.context = 1;
                    this.tupleHandler.startElement(string, attributeList);
                    Tuple tuple = this.tupleHandler.getTuple();
                    this.current.addTuple(tuple);
                    break;
                }
                if (string.equals("data")) {
                    this.dataHandler.context = 1;
                    this.dataHandler.startElement(string, attributeList);
                    Data data = this.dataHandler.getData();
                    this.current.addData(data);
                    break;
                }
                if (string.equals("metadata")) {
                    this.metaDataHandler.context = 1;
                    this.metaDataHandler.startElement(string, attributeList);
                    MetaData metaData = this.metaDataHandler.getMetaData();
                    this.current.setMetaData(metaData);
                    break;
                }
                if (string.equals("sqlError")) {
                    this.sqlErrorHandler.context = 1;
                    this.sqlErrorHandler.startElement(string, attributeList);
                    SQLError sQLError = this.sqlErrorHandler.getData();
                    this.current.setSQLError(sQLError);
                    break;
                }
                if (string.equals("error") || string.equals("warning")) {
                    this.errorHandler.context = 1;
                    this.errorHandler.startElement(string, attributeList);
                    BusError busError = this.errorHandler.getError();
                    busError.setErrorType(2);
                    this.current.appendChild(busError);
                    if (!busError.isError()) break;
                    this.delegator.busdoc.addError(busError);
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                this.current.appendChild(this.genericHandler.getElement());
                break;
            }
            default: {
                this.genericHandler.startElement(string, attributeList);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        switch (this.context) {
            case 2: {
                this.delegator.deActivate(this);
                this.context = 1;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public String toString() {
        return "DataSetHandler(" + this.context + ")";
    }
}

