/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.BusinessElement;
import com.eibus.co.BusinessElementLink;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.SAXHandler;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.runtime.Registry;

public class BusinessElementHandler
extends SAXHandler {
    private BusinessDocumentManager owner = null;
    private BusinessElement current = null;
    private BusinessElement first = null;

    public BusinessElementHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
    }

    public BusinessElement getBusinessElement() {
        return this.current;
    }

    public void reset() {
        this.first = null;
        this.current = null;
        this.owner = null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.first == null) {
            this.owner = (BusinessDocumentManager)Registry.getManager(this.delegator.busdoc.getHeader().getCorrelationId(), null, null);
            if (this.owner == null) {
                BusComponent busComponent = this.delegator.busdoc.getHeader().getSender().getComponent();
                if (busComponent != null) {
                    this.owner = (BusinessDocumentManager)Registry.getManager(null, busComponent, string);
                }
                if (this.owner == null) {
                    this.owner = (BusinessDocumentManager)Registry.getManager(null, null, string);
                    if (this.owner == null) {
                        try {
                            this.owner = (BusinessDocumentManager)Registry.getDefaultManager();
                        }
                        catch (BusException busException) {
                            throw new SAXException("No manager registered for handling element: " + string);
                        }
                    }
                }
            }
            this.current = this.first = this.owner.createBusinessElement(string);
            if (this.current == null) {
                throw new SAXException("Registered manager could not create a business element for name: " + string);
            }
            this.delegator.activate(this);
        } else {
            if (this.current == null) {
                throw new SAXException("Can not create BusinessElement for tag <" + string + ">");
            }
            this.current = this.current.createBusinessElement(string);
        }
        if (attributeList.getLength() > 0) {
            int n = attributeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2 = attributeList.getName(n2);
                String string3 = attributeList.getValue(n2);
                if (string2.equals("href")) {
                    if (string3.charAt(0) == '#') {
                        BusinessElementLink businessElementLink = this.delegator.busdoc.getLink(string3.substring(1));
                        businessElementLink.addBusinessElement(this.current);
                        this.current.setLink(businessElementLink);
                    } else {
                        this.current.setAttribute(string2, string3);
                    }
                } else {
                    this.current.setAttribute(string2, string3);
                }
                ++n2;
            }
        }
        this.current.setManager(this.owner);
    }

    public void endElement(String string) throws SAXException {
        if (this.current == this.first) {
            this.current = null;
            this.first = null;
            this.delegator.deActivate(this);
        } else {
            this.current = (BusinessElement)this.current.getParentNode();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.current.appendChild(this.delegator.factory.createBusinessDataElement(new String(cArray, n, n2)));
    }

    public String toString() {
        return "BusinessElementHandler(" + this.context + ")";
    }
}

