/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.co.BusError;
import com.eibus.co.Constructor;
import com.eibus.co.ContentInfoCo;
import com.eibus.co.Control;
import com.eibus.co.LicenseInfoCo;
import com.eibus.co.UserInfoCo;
import com.eibus.co.parser.ConstructorHandler;
import com.eibus.co.parser.ContentInfoCoHandler;
import com.eibus.co.parser.ControlHandler;
import com.eibus.co.parser.DataSetHandler;
import com.eibus.co.parser.ErrorHandler;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.GenericHandler;
import com.eibus.co.parser.HeaderHandler;
import com.eibus.co.parser.LicenseInfoCoHandler;
import com.eibus.co.parser.SAXHandler;
import com.eibus.co.parser.UserInfoCoHandler;
import com.eibus.version.ProtocolVersion;

public class BusDocHandler
extends SAXHandler {
    static final int BUSDOC_BEFORE_HEADER = 2;
    static final int BUSDOC_AFTER_HEADER = 3;
    private HeaderHandler headerHandler;
    private DataSetHandler datasetHandler;
    private ErrorHandler errorHandler;
    private ConstructorHandler constructorHandler;
    private ControlHandler controlHandler;
    private GenericHandler genericHandler;
    private UserInfoCoHandler userinfoHandler;
    private LicenseInfoCoHandler licenseinfoHandler;
    private ContentInfoCoHandler contentinfoHandler;
    private int m_ProtocolVersion = 0;
    private String m_MessageDigest = "";

    public BusDocHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
        this.headerHandler = new HeaderHandler(eventDelegator);
        this.datasetHandler = new DataSetHandler(eventDelegator);
        this.errorHandler = new ErrorHandler(eventDelegator);
        this.constructorHandler = new ConstructorHandler(eventDelegator);
        this.genericHandler = new GenericHandler(eventDelegator);
        this.controlHandler = new ControlHandler(eventDelegator);
        this.userinfoHandler = new UserInfoCoHandler(eventDelegator);
        this.licenseinfoHandler = new LicenseInfoCoHandler(eventDelegator);
        this.contentinfoHandler = new ContentInfoCoHandler(eventDelegator);
    }

    public void reset() {
        this.context = 1;
        this.headerHandler.reset();
        this.datasetHandler.reset();
        this.errorHandler.reset();
        this.constructorHandler.reset();
        this.genericHandler.reset();
        this.controlHandler.reset();
        this.userinfoHandler.reset();
        this.licenseinfoHandler.reset();
        this.contentinfoHandler.reset();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.context) {
            case 1: {
                if (string.equals("busdoc")) {
                    String string2;
                    this.m_MessageDigest = string2 = attributeList.getValue("MD");
                    String string3 = attributeList.getValue("version");
                    this.m_ProtocolVersion = ProtocolVersion.StringToVersion(string3);
                    this.context = 2;
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                break;
            }
            case 2: {
                if (string.equals("header")) {
                    this.headerHandler.context = 1;
                    this.headerHandler.startElement(string, attributeList);
                    this.context = 3;
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                break;
            }
            case 3: {
                if (string.equals("dataset")) {
                    this.datasetHandler.context = 1;
                    this.datasetHandler.startElement(string, attributeList);
                    break;
                }
                if (string.equals("update")) {
                    this.datasetHandler.context = 1;
                    this.datasetHandler.startElement(string, attributeList);
                    break;
                }
                if (string.equals("constructor")) {
                    this.constructorHandler.context = 1;
                    this.constructorHandler.startElement(string, attributeList);
                    Constructor constructor = this.constructorHandler.getConstructor();
                    this.delegator.busdoc.addCO(constructor);
                    break;
                }
                if (string.equals("userinfo")) {
                    this.userinfoHandler.context = 1;
                    this.userinfoHandler.startElement(string, attributeList);
                    UserInfoCo userInfoCo = this.userinfoHandler.getUserInfoCo();
                    this.delegator.busdoc.setUserInfoFromParser(userInfoCo);
                    break;
                }
                if (string.equals("lic-inf")) {
                    this.licenseinfoHandler.context = 1;
                    this.licenseinfoHandler.startElement(string, attributeList);
                    LicenseInfoCo licenseInfoCo = this.licenseinfoHandler.getLicenseInfoCo();
                    this.delegator.busdoc.addCO(licenseInfoCo);
                    this.delegator.busdoc.setLicenseInfo(licenseInfoCo);
                    break;
                }
                if (string.equals("cont-inf")) {
                    this.contentinfoHandler.context = 1;
                    this.contentinfoHandler.startElement(string, attributeList);
                    ContentInfoCo contentInfoCo = this.contentinfoHandler.getContentInfoCo();
                    this.delegator.busdoc.addCO(contentInfoCo);
                    this.delegator.busdoc.setContentInfo(contentInfoCo);
                    break;
                }
                if (string.equals("control")) {
                    this.controlHandler.context = 1;
                    this.controlHandler.startElement(string, attributeList);
                    Control control = this.controlHandler.getControl();
                    this.delegator.busdoc.addCO(control);
                    break;
                }
                if (string.equals("error") || string.equals("warning")) {
                    this.errorHandler.context = 1;
                    this.errorHandler.startElement(string, attributeList);
                    BusError busError = this.errorHandler.getError();
                    busError.setErrorType(1);
                    this.delegator.busdoc.addCO(busError);
                    if (!busError.isError()) break;
                    this.delegator.busdoc.addError(busError);
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                break;
            }
            default: {
                this.genericHandler.startElement(string, attributeList);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        switch (this.context) {
            case 3: {
                this.context = 1;
                this.delegator.busdoc.setVersion(this.m_ProtocolVersion);
                if (this.m_MessageDigest == null || this.m_MessageDigest.equals("")) break;
                this.delegator.busdoc.setMessageDigest(this.m_MessageDigest);
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public String toString() {
        return "BusDocHandler(" + this.context + ")";
    }
}

