/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.parser;

import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.co.BaanDLLCall;
import com.eibus.co.BusinessElement;
import com.eibus.co.Constructor;
import com.eibus.co.parser.ConstructorHandler;
import com.eibus.co.parser.EventDelegator;
import com.eibus.co.parser.GenericHandler;
import com.eibus.co.parser.ParameterHandler;

public class BaanDLLCallHandler
extends ConstructorHandler {
    static final int BAAN_DLL = 2;
    static final int DLL = 3;
    static final int METHOD = 4;
    static final int PARAMETERS = 5;
    private ParameterHandler parameterHandler;
    private GenericHandler genericHandler;
    private BaanDLLCall current;
    private String datatype;
    private String componenttype;
    private String returntype;

    public BaanDLLCallHandler(EventDelegator eventDelegator) {
        super(eventDelegator);
        this.parameterHandler = new ParameterHandler(eventDelegator);
        this.genericHandler = new GenericHandler(eventDelegator);
    }

    public void reset() {
        this.context = 1;
        this.current = null;
        this.parameterHandler.reset();
        this.genericHandler.reset();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.context) {
            case 2: {
                if (string.equals("dll")) {
                    this.context = 3;
                    break;
                }
                if (string.equals("method")) {
                    this.context = 4;
                    this.datatype = attributeList.getValue("dt");
                    this.componenttype = attributeList.getValue("ct");
                    this.returntype = attributeList.getValue("rt");
                    break;
                }
                if (string.equals("parameters")) {
                    this.context = 5;
                    break;
                }
                this.genericHandler.startElement(string, attributeList);
                this.current.appendChild(this.genericHandler.getElement());
                break;
            }
            case 5: {
                this.parameterHandler.context = 1;
                this.parameterHandler.startElement(string, attributeList);
                BusinessElement businessElement = this.parameterHandler.getParameter();
                this.current.addBusinessElementParameter(businessElement);
                break;
            }
            default: {
                this.genericHandler.startElement(string, attributeList);
            }
        }
    }

    public void endElement(String string) throws SAXException {
        switch (this.context) {
            case 2: {
                this.delegator.deActivate(this);
                this.context = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.context = 2;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.context) {
            case 3: {
                this.current.setDLL(new String(cArray, n, n2));
                break;
            }
            case 4: {
                this.current.setMethod(new String(cArray, n, n2), this.datatype, this.componenttype, this.returntype);
                this.datatype = null;
                this.componenttype = null;
                break;
            }
        }
    }

    public void setCurrentConstructor(Constructor constructor) {
        this.current = (BaanDLLCall)constructor;
    }

    public void setStartElementContext() {
        this.context = 2;
    }

    public String toString() {
        return "BaanDLLCallHandler(" + this.context + ")";
    }
}

