/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.dom;

import com.baan.b3.boi1.BoiProgrammingRException;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.dom.Attr;
import com.baan.b3.dom.NamedNodeMap;
import com.baan.b3.dom.Node;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.bdf.BusinessObjectRegistration;
import com.eibus.co.BusDocFactory;
import com.eibus.co.BusinessElement;
import com.eibus.co.BusinessElementLink;
import com.eibus.co.Tuple;
import com.eibus.co.dom.BusinessDataElementImpl;
import com.eibus.services.datatypes.BinBase64;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.xml.dom.ElementImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class BusinessElementImpl
extends ElementImpl
implements BusinessElement {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.co.dom", "BusinessElementImpl");
    protected static final int ELEMENT = 0;
    protected static final int VECTOR = 1;
    protected static final int CLASS = 2;
    private static final TimeZone B3TIMEZONE = new SimpleTimeZone(0, "B3UTC");
    private static final Date DEFAULT_DATE;
    protected static Dictionary staticElementsByTagName;
    protected static Class[] staticClassElements;
    protected String tag;
    private boolean changed;
    private boolean nonSynchronizable;
    private BusinessElementLink link;
    private BusinessDocumentManager manager;
    protected Dictionary elementsByTagName = staticElementsByTagName;
    protected BusinessElementImpl[] memberElements;
    protected Vector[] vectorElements;
    protected Class[] classElements = staticClassElements;
    static int Qounter;
    static SimpleDateFormat simpleDateFormat;

    public static void registerTagName(Dictionary dictionary, String string, int n, int n2, int n3) {
        dictionary.put(string, new int[]{n, n2, n3});
    }

    public BusinessElementImpl() {
    }

    public BusinessElementImpl(String string) {
        this.tag = string;
    }

    public BusinessElement createBusinessElement(String string) {
        if (this.memberElements != null) {
            int[] nArray = (int[])this.elementsByTagName.get(string);
            if (nArray == null) {
                nArray = (int[])this.elementsByTagName.get(string.toLowerCase());
            }
            if (nArray != null) {
                BusinessElementImpl businessElementImpl;
                block16: {
                    if (nArray[2] >= 0) {
                        try {
                            Object t = this.classElements[nArray[2]].newInstance();
                            if (t instanceof BusinessElementImpl) {
                                businessElementImpl = (BusinessElementImpl)t;
                                break block16;
                            }
                            businessElementImpl = BusinessElementHack.getElement((BusinessObject)t);
                        }
                        catch (Exception exception) {
                            businessElementImpl = new BusinessElementImpl(string);
                        }
                    } else {
                        businessElementImpl = new BusinessElementImpl(string);
                    }
                }
                if (nArray[1] >= 0) {
                    int n = nArray[1];
                    if (this.vectorElements[n] == null) {
                        this.vectorElements[n] = new Vector();
                    }
                    this.vectorElements[n].addElement(businessElementImpl);
                    if (this.vectorElements[n].size() == 1) {
                        this.memberElements[nArray[0]] = businessElementImpl;
                    }
                } else {
                    this.memberElements[nArray[0]] = businessElementImpl;
                }
                return (BusinessElement)this.appendChild(businessElementImpl);
            }
        } else {
            Class clazz = BusinessObjectRegistration.getRegisteredClass(string);
            if (clazz != null) {
                try {
                    Object t = clazz.newInstance();
                    BusinessElementImpl businessElementImpl = BusinessElementHack.getElement((BusinessObject)t);
                    return (BusinessElement)this.appendChild(businessElementImpl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (BusinessElement)this.appendChild(new BusinessElementImpl(string));
    }

    public void setLogic(String string) {
        this.setAttribute("logic", string);
    }

    public String getLogic() {
        return this.getAttribute("logic");
    }

    public void makeNonSynchronizable() {
        this.nonSynchronizable = true;
    }

    public boolean isSynchronizable() {
        return !this.nonSynchronizable;
    }

    public void initialize(BusinessElement businessElement) {
        Node node = this.getFirstChild();
        while (node != null) {
            this.removeChild(node);
            node = this.getFirstChild();
        }
        BusinessElementImpl businessElementImpl = (BusinessElementImpl)businessElement;
        if (businessElementImpl != null) {
            node = businessElementImpl.getFirstChild();
            while (node != null) {
                this.appendChild(businessElementImpl.removeChild(node));
                node = businessElementImpl.getFirstChild();
            }
            this.memberElements = businessElementImpl.memberElements;
        }
        this.resetAdministration(false, this.manager);
    }

    protected void resetAdministration(boolean bl, BusinessDocumentManager businessDocumentManager) {
        this.changed = bl;
        this.manager = businessDocumentManager;
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof BusinessElementImpl) {
                ((BusinessElementImpl)node).resetAdministration(bl, businessDocumentManager);
            }
            node = node.getNextSibling();
        }
    }

    public String type() {
        return this.tag;
    }

    public String id() {
        return "BusinessElement";
    }

    public void setLink(BusinessElementLink businessElementLink) {
        this.link = businessElementLink;
        if (businessElementLink != null) {
            this.setAttribute("href", '#' + businessElementLink.getIdentifier());
        } else {
            this.removeAttribute("href");
        }
    }

    protected void setLinkImpl(BusinessElementLink businessElementLink) {
        this.link = businessElementLink;
    }

    public BusinessElementLink getLink() {
        return this.link;
    }

    public void removeFromLink() {
        if (this.link != null) {
            this.link.removeBusinessElement(this);
            this.removeAttribute("href");
        }
    }

    public BusinessElement createLinkedElement() {
        BusinessElementLink businessElementLink;
        if (this.manager == null) {
            throw new BoiProgrammingRException("BusinessObject is not in control of a Manager");
        }
        Tuple tuple = this.getTuple();
        if (tuple == null) {
            this.changed = false;
            this.setChanged();
            tuple = this.getTuple();
        }
        if ((businessElementLink = tuple.getLink()) == null) {
            businessElementLink = new BusinessElementLink("Q." + Qounter++);
            businessElementLink.setTuple(this.getTuple());
            tuple.setLink(businessElementLink);
        }
        BusinessElementImpl businessElementImpl = new BusinessElementImpl(this.tag);
        businessElementImpl.setManager(this.manager);
        businessElementImpl.setLink(businessElementLink);
        return businessElementImpl;
    }

    public BusinessElement traverse() {
        if (this.link == null) {
            return this;
        }
        return this.link.getResource();
    }

    public Tuple getTuple() {
        BusinessElementImpl businessElementImpl = (BusinessElementImpl)this.getParentNode();
        if (businessElementImpl == null) {
            return null;
        }
        if (businessElementImpl instanceof Tuple) {
            return (Tuple)((Object)businessElementImpl);
        }
        return businessElementImpl.getTuple();
    }

    public void setManager(BusinessDocumentManager businessDocumentManager) {
        if (this.manager == null) {
            this.manager = businessDocumentManager;
        }
    }

    public BusinessDocumentManager getManager() {
        return this.manager;
    }

    public void setChanged() {
        BusinessElementLink businessElementLink;
        BusinessElement businessElement;
        if (this.changed || this.nonSynchronizable) {
            return;
        }
        BusinessElementImpl businessElementImpl = (BusinessElementImpl)this.getParentNode();
        if (businessElementImpl == null) {
            if (this.manager != null) {
                this.manager.add(this);
            }
        } else {
            businessElement = (BusinessElement)businessElementImpl.getParentNode();
            if (businessElement != null) {
                if (businessElement instanceof Tuple) {
                    if (!this.changed && this.manager != null) {
                        this.manager.memorize(this);
                    }
                } else {
                    businessElementImpl.setChanged();
                }
            }
        }
        this.changed = true;
        businessElement = this.getTuple();
        if (businessElement != null && (businessElementLink = businessElement.getLink()) != null) {
            Enumeration enumeration2 = businessElementLink.getBusinessElements();
            while (enumeration2.hasMoreElements()) {
                BusinessElementImpl businessElementImpl2 = (BusinessElementImpl)enumeration2.nextElement();
                if ((businessElementImpl2 = (BusinessElementImpl)businessElementImpl2.getParentNode()) == null) continue;
                businessElementImpl2.setChanged();
            }
        }
    }

    public String getTagName() {
        return this.tag;
    }

    public String getNodeName() {
        return this.tag;
    }

    public Node cloneNode(boolean bl) {
        try {
            BusinessElementImpl businessElementImpl = new BusinessElementImpl();
            businessElementImpl.tag = this.tag;
            businessElementImpl.link = this.link;
            if (businessElementImpl.link != null) {
                businessElementImpl.link.addBusinessElement(businessElementImpl);
            }
            if (bl) {
                this.copyAttributesInto(businessElementImpl);
                this.copyChildrenInto(businessElementImpl, bl);
            }
            return businessElementImpl;
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            return null;
        }
    }

    protected void clearChildren() {
        this.setChanged();
    }

    public void createInsertionTuples(Vector vector, BusDocFactory busDocFactory) {
        Object object;
        int n = this.vectorElements == null ? 0 : this.vectorElements.length;
        int n2 = 0;
        while (n2 < n) {
            object = this.vectorElements[n2];
            BusinessElementImpl.elementsToInsertionTuples(vector, this, (Vector)object, busDocFactory);
            ++n2;
        }
        if (this.memberElements != null) {
            object = this.elementsByTagName.elements();
            while (object.hasMoreElements()) {
                BusinessElementImpl businessElementImpl;
                Object object2;
                int[] nArray = (int[])object.nextElement();
                int n3 = nArray[1];
                int n4 = nArray[0];
                if (n3 >= 0) {
                    if (this.memberElements[n4] == null) continue;
                    object2 = this.vectorElements[n3];
                    this.memberElements[n4] = ((Vector)object2).size() > 0 ? (BusinessElementImpl)((Vector)object2).elementAt(0) : null;
                    continue;
                }
                object2 = this.memberElements[n4];
                if (object2 == null || !BusinessElementImpl.isAssociated((BusinessElement)object2)) continue;
                BusinessElement businessElement = object2.traverse();
                businessElement.createInsertionTuples(vector, busDocFactory);
                this.memberElements[n4] = businessElementImpl = (BusinessElementImpl)businessElement.createLinkedElement();
                this.removeChild((Node)object2);
                this.appendChild(businessElementImpl);
            }
        }
        this.getManager().release(this);
        object = busDocFactory.createTuple();
        object.setOriginal(null);
        object.setCurrent(this);
        vector.insertElementAt(object, 0);
    }

    public void createDeletionTuples(Vector vector, BusDocFactory busDocFactory) throws NullPointerException {
        Object object;
        int n = this.vectorElements == null ? 0 : this.vectorElements.length;
        int n2 = 0;
        while (n2 < n) {
            object = this.vectorElements[n2];
            BusinessElementImpl.elementsToDeletionTuples(vector, this, (Vector)object, busDocFactory);
            ++n2;
        }
        if (this.memberElements != null) {
            object = this.elementsByTagName.elements();
            while (object.hasMoreElements()) {
                BusinessElementImpl businessElementImpl;
                Object object2;
                int[] nArray = (int[])object.nextElement();
                int n3 = nArray[1];
                int n4 = nArray[0];
                if (n3 >= 0) {
                    if (this.memberElements[n4] == null) continue;
                    object2 = this.vectorElements[n3];
                    this.memberElements[n4] = ((Vector)object2).size() > 0 ? (BusinessElementImpl)((Vector)object2).elementAt(0) : null;
                    continue;
                }
                object2 = this.memberElements[n4];
                if (object2 == null || !BusinessElementImpl.isAssociated((BusinessElement)object2)) continue;
                BusinessElement businessElement = object2.traverse();
                businessElement.createDeletionTuples(vector, busDocFactory);
                this.memberElements[n4] = businessElementImpl = (BusinessElementImpl)businessElement.createLinkedElement();
                this.removeChild((Node)object2);
                this.appendChild(businessElementImpl);
            }
        }
        this.getManager().release(this);
        object = busDocFactory.createTuple();
        object.setOriginal(this);
        object.setCurrent(null);
        vector.addElement(object);
    }

    public static void createUpdateTuples(Vector vector, BusinessElement businessElement, BusinessElement businessElement2, BusDocFactory busDocFactory) throws IllegalArgumentException, NullPointerException {
        BusinessElement businessElement3;
        BusinessElement businessElement4;
        BusinessElement businessElement5;
        BusinessElement businessElement6;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Vector[] vectorArray = ((BusinessElementImpl)businessElement).vectorElements;
        Vector[] vectorArray2 = ((BusinessElementImpl)businessElement2).vectorElements;
        int n2 = vectorArray == null ? 0 : vectorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object4 = vectorArray[n3];
            object3 = vectorArray2[n3];
            if (object4 == null) {
                if (object3 != null) {
                    BusinessElementImpl.elementsToInsertionTuples(vector, businessElement2, (Vector)object3, busDocFactory);
                }
            } else if (object3 == null) {
                BusinessElementImpl.elementsToDeletionTuples(vector, businessElement, (Vector)object4, busDocFactory);
            } else {
                Object object5;
                int n4;
                int n5 = ((Vector)object4).size();
                if (n5 == (n4 = ((Vector)object3).size())) {
                    if (BusinessElementImpl.isAssociated((Vector)object4) || BusinessElementImpl.isAssociated((Vector)object3)) {
                        n = 0;
                        while (n < n5) {
                            object5 = (BusinessElementImpl)((Vector)object4).elementAt(n);
                            object2 = (BusinessElementImpl)((Vector)object3).elementAt(n);
                            object = ((BusinessElementImpl)object5).traverse();
                            businessElement6 = ((BusinessElementImpl)object2).traverse();
                            BusinessElementImpl.createUpdateTuples(vector, (BusinessElement)object, businessElement6, busDocFactory);
                            businessElement5 = (BusinessElementImpl)object.createLinkedElement();
                            businessElement4 = (BusinessElementImpl)businessElement6.createLinkedElement();
                            ((Vector)object4).setElementAt(businessElement5, n);
                            ((Vector)object3).setElementAt(businessElement4, n);
                            businessElement.removeChild((Node)object5);
                            businessElement.appendChild(businessElement5);
                            businessElement2.removeChild((Node)object2);
                            businessElement2.appendChild(businessElement4);
                            ++n;
                        }
                    }
                } else if (n5 > n4) {
                    Vector vector2 = null;
                    vector2 = (Vector)((Vector)object4).clone();
                    object5 = new Vector();
                    try {
                        BusinessElementImpl.removeSubset((Vector)object3, vector2, (Vector)object5);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException("In delete operation: not all 'new' values could be found in the set of 'old' values");
                    }
                    int n6 = ((Vector)object3).size();
                    int n7 = 0;
                    while (n7 < n6) {
                        businessElement6 = (BusinessElementImpl)((Vector)object5).elementAt(n7);
                        businessElement5 = (BusinessElementImpl)((Vector)object3).elementAt(n7);
                        businessElement4 = ((BusinessElementImpl)businessElement6).traverse();
                        businessElement3 = ((BusinessElementImpl)businessElement5).traverse();
                        businessElement4.getManager().release(businessElement4);
                        businessElement3.getManager().release(businessElement3);
                        businessElement.removeChild(businessElement6);
                        businessElement2.removeChild(businessElement5);
                        ++n7;
                    }
                    ((Vector)object4).removeAllElements();
                    ((Vector)object3).removeAllElements();
                    BusinessElementImpl.elementsToDeletionTuples(vector, businessElement, vector2, busDocFactory);
                    vectorArray[n3] = vector2;
                } else {
                    Vector vector3 = null;
                    vector3 = (Vector)((Vector)object3).clone();
                    object5 = new Vector();
                    try {
                        BusinessElementImpl.removeSubset((Vector)object4, vector3, (Vector)object5);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException("In insert operation: not all 'old' values could be found in the set of 'new' values");
                    }
                    int n8 = ((Vector)object4).size();
                    int n9 = 0;
                    while (n9 < n8) {
                        businessElement6 = (BusinessElementImpl)((Vector)object4).elementAt(n9);
                        businessElement5 = (BusinessElementImpl)((Vector)object5).elementAt(n9);
                        businessElement4 = ((BusinessElementImpl)businessElement6).traverse();
                        businessElement3 = ((BusinessElementImpl)businessElement5).traverse();
                        businessElement4.getManager().release(businessElement4);
                        businessElement3.getManager().release(businessElement3);
                        businessElement.removeChild(businessElement6);
                        businessElement2.removeChild(businessElement5);
                        ++n9;
                    }
                    ((Vector)object4).removeAllElements();
                    ((Vector)object3).removeAllElements();
                    BusinessElementImpl.elementsToInsertionTuples(vector, businessElement2, vector3, busDocFactory);
                    vectorArray2[n3] = vector3;
                }
            }
            ++n3;
        }
        object4 = ((BusinessElementImpl)businessElement).memberElements;
        object3 = ((BusinessElementImpl)businessElement2).memberElements;
        if (object4 != null && object3 != null) {
            Enumeration enumeration2 = ((BusinessElementImpl)businessElement).elementsByTagName.elements();
            while (enumeration2.hasMoreElements()) {
                int[] nArray = (int[])enumeration2.nextElement();
                n = nArray[1];
                int n10 = nArray[0];
                if (n >= 0) {
                    if (object4[n10] != null) {
                        object2 = vectorArray[n];
                        Object object6 = object4[n10] = ((Vector)object2).size() > 0 ? (BusinessElementImpl)((Vector)object2).elementAt(0) : null;
                    }
                    if (object3[n10] == null) continue;
                    object2 = vectorArray2[n];
                    object3[n10] = ((Vector)object2).size() > 0 ? (BusinessElementImpl)((Vector)object2).elementAt(0) : null;
                    continue;
                }
                object2 = object4[n10];
                object = object3[n10];
                if (object2 != null) {
                    if (object != null) {
                        if (!BusinessElementImpl.isAssociated((BusinessElement)object2) && !BusinessElementImpl.isAssociated((BusinessElement)object)) continue;
                        businessElement6 = object2.traverse();
                        businessElement5 = object.traverse();
                        BusinessElementImpl.createUpdateTuples(vector, businessElement6, businessElement5, busDocFactory);
                        businessElement4 = (BusinessElementImpl)businessElement6.createLinkedElement();
                        businessElement3 = (BusinessElementImpl)businessElement5.createLinkedElement();
                        object4[n10] = businessElement4;
                        object3[n10] = businessElement3;
                        businessElement.removeChild((Node)object2);
                        businessElement.appendChild(businessElement4);
                        businessElement2.removeChild((Node)object2);
                        businessElement2.appendChild(businessElement3);
                        continue;
                    }
                    if (!BusinessElementImpl.isAssociated((BusinessElement)object2)) continue;
                    businessElement6 = object2.traverse();
                    businessElement6.createDeletionTuples(vector, busDocFactory);
                    businessElement5 = (BusinessElementImpl)businessElement6.createLinkedElement();
                    object4[n10] = businessElement5;
                    businessElement.removeChild((Node)object2);
                    businessElement.appendChild(businessElement5);
                    continue;
                }
                if (object == null || !BusinessElementImpl.isAssociated((BusinessElement)object)) continue;
                businessElement6 = object.traverse();
                businessElement6.createInsertionTuples(vector, busDocFactory);
                businessElement5 = (BusinessElementImpl)businessElement6.createLinkedElement();
                object3[n10] = businessElement5;
                businessElement2.removeChild((Node)object);
                businessElement2.appendChild(businessElement5);
            }
        }
        businessElement.getManager().release(businessElement);
        businessElement2.getManager().release(businessElement2);
        Tuple tuple = busDocFactory.createTuple();
        tuple.setOriginal(businessElement);
        tuple.setCurrent(businessElement2);
        vector.addElement(tuple);
    }

    private static void elementsToInsertionTuples(Vector vector, BusinessElement businessElement, Vector vector2, BusDocFactory busDocFactory) throws NullPointerException {
        if (vector2 != null && BusinessElementImpl.isAssociated(vector2)) {
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                BusinessElement businessElement2 = (BusinessElement)vector2.elementAt(n2);
                BusinessElement businessElement3 = businessElement2.traverse();
                businessElement3.createInsertionTuples(vector, busDocFactory);
                BusinessElementImpl businessElementImpl = (BusinessElementImpl)businessElement3.createLinkedElement();
                vector2.setElementAt(businessElementImpl, n2);
                businessElement.removeChild(businessElement2);
                businessElement.appendChild(businessElementImpl);
                ++n2;
            }
        }
    }

    private static void elementsToDeletionTuples(Vector vector, BusinessElement businessElement, Vector vector2, BusDocFactory busDocFactory) throws NullPointerException {
        if (vector2 != null && BusinessElementImpl.isAssociated(vector2)) {
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                BusinessElement businessElement2 = (BusinessElement)vector2.elementAt(n2);
                BusinessElement businessElement3 = businessElement2.traverse();
                businessElement3.createDeletionTuples(vector, busDocFactory);
                BusinessElementImpl businessElementImpl = (BusinessElementImpl)businessElement3.createLinkedElement();
                vector2.setElementAt(businessElementImpl, n2);
                businessElement.removeChild(businessElement2);
                businessElement.appendChild(businessElementImpl);
                ++n2;
            }
        }
    }

    private static boolean isAssociated(BusinessElement businessElement) throws NullPointerException {
        BusinessElement businessElement2 = businessElement.traverse();
        return businessElement2 != businessElement;
    }

    private static boolean isAssociated(Vector vector) throws NullPointerException {
        if (vector.size() == 0) {
            return false;
        }
        BusinessElement businessElement = (BusinessElement)vector.elementAt(0);
        return BusinessElementImpl.isAssociated(businessElement);
    }

    private static void removeSubset(Vector vector, Vector vector2, Vector vector3) throws IllegalArgumentException, NullPointerException {
        int n = vector.size();
        int n2 = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            block4: {
                BusinessElementImpl businessElementImpl = (BusinessElementImpl)vector.elementAt(n3);
                BusinessElementImpl businessElementImpl2 = (BusinessElementImpl)businessElementImpl.traverse();
                int n4 = 0;
                while (n4 < n2) {
                    BusinessElementImpl businessElementImpl3 = (BusinessElementImpl)vector2.elementAt(n4);
                    BusinessElementImpl businessElementImpl4 = (BusinessElementImpl)businessElementImpl3.traverse();
                    if (businessElementImpl4.isEquivalentTo(businessElementImpl2)) {
                        vector2.removeElementAt(n4);
                        --n2;
                        if (vector3 != null) {
                            vector3.addElement(businessElementImpl3);
                        }
                        break block4;
                    }
                    ++n4;
                }
                throw new IllegalArgumentException("p_set does not contain all p_subSet elements (" + businessElementImpl2 + ")");
            }
            ++n3;
        }
    }

    private boolean isEquivalentTo(BusinessElementImpl businessElementImpl) throws NullPointerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (businessElementImpl == this) {
            return true;
        }
        if (!this.tag.equals(businessElementImpl.tag)) {
            return false;
        }
        if (!this.getClass().equals(businessElementImpl.getClass())) {
            return false;
        }
        if (this.vectorElements == null && this.memberElements == null) {
            String string;
            String string2;
            if (businessElementImpl.vectorElements != null || businessElementImpl.memberElements != null) {
                return false;
            }
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)this.getFirstChild();
            BusinessDataElementImpl businessDataElementImpl2 = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            return businessDataElementImpl != null && businessDataElementImpl2 != null ? (string2 = businessDataElementImpl.getData()).equals(string = businessDataElementImpl2.getData()) : businessDataElementImpl == businessDataElementImpl2;
        }
        NamedNodeMap namedNodeMap = this.getAttributes();
        NamedNodeMap namedNodeMap2 = businessElementImpl.getAttributes();
        int n = namedNodeMap.getLength();
        if (namedNodeMap2.getLength() != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            object4 = (Attr)namedNodeMap.item(n2);
            object3 = (Attr)namedNodeMap2.getNamedItem(object4.getName());
            if (object3 == null) {
                return false;
            }
            if (!object4.getValue().equals(object3.getValue())) {
                return false;
            }
            ++n2;
        }
        object4 = this.memberElements;
        object3 = businessElementImpl.memberElements;
        if (object4 == null || object3 == null) {
            if (object4 != null || object3 != null) {
                return false;
            }
        } else {
            int n3 = ((Object)object4).length;
            if (((BusinessElementImpl[])object3).length != n3) {
                return false;
            }
            int n4 = 0;
            while (n4 < n3) {
                Object object5 = object4[n4];
                Object object6 = object3[n4];
                if (object5 == null || object6 == null ? object5 != null || object6 != null : !super.isEquivalentTo((BusinessElementImpl)(object = (BusinessElementImpl)((BusinessElementImpl)object6).traverse()))) {
                    return false;
                }
                ++n4;
            }
        }
        Vector[] vectorArray = this.vectorElements;
        Vector[] vectorArray2 = businessElementImpl.vectorElements;
        if (vectorArray == null || vectorArray2 == null) {
            if (vectorArray != null || vectorArray2 != null) {
                return false;
            }
        } else {
            int n5 = vectorArray.length;
            if (vectorArray2.length != n5) {
                return false;
            }
            int n6 = 0;
            while (n6 < n5) {
                object2 = vectorArray[n6];
                object = vectorArray2[n6];
                if (object2 == null || object == null) {
                    if (object2 != null || object != null) {
                        return false;
                    }
                } else {
                    int n7 = ((Vector)object2).size();
                    if (((Vector)object).size() != n7) {
                        return false;
                    }
                    int n8 = 0;
                    while (n8 < n7) {
                        block27: {
                            BusinessElement businessElement = (BusinessElement)((Vector)object2).elementAt(n8);
                            BusinessElementImpl businessElementImpl2 = (BusinessElementImpl)businessElement.traverse();
                            int n9 = 0;
                            while (n9 < n7) {
                                BusinessElement businessElement2 = (BusinessElement)((Vector)object).elementAt(n9);
                                BusinessElementImpl businessElementImpl3 = (BusinessElementImpl)businessElement2.traverse();
                                if (!businessElementImpl2.isEquivalentTo(businessElementImpl3)) {
                                    ++n9;
                                    continue;
                                }
                                break block27;
                            }
                            return false;
                        }
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        return true;
    }

    protected void insertMemberBusinessElement(BusinessElementImpl[] businessElementImplArray, int n, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl != null) {
            Node node = businessElementImpl.getParentNode();
            if (node == null) {
                int n2 = businessElementImplArray.length;
                boolean bl = false;
                int n3 = n + 1;
                while (n3 < n2) {
                    if (businessElementImplArray[n3] != null) {
                        this.insertBefore(businessElementImpl, businessElementImplArray[n3]);
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    this.appendChild(businessElementImpl);
                }
            } else if (node != this) {
                throw new RuntimeException("Illegal member element ( Unexpected Parent )");
            }
        }
    }

    protected void setMemberBusinessElement(BusinessElementImpl[] businessElementImplArray, int n, BusinessElementImpl businessElementImpl) throws RuntimeException {
        int n2 = businessElementImplArray.length;
        if (n >= 0 && n < n2) {
            BusinessElementImpl businessElementImpl2 = businessElementImplArray[n];
            if (businessElementImpl2 == businessElementImpl) {
                return;
            }
            if (businessElementImpl2 != null) {
                this.removeChild(businessElementImpl2);
            }
        } else {
            throw new RuntimeException("Illegal index " + n + " in members array of size: " + n2);
        }
        businessElementImplArray[n] = businessElementImpl;
        this.insertMemberBusinessElement(businessElementImplArray, n, businessElementImpl);
    }

    protected void addMemberBusinessElement(BusinessElementImpl[] businessElementImplArray, int n, BusinessElementImpl businessElementImpl, Vector vector) {
        vector.addElement(businessElementImpl);
        businessElementImplArray[n] = (BusinessElementImpl)vector.elementAt(0);
        this.insertMemberBusinessElement(businessElementImplArray, n, businessElementImpl);
        this.setChanged();
    }

    protected void setMemberBusinessElementAt(BusinessElementImpl[] businessElementImplArray, int n, BusinessElementImpl businessElementImpl, Vector vector, int n2, BusinessElementImpl businessElementImpl2) throws ArrayIndexOutOfBoundsException {
        if (businessElementImpl2 == businessElementImpl) {
            return;
        }
        this.removeChild(businessElementImpl2);
        vector.setElementAt(businessElementImpl, n2);
        if (n2 == 0) {
            businessElementImplArray[n] = businessElementImpl;
        }
        if (n2 == vector.size() - 1) {
            this.insertMemberBusinessElement(businessElementImplArray, n, businessElementImpl);
        } else {
            this.insertBefore(businessElementImpl, (Node)vector.elementAt(n2 + 1));
        }
        this.setChanged();
    }

    protected void insertMemberBusinessElementAt(BusinessElementImpl[] businessElementImplArray, int n, BusinessElementImpl businessElementImpl, Vector vector, int n2) throws ArrayIndexOutOfBoundsException {
        vector.insertElementAt(businessElementImpl, n2);
        if (n2 == 0) {
            businessElementImplArray[n] = businessElementImpl;
        }
        if (n2 == vector.size() - 1) {
            this.insertMemberBusinessElement(businessElementImplArray, n, businessElementImpl);
        } else {
            this.insertBefore(businessElementImpl, (Node)vector.elementAt(n2 + 1));
        }
        this.setChanged();
    }

    protected void removeAllMemberBusinessElement(BusinessElementImpl[] businessElementImplArray, int n, Vector vector) {
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            this.removeChild((Node)vector.elementAt(n3));
            ++n3;
        }
        businessElementImplArray[n] = null;
        this.setChanged();
    }

    protected void removeMemberBusinessElementAt(BusinessElementImpl[] businessElementImplArray, int n, Vector vector, int n2) throws ArrayIndexOutOfBoundsException {
        this.removeChild((Node)vector.elementAt(n2));
        vector.removeElementAt(n2);
        if (n2 == 0) {
            businessElementImplArray[n] = vector.size() > 0 ? (BusinessElementImpl)vector.elementAt(0) : null;
        }
        this.setChanged();
    }

    protected boolean removeMemberBusinessElement(BusinessElementImpl[] businessElementImplArray, int n, BusinessElementImpl businessElementImpl, Vector vector) throws ArrayIndexOutOfBoundsException {
        boolean bl = vector.removeElement(businessElementImpl);
        if (bl) {
            this.removeChild(businessElementImpl);
            businessElementImplArray[n] = vector.size() > 0 ? (BusinessElementImpl)vector.elementAt(0) : null;
        }
        this.setChanged();
        return bl;
    }

    public boolean element2boolean(BusinessElementImpl businessElementImpl) {
        long l = this.element2long(businessElementImpl);
        return l != 0L;
    }

    public BusinessElementImpl boolean2Element(boolean bl, String string, BusinessElementImpl businessElementImpl) {
        return this.long2Element(bl ? 1L : 0L, string, businessElementImpl);
    }

    protected boolean attribute2boolean(String string) {
        long l = this.attribute2long(string);
        return l != 0L;
    }

    protected void boolean2Attribute(boolean bl, String string) {
        this.setAttribute(string, bl ? "1" : "0");
    }

    public byte element2byte(BusinessElementImpl businessElementImpl) {
        return (byte)this.element2long(businessElementImpl);
    }

    public BusinessElementImpl byte2Element(byte by, String string, BusinessElementImpl businessElementImpl) {
        return this.long2Element(by, string, businessElementImpl);
    }

    protected byte attribute2byte(String string) {
        return (byte)this.attribute2long(string);
    }

    protected void byte2Attribute(byte by, String string) {
        this.setAttribute(string, new Byte(by).toString());
    }

    public short element2short(BusinessElementImpl businessElementImpl) {
        return (short)this.element2long(businessElementImpl);
    }

    public BusinessElementImpl short2Element(short s, String string, BusinessElementImpl businessElementImpl) {
        return this.long2Element(s, string, businessElementImpl);
    }

    protected short attribute2short(String string) {
        return (short)this.attribute2long(string);
    }

    protected void short2Attribute(short s, String string) {
        this.setAttribute(string, new Short(s).toString());
    }

    public int element2int(BusinessElementImpl businessElementImpl) {
        return (int)this.element2long(businessElementImpl);
    }

    public BusinessElementImpl int2Element(int n, String string, BusinessElementImpl businessElementImpl) {
        return this.long2Element(n, string, businessElementImpl);
    }

    protected int attribute2int(String string) {
        return (int)this.attribute2long(string);
    }

    protected void int2Attribute(int n, String string) {
        this.setAttribute(string, new Integer(n).toString());
    }

    public long element2long(BusinessElementImpl businessElementImpl) {
        if (businessElementImpl != null) {
            try {
                BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
                if (businessDataElementImpl != null) {
                    return new Long(businessDataElementImpl.getData());
                }
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        return 0L;
    }

    public BusinessElementImpl long2Element(long l, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(new Long(l).toString());
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(new Long(l).toString());
        }
        return businessElementImpl;
    }

    protected long attribute2long(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return new Long(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        return 0L;
    }

    protected void long2Attribute(long l, String string) {
        this.setAttribute(string, new Long(l).toString());
    }

    public float element2float(BusinessElementImpl businessElementImpl) {
        return (float)this.element2double(businessElementImpl);
    }

    public BusinessElementImpl float2Element(float f, String string, BusinessElementImpl businessElementImpl) {
        return this.double2Element(f, string, businessElementImpl);
    }

    protected float attribute2float(String string) {
        return (float)this.attribute2double(string);
    }

    protected void float2Attribute(float f, String string) {
        this.setAttribute(string, new Float(f).toString());
    }

    public double element2double(BusinessElementImpl businessElementImpl) {
        if (businessElementImpl != null) {
            try {
                BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
                if (businessDataElementImpl != null) {
                    return new Double(businessDataElementImpl.getData());
                }
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public BusinessElementImpl double2Element(double d, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(new Double(d).toString());
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(new Double(d).toString());
        }
        return businessElementImpl;
    }

    protected double attribute2double(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    protected void double2Attribute(double d, String string) {
        this.setAttribute(string, new Double(d).toString());
    }

    public String element2String(BusinessElementImpl businessElementImpl) {
        if (businessElementImpl != null) {
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl != null) {
                return businessDataElementImpl.getData();
            }
            return "";
        }
        return "";
    }

    public BusinessElementImpl String2Element(String string, String string2, BusinessElementImpl businessElementImpl) {
        if (string == null) {
            string = "";
        }
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string2);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(string);
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(string);
        }
        return businessElementImpl;
    }

    protected String attribute2String(String string) {
        String string2 = this.getAttribute(string);
        return string2;
    }

    protected void String2Attribute(String string, String string2) {
        if (string == null) {
            string = "";
        }
        this.setAttribute(string2, string);
    }

    public BigInteger element2BigInteger(BusinessElementImpl businessElementImpl) {
        if (businessElementImpl != null) {
            try {
                BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
                if (businessDataElementImpl != null) {
                    return new BigInteger(businessDataElementImpl.getData());
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new BigInteger("0");
            }
        }
        return new BigInteger("0");
    }

    public BusinessElementImpl BigInteger2Element(BigInteger bigInteger, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(bigInteger == null ? "" : bigInteger.toString());
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(bigInteger == null ? "" : bigInteger.toString());
        }
        return businessElementImpl;
    }

    protected BigInteger attribute2BigInteger(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return new BigInteger(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return new BigInteger("0");
            }
        }
        return new BigInteger("0");
    }

    protected void BigInteger2Attribute(BigInteger bigInteger, String string) {
        this.setAttribute(string, bigInteger == null ? "" : bigInteger.toString());
    }

    public BigDecimal element2BigDecimal(BusinessElementImpl businessElementImpl) {
        if (businessElementImpl != null) {
            try {
                BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
                if (businessDataElementImpl != null) {
                    return new BigDecimal(businessDataElementImpl.getData());
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new BigDecimal("0");
            }
        }
        return new BigDecimal("0");
    }

    public BusinessElementImpl BigDecimal2Element(BigDecimal bigDecimal, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(bigDecimal == null ? "" : bigDecimal.toString());
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(bigDecimal == null ? "" : bigDecimal.toString());
        }
        return businessElementImpl;
    }

    protected BigDecimal attribute2BigDecimal(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return new BigDecimal("0");
            }
        }
        return new BigDecimal("0");
    }

    protected void BigDecimal2Attribute(BigDecimal bigDecimal, String string) {
        this.setAttribute(string, bigDecimal == null ? "" : bigDecimal.toString());
    }

    public Date element2Date(BusinessElementImpl businessElementImpl) {
        BusinessDataElementImpl businessDataElementImpl;
        if (businessElementImpl != null && (businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild()) != null) {
            return BusinessElementImpl.String2Date(businessDataElementImpl.getData());
        }
        return DEFAULT_DATE;
    }

    public BusinessElementImpl Date2Element(Date date, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(date == null ? "" : BusinessElementImpl.Date2String(date));
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(date == null ? "" : BusinessElementImpl.Date2String(date));
        }
        return businessElementImpl;
    }

    protected Date attribute2Date(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            return BusinessElementImpl.String2Date(string2);
        }
        return DEFAULT_DATE;
    }

    protected void Date2Attribute(Date date, String string) {
        this.setAttribute(string, date == null ? "" : BusinessElementImpl.Date2String(date));
    }

    public BusinessElementImpl BinBase642Element(byte[] byArray, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(byArray == null ? "" : BusinessElementImpl.BinBase642String(byArray));
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(byArray == null ? "" : BusinessElementImpl.BinBase642String(byArray));
        }
        return businessElementImpl;
    }

    public byte[] element2BinBase64(BusinessElementImpl businessElementImpl) {
        BusinessDataElementImpl businessDataElementImpl;
        if (businessElementImpl != null && (businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild()) != null) {
            return BusinessElementImpl.String2BinBase64(businessDataElementImpl.getData());
        }
        return null;
    }

    protected byte[] attribute2BinBase64(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            return BusinessElementImpl.String2BinBase64(string2);
        }
        return null;
    }

    protected void BinBase642Attribute(byte[] byArray, String string) {
        this.setAttribute(string, byArray == null ? "" : BusinessElementImpl.BinBase642String(byArray));
    }

    public static synchronized byte[] String2BinBase64(String string) {
        return BinBase64.ByteArrayFromBase64String(string);
    }

    public static synchronized String BinBase642String(byte[] byArray) {
        return BinBase64.Base64StringFromByteArray(byArray);
    }

    public BusinessElementImpl XMLNode2Element(org.w3c.dom.Node node, String string, BusinessElementImpl businessElementImpl) {
        if (businessElementImpl == null) {
            businessElementImpl = new BusinessElementImpl(string);
            BusinessDataElementImpl businessDataElementImpl = new BusinessDataElementImpl(node == null ? "" : BusinessElementImpl.XMLNode2String(node));
            businessElementImpl.appendChild(businessDataElementImpl);
            this.clearChildren();
        } else {
            this.setChanged();
            BusinessDataElementImpl businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild();
            if (businessDataElementImpl == null) {
                businessDataElementImpl = new BusinessDataElementImpl();
                businessElementImpl.appendChild(businessDataElementImpl);
            }
            businessDataElementImpl.setData(node == null ? "" : BusinessElementImpl.XMLNode2String(node));
        }
        return businessElementImpl;
    }

    public org.w3c.dom.Node element2XMLNode(BusinessElementImpl businessElementImpl) {
        BusinessDataElementImpl businessDataElementImpl;
        if (businessElementImpl != null && (businessDataElementImpl = (BusinessDataElementImpl)businessElementImpl.getFirstChild()) != null) {
            return BusinessElementImpl.String2XMLNode(businessDataElementImpl.getData());
        }
        return null;
    }

    protected org.w3c.dom.Node attribute2XMLNode(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            return BusinessElementImpl.String2XMLNode(string2);
        }
        return null;
    }

    protected void XMLNode2Attribute(org.w3c.dom.Node node, String string) {
        this.setAttribute(string, node == null ? "" : BusinessElementImpl.XMLNode2String(node));
    }

    public static synchronized org.w3c.dom.Node String2XMLNode(String string) {
        return XMLNode.FromString2XmlNode(string);
    }

    public static synchronized Node String2BaanXMLNode(String string) {
        return XMLNode.FromString2BaanXmlNode(string);
    }

    public static synchronized String XMLNode2String(org.w3c.dom.Node node) {
        return XMLNode.FromXmlNode2String(node);
    }

    public static synchronized String XMLNode2String(Node node) {
        return XMLNode.FromXmlNode2String(node);
    }

    public char element2char(BusinessElementImpl businessElementImpl) {
        String string = this.element2String(businessElementImpl);
        if (string.length() == 1) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public BusinessElementImpl char2Element(char c, String string, BusinessElementImpl businessElementImpl) {
        return this.String2Element("" + c, string, businessElementImpl);
    }

    protected char attribute2char(String string) {
        String string2 = this.attribute2String(string);
        if (string2.length() == 1) {
            return string2.charAt(0);
        }
        return '\u0000';
    }

    protected void char2Attribute(char c, String string) {
        this.setAttribute(string, "" + c);
    }

    public static synchronized Date String2Date(String string) {
        if (string == null) {
            return DEFAULT_DATE;
        }
        try {
            return simpleDateFormat.parse(string, new ParsePosition(0));
        }
        catch (Exception exception) {
            s_logger.message("Failed to convert string2date " + string + "; retruned " + DEFAULT_DATE);
            return DEFAULT_DATE;
        }
    }

    public static synchronized String Date2String(Date date) {
        try {
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            s_logger.message("Failed to convert Date2Sting " + date + "; returned 1900-01-01T00:00:00");
            return "1900-01-01T00:00:00";
        }
    }

    static {
        staticElementsByTagName = new Hashtable();
        Calendar calendar = Calendar.getInstance(B3TIMEZONE);
        calendar.set(1900, 0, 1, 0, 0, 0);
        DEFAULT_DATE = calendar.getTime();
        Qounter = 0;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        simpleDateFormat.setTimeZone(B3TIMEZONE);
    }

    public static class BusinessElementHack
    extends BusinessObject {
        public static BusinessElementImpl getElement(BusinessObject businessObject) {
            return BusinessObject.getBusinessElement(businessObject);
        }

        public static String[] getNames(Class clazz) {
            return BusinessObject.getNames(clazz);
        }
    }
}

