/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co.dom;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.eibus.co.BusDoc;
import com.eibus.co.BusinessElementLink;
import com.eibus.co.CommunicationObject;
import com.eibus.co.Constructor;
import com.eibus.co.ContentInfoCo;
import com.eibus.co.Control;
import com.eibus.co.DataSet;
import com.eibus.co.Header;
import com.eibus.co.LicenseInfoCo;
import com.eibus.co.Sender;
import com.eibus.co.UserInfoCo;
import com.eibus.co.dom.BusinessElementImpl;
import com.eibus.co.dom.CommunicationObjectImpl;
import com.eibus.co.dom.HeaderImpl;
import com.eibus.co.dom.ReceiverImpl;
import com.eibus.co.dom.UserInfoCoImpl;
import com.eibus.connection.Message;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import com.eibus.services.guid.Guid;
import com.eibus.version.ProtocolVersion;
import com.eibus.xml.dom.DocumentImpl;
import com.eibus.xml.util.DOMWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BusDocImpl
extends DocumentImpl
implements BusDoc {
    private HeaderImpl header;
    private BusinessElementImpl documentElement;
    private UserInfoCo m_userinfoCO;
    private LicenseInfoCo m_licenseInfoCO;
    private ContentInfoCo m_contentInfoCO;
    private boolean containsErrors = false;
    private Vector errors = new Vector();
    private Hashtable links = new Hashtable();
    private static int counter = 0;

    public BusDocImpl() {
        this.documentElement = new BusinessElementImpl("busdoc");
        this.header = new HeaderImpl();
        this.documentElement.appendChild(this.header);
    }

    public void createEmptyMessageDigest() {
        this.documentElement.setAttribute("MD", "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
    }

    public void removeEmptyMessageDigest() {
        this.documentElement.removeAttribute("MD");
    }

    public void setUserInfoFromParser(UserInfoCo userInfoCo) {
        if (this.m_userinfoCO != null) {
            this.removeChild(this.m_userinfoCO);
        }
        this.addCO(userInfoCo);
        this.m_userinfoCO = userInfoCo;
    }

    public void setUserInfo(UserInfoCo userInfoCo) {
        if (this.m_userinfoCO != null) {
            this.removeChild(this.m_userinfoCO);
        }
        UserInfoCoImpl userInfoCoImpl = new UserInfoCoImpl();
        userInfoCoImpl.setUsername(userInfoCo.getUsername(true), true);
        userInfoCoImpl.setPassword(userInfoCo.getPassword(true), true);
        this.addCO(userInfoCoImpl);
        this.m_userinfoCO = userInfoCoImpl;
        this.createEmptyMessageDigest();
        if (this.getVersion() == 0) {
            this.setVersion(1);
        }
    }

    public UserInfoCo getUserInfo() {
        return this.m_userinfoCO;
    }

    public void setLicenseInfo(LicenseInfoCo licenseInfoCo) {
        if (this.m_licenseInfoCO != null) {
            this.removeChild(this.m_licenseInfoCO);
        }
        this.addCO(licenseInfoCo);
        this.m_licenseInfoCO = licenseInfoCo;
        this.createEmptyMessageDigest();
        this.setVersion(3);
    }

    public void setContentInfo(ContentInfoCo contentInfoCo) {
        if (contentInfoCo != null) {
            if (this.m_contentInfoCO != null) {
                this.removeChild(this.m_contentInfoCO);
            }
            this.addCO(contentInfoCo);
            this.m_contentInfoCO = contentInfoCo;
            this.createEmptyMessageDigest();
            this.setVersion(4);
        }
    }

    public LicenseInfoCo getLicenseInfo() {
        return this.m_licenseInfoCO;
    }

    public ContentInfoCo getContentInfo() {
        return this.m_contentInfoCO;
    }

    public Control getControl() {
        CommunicationObject communicationObject = this.getFirstCO();
        while (communicationObject != null && !(communicationObject instanceof Control)) {
            communicationObject = communicationObject.getNextCO();
        }
        return (Control)communicationObject;
    }

    public Constructor getConstructor() {
        CommunicationObject communicationObject = this.getFirstCO();
        while (communicationObject != null && !(communicationObject instanceof Constructor)) {
            communicationObject = communicationObject.getNextCO();
        }
        return (Constructor)communicationObject;
    }

    public DataSet getDataSet() {
        return null;
    }

    public void setHeader(Header header) {
        if (this.header != null) {
            this.removeChild(this.header);
        } else {
            this.header = (HeaderImpl)this.appendChild((HeaderImpl)header);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public BusDoc createReply() {
        URI uRI = this.header.getReceiver().getSentTo();
        BusComponent busComponent = this.header.getReceiver().getComponent();
        URI uRI2 = this.header.getSender().getReplyTo();
        BusComponent busComponent2 = this.header.getSender().getComponent();
        Guid guid = this.header.getCorrelationId();
        String string = this.header.getTransactionId();
        BusDocImpl busDocImpl = new BusDocImpl();
        if (uRI != null) {
            busDocImpl.header.getSender().setReplyTo(uRI);
        }
        if (busComponent != null) {
            busDocImpl.header.getSender().setComponent(busComponent);
        }
        if (uRI2 != null) {
            busDocImpl.header.getReceiver().setSentTo(uRI2);
        }
        if (busComponent2 != null) {
            busDocImpl.header.getReceiver().setComponent(busComponent2);
        }
        busDocImpl.header.setCorrelationId(guid);
        if (string != null) {
            busDocImpl.header.setTransactionId(string);
        }
        return busDocImpl;
    }

    public void setSender(BusComponent busComponent) {
        block2: {
            Sender sender = this.header.getSender();
            sender.setComponent(busComponent);
            ConnectionPoint connectionPoint = busComponent.getPreferredConnection();
            if (connectionPoint == null) break block2;
            try {
                sender.setReplyTo(connectionPoint.getURI());
            }
            catch (MalformedURIException malformedURIException) {}
        }
    }

    public void setReceiver(BusComponent busComponent) {
        block2: {
            ReceiverImpl receiverImpl = (ReceiverImpl)this.header.getReceiver();
            receiverImpl.setComponent(busComponent);
            ConnectionPoint connectionPoint = busComponent.getPreferredConnection();
            if (connectionPoint == null) break block2;
            try {
                receiverImpl.setSentTo(connectionPoint.getURI());
            }
            catch (MalformedURIException malformedURIException) {}
        }
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public Node getFirstChild() {
        return this.documentElement;
    }

    public void addCO(CommunicationObject communicationObject) {
        this.documentElement.appendChild((CommunicationObjectImpl)communicationObject);
    }

    public CommunicationObject getFirstCO() {
        return (CommunicationObject)this.header.getNextSibling();
    }

    public void deleteCOs() {
        CommunicationObject communicationObject = this.getFirstCO();
        while (communicationObject != null) {
            this.documentElement.removeChild(communicationObject);
            communicationObject = communicationObject.getNextCO();
        }
    }

    public boolean hasErrors() {
        return this.containsErrors;
    }

    public void addError(CommunicationObject communicationObject) {
        this.containsErrors = true;
        this.errors.addElement(communicationObject);
    }

    public Enumeration getErrors() {
        return this.errors.elements();
    }

    public BusinessElementLink getLink(String string) {
        BusinessElementLink businessElementLink = (BusinessElementLink)this.links.get(string);
        if (businessElementLink == null) {
            businessElementLink = new BusinessElementLink(string, this.getHeader().getCorrelationId());
            this.links.put(string, businessElementLink);
        }
        return businessElementLink;
    }

    public Enumeration getLinks() {
        return this.links.elements();
    }

    public void mergeLinks(Hashtable hashtable) {
        this.mergeLinks(hashtable.elements());
    }

    public void mergeLinks(Enumeration enumeration2) {
        while (enumeration2.hasMoreElements()) {
            BusinessElementLink businessElementLink = (BusinessElementLink)enumeration2.nextElement();
            String string = businessElementLink.getIdentifier();
            BusinessElementLink businessElementLink2 = (BusinessElementLink)this.links.get(string);
            if (businessElementLink2 == null) {
                this.links.put(string, businessElementLink);
                continue;
            }
            if (businessElementLink.equals(businessElementLink2)) continue;
            string = "" + counter++ + "_" + string;
            businessElementLink.setIdentifier(string);
            this.links.put(string, businessElementLink);
        }
    }

    public boolean hasLink(String string) {
        return this.links.get(string) != null;
    }

    public Message toMessage() {
        if (this.header.getCorrelationId() == null) {
            this.header.generateNewCorrelationId();
        }
        byte[] byArray = new DOMWriter(this).getBytes();
        Message message = new Message(byArray);
        message.setReceiver(this.getHeader().getReceiver().getComponent());
        message.setURI(this.getHeader().getReceiver().getSentTo());
        return message;
    }

    public int getVersion() {
        String string = this.documentElement.getAttribute("version");
        return ProtocolVersion.StringToVersion(string);
    }

    public void setVersion(int n) {
        if (n == 0) {
            String string = this.documentElement.getAttribute("version");
            if (string != null) {
                this.documentElement.removeAttribute("version");
            }
        } else {
            this.documentElement.setAttribute("version", "" + n);
        }
    }

    public void setMessageDigest(String string) {
        this.documentElement.setAttribute("MD", string);
    }
}

