/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co;

import com.eibus.co.BusinessElement;
import com.eibus.co.Tuple;
import com.eibus.services.guid.Guid;
import java.util.Enumeration;
import java.util.Vector;

public class BusinessElementLink {
    public static final String ID_ATTRIBUTE = "id";
    public static final String HREF_ATTRIBUTE = "href";
    BusinessElement resource;
    Tuple tuple;
    Vector hrefs = new Vector();
    String identifier;
    Guid guid;

    public BusinessElementLink(String string) {
        this.identifier = string;
    }

    public BusinessElementLink(String string, Guid guid) {
        this.identifier = string;
        this.guid = guid;
    }

    public Guid getBaseIdentifier() {
        return this.guid;
    }

    public void setBaseIdentifier(Guid guid) {
        this.guid = guid;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
        int n = this.hrefs.size();
        int n2 = 0;
        while (n2 < n) {
            ((BusinessElement)this.hrefs.elementAt(n2)).setLink(this);
            ++n2;
        }
        if (this.tuple != null) {
            this.tuple.setLink(this);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setTuple(Tuple tuple) {
        this.tuple = tuple;
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public void addBusinessElement(BusinessElement businessElement) {
        this.hrefs.addElement(businessElement);
    }

    public void removeBusinessElement(BusinessElement businessElement) {
        while (this.hrefs.removeElement(businessElement)) {
        }
    }

    public Enumeration getBusinessElements() {
        return this.hrefs.elements();
    }

    public Vector removeReferencingBusinessElements() {
        Vector vector = this.hrefs;
        this.hrefs = null;
        return vector;
    }

    public Vector removeIllegalReferences() {
        Vector<BusinessElement> vector = new Vector<BusinessElement>();
        int n = this.hrefs.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            BusinessElement businessElement = (BusinessElement)this.hrefs.elementAt(n2);
            if (businessElement.getTuple() == null) {
                this.hrefs.removeElementAt(n2);
                vector.addElement(businessElement);
            }
            --n2;
        }
        return vector;
    }

    public BusinessElement getResource() {
        if (this.resource == null && this.tuple != null) {
            this.resource = this.tuple.getCurrent();
            if (this.resource == null) {
                this.resource = this.tuple.getOriginal();
            }
        }
        return this.resource;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BusinessElementLink)) {
            return false;
        }
        BusinessElementLink businessElementLink = (BusinessElementLink)object;
        if (!this.identifier.equals(businessElementLink.identifier)) {
            return false;
        }
        return this.guid.equals(businessElementLink.guid);
    }

    public String toString() {
        return this.identifier;
    }
}

