/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.co;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.Constructor;
import com.eibus.co.ILanguageObjectFactory;
import com.eibus.co.parser.ConstructorHandler;
import com.eibus.co.parser.EventDelegator;
import java.util.Hashtable;
import java.util.Properties;

public abstract class AbstractLangObjFactory
implements ILanguageObjectFactory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.co", "AbstractLangObjFactory");
    private static final Properties s_knownLanguages = new Properties();
    private static final Hashtable s_cachedClasses = new Hashtable();

    public static ILanguageObjectFactory getFactory(String string) throws InstantiationException {
        ILanguageObjectFactory iLanguageObjectFactory = (ILanguageObjectFactory)s_cachedClasses.get(string);
        if (iLanguageObjectFactory == null) {
            String string2 = s_knownLanguages.getProperty(string);
            if (string2 == null) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(string2);
                iLanguageObjectFactory = (ILanguageObjectFactory)clazz.newInstance();
                s_cachedClasses.put(string, iLanguageObjectFactory);
            }
            catch (Exception exception) {
                s_logger.message("Exception in com.eibus.co.AbstractLangObjFactory.getFactory:");
                s_logger.errorException(exception);
                throw new InstantiationException(exception.toString());
            }
        }
        return iLanguageObjectFactory;
    }

    public abstract ConstructorHandler createConstructorHandler(EventDelegator var1);

    public abstract Constructor createConstructor(String var1);

    static {
        ((Hashtable)s_knownLanguages).put("BaanDLL", "com.eibus.co.DllObjectFactory");
        ((Hashtable)s_knownLanguages).put("BaanSQL", "com.eibus.co.SqlObjectFactory");
        ((Hashtable)s_knownLanguages).put("QueryByDLL", "com.eibus.co.QueryByDLLObjectFactory");
        ((Hashtable)s_knownLanguages).put("LocalFile", "com.eibus.co.LocalFileObjectFactory");
    }
}

