/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.bdf;

import com.baan.b3.dom.Node;
import com.eibus.co.BusinessElement;
import com.eibus.co.BusinessElementLink;
import com.eibus.co.Tuple;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

class TupleStore {
    Reference first;
    Reference last;

    TupleStore() {
    }

    void insert(Tuple tuple) {
        Reference reference = new Reference(tuple);
        if (!this.contains(reference)) {
            reference.findLinks(reference.tuple);
            reference.tuple.removeAllErrors();
            this.append(reference);
        }
    }

    boolean contains(Tuple tuple) {
        return this.contains(new Reference(tuple));
    }

    void remove(Tuple tuple) {
        this.remove(new Reference(tuple));
    }

    Enumeration links() {
        return new LinkEnumerator();
    }

    Enumeration tuples() {
        return new TupleEnumerator();
    }

    private boolean contains(Reference reference) {
        Reference reference2 = this.first;
        while (reference2 != null) {
            if (reference2.tuple == reference.tuple) {
                return true;
            }
            reference2 = reference2.next;
        }
        return false;
    }

    private void append(Reference reference) {
        if (this.first == null) {
            this.first = this.last = reference;
            reference.next = null;
            reference.prev = null;
        } else {
            this.last.next = reference;
            reference.next = null;
            reference.prev = this.last;
            this.last = reference;
        }
    }

    private void remove(Reference reference) {
        Reference reference2 = this.first;
        while (reference2 != null) {
            if (reference2.tuple == reference.tuple) {
                if (this.first == reference2) {
                    this.first = reference2.next;
                } else {
                    reference2.prev.next = reference2.next;
                }
                if (this.last == reference2) {
                    this.last = reference2.prev;
                } else {
                    reference2.next.prev = reference2.prev;
                }
                reference2.next = null;
                reference2.prev = null;
                return;
            }
            reference2 = reference2.next;
        }
    }

    class TupleEnumerator
    implements Enumeration {
        Reference current;

        TupleEnumerator() {
            this.current = TupleStore.this.first;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            if (this.current != null) {
                Tuple tuple = this.current.tuple;
                this.current = this.current.next;
                return tuple;
            }
            throw new NoSuchElementException();
        }
    }

    class LinkEnumerator
    implements Enumeration {
        Reference current;
        Enumeration currentLinkEnumerator;
        Object next;

        LinkEnumerator() {
            this.current = TupleStore.this.first;
            if (this.current != null) {
                this.currentLinkEnumerator = this.current.links.elements();
            }
        }

        public boolean hasMoreElements() {
            if (this.next != null) {
                return true;
            }
            this.next = this.findNext();
            return this.next != null;
        }

        Object findNext() {
            while (this.current != null) {
                if (this.currentLinkEnumerator.hasMoreElements()) {
                    return this.currentLinkEnumerator.nextElement();
                }
                if (this.current.next == null) {
                    return null;
                }
                this.current = this.current.next;
                this.currentLinkEnumerator = this.current.links.elements();
            }
            return null;
        }

        public Object nextElement() {
            if (this.next != null) {
                Object object = this.next;
                this.next = this.findNext();
                return object;
            }
            throw new NoSuchElementException();
        }
    }

    class Reference {
        Reference next;
        Reference prev;
        Tuple tuple;
        Vector links = new Vector();

        Reference(Tuple tuple) {
            this.tuple = tuple;
        }

        void findLinks(BusinessElement businessElement) {
            BusinessElementLink businessElementLink = businessElement.getLink();
            if (businessElementLink != null) {
                this.links.addElement(businessElementLink);
            }
            Node node = businessElement.getFirstChild();
            while (node != null) {
                if (node instanceof BusinessElement) {
                    this.findLinks((BusinessElement)node);
                }
                node = node.getNextSibling();
            }
        }
    }
}

