/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.bdf;

import com.baan.b3.dom.Node;
import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.bdf.ProtocolErrors;
import com.eibus.co.BusDoc;
import com.eibus.co.BusinessElement;
import com.eibus.co.CommunicationObject;
import com.eibus.co.DataSet;
import com.eibus.co.SynchronizationError;
import com.eibus.co.Tuple;
import com.eibus.co.Update;
import com.eibus.exception.BusException;
import com.eibus.services.guid.Guid;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Synchronization {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.bdf", "Synchronization");
    public static String SYNC_ATTRIBUTE = "sync_id";
    private Dictionary syncsPerBackend = new Hashtable();
    private Dictionary localTuples = new Hashtable();
    private Connection connection = null;
    private Guid transactionId = null;
    private boolean conditional = false;
    private long timeout = 30000L;
    private int m_transactionScope = 0;
    private SyncBackend m_sb = null;

    public Synchronization() throws BusException {
    }

    public Synchronization(Vector vector) throws BusException {
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            BusinessDocumentManager businessDocumentManager = (BusinessDocumentManager)enumeration2.nextElement();
            this.addManager(businessDocumentManager);
        }
    }

    public void addManager(BusinessDocumentManager businessDocumentManager) throws BusException {
        Enumeration enumeration2;
        Connection connection = businessDocumentManager.getConnection();
        if (connection == null) {
            throw new BusException("Manager " + businessDocumentManager + " has no Connection specified");
        }
        if (this.connection == null) {
            this.connection = connection;
        }
        if (!this.connection.equals(connection)) {
            throw new BusException("Cannot add manager that has a different connection");
        }
        SyncBackend syncBackend = (SyncBackend)this.syncsPerBackend.get(connection.toString());
        if (syncBackend == null) {
            syncBackend = new SyncBackend();
            this.syncsPerBackend.put(connection.toString(), syncBackend);
        }
        this.m_sb = syncBackend;
        if (syncBackend.managers.contains(businessDocumentManager)) {
            s_logger.message("Adding manager for the second time to Synchronization. Will be ignored.");
            return;
        }
        int n = syncBackend.managers.size();
        this.m_transactionScope = n == 0 ? businessDocumentManager.getTransactionScope() : 1;
        syncBackend.managers.addElement(businessDocumentManager);
        if (businessDocumentManager.timeout == 0L || businessDocumentManager.timeout > this.timeout) {
            this.timeout = businessDocumentManager.timeout;
        }
        if (syncBackend.busdoc == null) {
            syncBackend.busdoc = businessDocumentManager.factory.createBusDoc();
        }
        if ((enumeration2 = businessDocumentManager.memory.tuples()).hasMoreElements()) {
            Update update = businessDocumentManager.factory.createUpdate();
            while (enumeration2.hasMoreElements()) {
                update.addTuple((Tuple)enumeration2.nextElement());
            }
            syncBackend.busdoc.addCO(update);
            syncBackend.busdoc.mergeLinks(businessDocumentManager.memory.links());
            syncBackend.objectsPresent = true;
        } else {
            s_logger.message("Manager " + businessDocumentManager + " did not contain any elements to synchronize");
        }
    }

    public void setTransactionId(Guid guid) {
        this.transactionId = guid;
    }

    public Guid getTransactionId() {
        return this.transactionId;
    }

    public void setTimeOut(long l) {
        this.timeout = l;
    }

    public long getTimeOut() {
        return this.timeout;
    }

    public void setUnconditional(boolean bl) {
        this.conditional = bl;
        Enumeration enumeration2 = this.syncsPerBackend.elements();
        while (enumeration2.hasMoreElements()) {
            CommunicationObject communicationObject = ((SyncBackend)enumeration2.nextElement()).busdoc.getFirstCO();
            while (communicationObject != null) {
                if (communicationObject instanceof Update) {
                    ((Update)communicationObject).setUnconditional(bl);
                }
                communicationObject = communicationObject.getNextCO();
            }
        }
    }

    public boolean isUnconditional() {
        return this.conditional;
    }

    public void execute() throws BusSynchronizationException, BusTimeOutException, BusException {
        Object object;
        Enumeration enumeration2 = this.syncsPerBackend.elements();
        Vector<BusDoc> vector = new Vector<BusDoc>();
        int n = 0;
        while (enumeration2.hasMoreElements()) {
            SyncBackend syncBackend = (SyncBackend)enumeration2.nextElement();
            if (!syncBackend.objectsPresent) continue;
            vector.addElement(syncBackend.busdoc);
            n = syncBackend.managers.size();
            int n2 = 0;
            while (n2 < n) {
                object = (BusinessDocumentManager)syncBackend.managers.elementAt(n2);
                ((BusinessDocumentManager)object).registerManager();
                ((BusinessDocumentManager)object).releaseAll();
                ++n2;
            }
        }
        int n3 = vector.size();
        if (n3 != 0) {
            Object[] objectArray = new BusDoc[n3];
            object = new BusDoc[n3];
            vector.copyInto(objectArray);
            this.storeLocalTuples((BusDoc[])objectArray);
            if (this.m_transactionScope == 3) {
                Update update = (Update)this.m_sb.busdoc.getFirstCO();
                update.setTransactionScope(3);
            }
            int n4 = 0;
            while (n4 < n3) {
                s_logger.message("Syncronisation.execute(), sending busdoc " + n4 + "/" + n3);
                LogEvent logEvent = LoggerFactory.createLogEvent(objectArray[n4].getHeader().getCorrelationId());
                logEvent.storeMessage("Syncronisation.execute(), create new busdoc");
                logEvent.storeMessage("Backend connection trough BusComponentID '" + this.connection.getServerComponentId() + "'");
                object[n4] = this.connection.sendAndWaitForAnswer((BusDoc)objectArray[n4], this.timeout);
                logEvent.storeMessage("Retreived answer from backend");
                logEvent.storeXml((Node)object[n4]);
                if (objectArray[n4].getVersion() != object[n4].getVersion()) {
                    logEvent.storeMessage("BusDoc protocol versions are not equal. request ver.= " + objectArray[n4].getVersion() + ", reply ver.= " + object[n4].getVersion());
                    s_logger.errorEvent(logEvent);
                    logEvent = null;
                    throw new BusException("BusDoc protocol versions are not equal. request ver.= " + objectArray[n4].getVersion() + ", reply ver.= " + object[n4].getVersion());
                }
                s_logger.message("BusDoc Protocols are equal version = " + objectArray[n4].getVersion());
                ++n4;
            }
            this.updateLocalMemory((BusDoc[])objectArray, (BusDoc[])object);
            ProtocolErrors.seekAndThrowSynchronizeExceptions((BusDoc[])object);
            int n5 = 0;
            while (n5 < n3) {
                LoggerFactory.removeLogEvent(objectArray[n5].getHeader().getCorrelationId());
                ++n5;
            }
        }
    }

    private void updateLocalMemory(BusDoc[] busDocArray, BusDoc[] busDocArray2) throws BusSynchronizationException, BusApplicationException {
        Tuple tuple;
        Object object;
        int n = 0;
        while (n < busDocArray2.length) {
            object = busDocArray2[n].getFirstCO();
            while (object != null) {
                if (object instanceof Update) {
                    tuple = ((Update)object).getFirstTuple();
                    while (tuple != null) {
                        this.updateTuple(tuple);
                        tuple = tuple.getNextTuple();
                    }
                }
                object = object.getNextCO();
            }
            ++n;
        }
        object = this.localTuples.elements();
        while (object.hasMoreElements()) {
            tuple = (Tuple)object.nextElement();
            tuple.removeAttribute(SYNC_ATTRIBUTE);
            tuple.getParentNode().removeChild(tuple);
            tuple.reset();
        }
    }

    private void updateTuple(Tuple tuple) {
        BusinessElement businessElement;
        Object object;
        Tuple tuple2 = (Tuple)this.localTuples.remove(tuple.getAttribute(SYNC_ATTRIBUTE));
        if (tuple2 == null) {
            return;
        }
        tuple2.removeAttribute(SYNC_ATTRIBUTE);
        tuple2.getParentNode().removeChild(tuple2);
        BusinessElement businessElement2 = tuple2.getOriginal();
        BusinessElement businessElement3 = tuple2.getCurrent();
        BusinessElement businessElement4 = tuple.getOriginal();
        BusinessElement businessElement5 = tuple.getCurrent();
        Enumeration enumeration2 = tuple.getWarnings();
        while (enumeration2.hasMoreElements()) {
            object = (SynchronizationError)enumeration2.nextElement();
            tuple2.addError((SynchronizationError)object);
            businessElement = tuple2.getBusinessElement();
            object.setBusinessElement(businessElement);
            BusinessDocumentManager businessDocumentManager = businessElement.getManager();
            if (businessDocumentManager == null) continue;
            businessDocumentManager.addWarning(object);
        }
        object = tuple.getErrors();
        if (object.hasMoreElements()) {
            while (object.hasMoreElements()) {
                businessElement = (SynchronizationError)object.nextElement();
                tuple2.addError((SynchronizationError)businessElement);
                businessElement.setBusinessElement(tuple2.getBusinessElement());
            }
            if (businessElement2 == null) {
                tuple2.setOriginal(businessElement4);
            } else {
                businessElement2.initialize(businessElement4);
            }
        } else {
            tuple2.setOriginal(null);
        }
        if (businessElement3 != null) {
            businessElement3.initialize(businessElement5);
        } else {
            tuple2.setCurrent(businessElement5);
        }
        tuple.setOriginal(null);
        tuple.setCurrent(null);
    }

    private void storeLocalTuples(BusDoc[] busDocArray) {
        int n = 0;
        while (n < busDocArray.length) {
            CommunicationObject communicationObject = busDocArray[n].getFirstCO();
            int n2 = 0;
            while (communicationObject != null) {
                if (communicationObject instanceof DataSet) {
                    Tuple tuple = ((DataSet)communicationObject).getFirstTuple();
                    while (tuple != null) {
                        String string = n > 0 ? "" + n + "_" + n2 : "" + n2;
                        tuple.setAttribute(SYNC_ATTRIBUTE, string);
                        ++n2;
                        this.localTuples.put(string, tuple);
                        tuple = tuple.getNextTuple();
                    }
                }
                communicationObject = communicationObject.getNextCO();
            }
            ++n;
        }
    }

    class SyncBackend {
        BusDoc busdoc;
        boolean objectsPresent;
        Vector managers = new Vector();

        SyncBackend() {
        }
    }
}

