/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.bdf;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.co.BusDoc;
import com.eibus.co.BusError;
import com.eibus.exception.BusException;
import java.util.Enumeration;
import java.util.Vector;

public class ProtocolErrors {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.bdf", "ProtocolErrors");

    public static void seekAndThrowSynchronizeExceptions(BusDoc[] busDocArray) throws BusSynchronizationException {
        Object object;
        Vector vector = new Vector();
        int n = 0;
        while (n < busDocArray.length) {
            if (busDocArray[n].hasErrors()) {
                object = LoggerFactory.getLogEvent(busDocArray[n].getHeader().getCorrelationId());
                ((LogEvent)object).storeMessage("Error in 'update' reply detected !");
                Enumeration enumeration2 = busDocArray[n].getErrors();
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement());
                }
                s_logger.errorEvent((LogEvent)object);
            }
            ++n;
        }
        if (vector.size() > 0) {
            object = new BusSynchronizationException("");
            ((BusApplicationException)object).setErrors(vector);
            throw object;
        }
    }

    public static void seekAndThrowManagerExceptions(BusDoc busDoc) throws BusApplicationException, BusException {
        if (busDoc.hasErrors()) {
            Object object;
            LogEvent logEvent = LoggerFactory.getLogEvent(busDoc.getHeader().getCorrelationId());
            logEvent.storeMessage("Error in reply detected");
            Enumeration enumeration2 = busDoc.getErrors();
            Vector<Object> vector = new Vector<Object>();
            while (enumeration2.hasMoreElements()) {
                object = (BusError)enumeration2.nextElement();
                if (object.getErrorType() == 1) {
                    Object object2;
                    String string = "";
                    Enumeration enumeration3 = object.getErrorMessages();
                    if (enumeration3 != null && (object2 = enumeration3.nextElement()) != null) {
                        string = object2.toString();
                    }
                    logEvent.storeMessage("generate BusException, " + string);
                    object2 = new BusException(string);
                    s_logger.errorEvent(logEvent);
                    throw object2;
                }
                vector.addElement(object);
            }
            object = busDoc.getHeader().getCorrelationId().toString();
            BusApplicationException busApplicationException = new BusApplicationException((String)object);
            busApplicationException.setErrors(vector);
            logEvent.storeMessage("generate BusApplicationException, " + busApplicationException.toString());
            s_logger.errorEvent(logEvent);
            throw busApplicationException;
        }
    }
}

