/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.bdf;

import com.baan.b3impl.boi1.IBusinessElementAdapter;
import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.BusinessElement;
import com.eibus.co.Cursor;
import com.eibus.co.DataSet;
import com.eibus.co.MetaData;
import com.eibus.co.Query;
import com.eibus.co.Tuple;
import com.eibus.exception.BusException;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.Registry;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Iterator {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.bdf", "Iterator");
    private static final ILogger s_innerSetLogger = LoggerFactory.createLogger("com.eibus.bdf.Iterator", "Set");
    private static int initialBufferSize;
    private Set currentSet = null;
    private MetaData metadata = null;
    private int nextSize = initialBufferSize;
    private SetBuffer setBuffer = null;
    private FetchThread fetchThread = null;
    static /* synthetic */ Class class$com$eibus$co$BusinessElement;

    public Iterator() {
    }

    public Iterator(Query query, BusinessDocumentManager businessDocumentManager, Class clazz) {
        this.initialize(query, businessDocumentManager, clazz, null);
    }

    public Iterator(Query query, BusinessDocumentManager businessDocumentManager, Class clazz, String string) {
        this.initialize(query, businessDocumentManager, clazz, string);
    }

    public Iterator(Query query, BusinessDocumentManager businessDocumentManager) {
        this.initialize(query, businessDocumentManager, class$com$eibus$co$BusinessElement == null ? (class$com$eibus$co$BusinessElement = Iterator.class$("com.eibus.co.BusinessElement")) : class$com$eibus$co$BusinessElement, null);
    }

    private void initialize(Query query, BusinessDocumentManager businessDocumentManager, Class clazz, String string) {
        if (query == null) {
            throw new NullPointerException("Query cannot be null in an Iterator");
        }
        if (businessDocumentManager == null) {
            throw new NullPointerException("Manager cannot be null in an Iterator");
        }
        if (businessDocumentManager.getConnection() == null) {
            throw new NullPointerException("Manager must be initialized, connection may not be null");
        }
        this.setBuffer = new SetBuffer();
        this.fetchThread = new FetchThread(query, businessDocumentManager, clazz, string);
    }

    public synchronized BusinessElement nextElement() throws BusException, NoSuchElementException {
        BusinessElement businessElement;
        if (this.currentSet == null) {
            this.currentSet = this.setBuffer.getBufferedSet();
        }
        if ((businessElement = this.currentSet.getNextBusinessElement()) == null && this.currentSet.isLastSet) {
            throw new NoSuchElementException("No More Elements available");
        }
        if (businessElement == null && !this.currentSet.isLastSet) {
            this.currentSet = this.setBuffer.getBufferedSet();
            businessElement = this.currentSet.getNextBusinessElement();
        }
        if (businessElement == null) {
            throw new NoSuchElementException("No More Elements available");
        }
        return businessElement;
    }

    public boolean hasMoreElements() throws BusTimeOutException, BusException {
        if (this.currentSet == null) {
            this.currentSet = this.setBuffer.getBufferedSet();
        }
        if (this.currentSet.tuple == null) {
            if (this.currentSet.isLastSet) {
                return false;
            }
            this.currentSet = this.setBuffer.getBufferedSet();
            if (this.currentSet.tuple == null && this.currentSet.isLastSet) {
                return false;
            }
        }
        return true;
    }

    public MetaData getMetaData() throws BusException {
        if (this.currentSet == null) {
            this.currentSet = this.setBuffer.getBufferedSet();
        }
        return this.metadata;
    }

    public synchronized void hintNextBufferSize(int n) {
        if (n <= 0) {
            return;
        }
        this.nextSize = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            initialBufferSize = adapterClientConfiguration.getIteratorSize();
        }
        catch (OWConfigurationException oWConfigurationException) {
            initialBufferSize = 250;
        }
    }

    private class Set {
        public boolean isLastSet = false;
        BusApplicationException exception;
        private BusDoc set;
        private DataSet ds;
        public Tuple tuple;
        private Class m_elementType = null;
        private String m_typeName = null;

        private Set() {
        }

        synchronized BusinessElement getNextBusinessElement() throws BusException {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.tuple == null) {
                return null;
            }
            BusinessElement businessElement = this.tuple.getOriginal();
            if (businessElement == null) {
                throw new BusApplicationException("Backend sent invalid dataset");
            }
            this.setNextTuple();
            return businessElement;
        }

        public MetaData getMetaData() {
            if (this.ds != null) {
                return this.ds.getMetaData();
            }
            return null;
        }

        private void setNextTuple() {
            Tuple tuple = null;
            if (this.tuple == null) {
                tuple = this.ds.getFirstTuple();
            } else {
                tuple = this.tuple.getNextTuple();
                this.ds.removeTuple(this.tuple);
            }
            while (tuple != null) {
                IBusinessElementAdapter iBusinessElementAdapter;
                Class clazz;
                BusinessElement businessElement = tuple.getOriginal();
                if (businessElement != null && (this.m_elementType.isAssignableFrom(businessElement.getClass()) ? this.m_typeName == null || this.m_typeName.equals(businessElement.type()) : businessElement instanceof IBusinessElementAdapter && this.m_elementType.isAssignableFrom(clazz = (iBusinessElementAdapter = (IBusinessElementAdapter)((Object)businessElement)).getBusinessObjectClass()))) break;
                this.tuple = tuple;
                tuple = tuple.getNextTuple();
                this.ds.removeTuple(this.tuple);
            }
            this.tuple = tuple;
        }

        public synchronized Cursor setReplyBusdoc(BusDoc busDoc, Class clazz, String string) {
            Object object;
            Object object2;
            this.m_elementType = clazz;
            this.m_typeName = string;
            this.set = busDoc;
            Cursor cursor = null;
            if (busDoc.hasErrors()) {
                object2 = busDoc.getErrors();
                this.exception = new BusApplicationException("Errors in busdoc\n");
                object = new Vector();
                while (object2.hasMoreElements()) {
                    ((Vector)object).addElement(object2.nextElement());
                }
                this.exception.setErrors((Vector)object);
                s_innerSetLogger.message("The backend signaled an error. The following exception is available");
                s_innerSetLogger.errorException(this.exception);
            }
            if ((object2 = busDoc.getFirstCO()) instanceof DataSet) {
                this.ds = (DataSet)object2;
                object = this.ds.getRequest();
                if (object != null && object instanceof Query) {
                    Query query = (Query)object;
                    cursor = query.getCursor();
                    if (cursor == null) {
                        this.isLastSet = true;
                    } else if (cursor.getId() == null) {
                        this.isLastSet = true;
                    }
                    this.setNextTuple();
                } else {
                    this.exception = new BusApplicationException("Returned request did not contain query");
                }
            }
            return cursor;
        }
    }

    public class FetchThread
    extends Thread {
        private Query m_query = null;
        private BusinessDocumentManager m_manager = null;
        private BusDocFactory m_factory = null;
        private Cursor m_nextCursor = null;
        private Class m_elementType = null;
        private String m_typeName = null;
        private Guid m_guid = null;

        public FetchThread(Query query, BusinessDocumentManager businessDocumentManager, Class clazz, String string) {
            this.setName("Fetch");
            this.m_query = query;
            this.m_manager = businessDocumentManager;
            this.m_manager.registerFetchThread(this);
            this.m_factory = businessDocumentManager.getFactory();
            this.m_elementType = clazz;
            this.m_typeName = string;
            this.start();
        }

        public void run() {
            try {
                Set set;
                do {
                    set = this.fetchSet();
                    Iterator.this.setBuffer.putBufferedSet(set);
                } while (!set.isLastSet);
                this.m_manager.unregisterFetchThread(this);
            }
            catch (BusException busException) {
                Iterator.this.setBuffer.putBusException(busException);
                this.m_manager.unregisterFetchThread(this);
            }
        }

        private Set fetchSet() throws BusException {
            Set set = null;
            BusDoc busDoc = this.m_factory.createBusDoc();
            busDoc.setContentInfo(this.m_manager.getContentInfo());
            Cursor cursor = this.m_query.getCursor();
            if (cursor == null) {
                cursor = this.m_query.createCursor();
            }
            cursor.setNumberOfRows(Iterator.this.nextSize);
            if (this.m_nextCursor != null) {
                if (this.m_nextCursor.getPosition() > 0) {
                    cursor.setPosition(this.m_nextCursor.getPosition());
                }
                if (this.m_nextCursor.getId() != null) {
                    cursor.setId(this.m_nextCursor.getId());
                }
                if (this.m_nextCursor.getParameterIndex() != null) {
                    cursor.setParameterIndex(this.m_nextCursor.getParameterIndex());
                }
            }
            if (this.m_manager.metaData && Iterator.this.metadata == null) {
                this.m_query.enableMetaData(true);
            } else {
                this.m_query.enableMetaData(false);
            }
            busDoc.addCO(this.m_query);
            this.m_guid = busDoc.getHeader().getCorrelationId();
            LogEvent logEvent = LoggerFactory.createLogEvent(this.m_guid);
            logEvent.storeMessage("Iterator.fetchSet(), create busdoc (BaanSQL) fetch size = " + Iterator.this.nextSize);
            Registry.registerManager(this.m_guid, null, null, this.m_manager);
            BusDoc busDoc2 = this.m_manager.sendAndWaitForAnswer(busDoc);
            if (busDoc.getVersion() != busDoc2.getVersion()) {
                logEvent.storeMessage("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
                s_logger.errorEvent(logEvent);
                logEvent = null;
                throw new BusException("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
            }
            s_logger.message("BusDoc Protocols are equal version = " + busDoc.getVersion());
            LoggerFactory.removeLogEvent(logEvent);
            Registry.unRegisterManager(this.m_guid, null, null);
            set = new Set();
            this.m_nextCursor = set.setReplyBusdoc(busDoc2, this.m_elementType, this.m_typeName);
            if (this.m_manager.metaData && Iterator.this.metadata == null) {
                Iterator.this.metadata = set.getMetaData();
            }
            if (set.exception != null) {
                BusApplicationException busApplicationException = set.exception;
                set = null;
                throw busApplicationException;
            }
            return set;
        }

        public void stopAndClear() {
            this.m_manager.unregisterFetchThread(this);
            this.m_nextCursor = null;
            Registry.unRegisterManager(this.m_guid, null, null);
            this.stop();
        }
    }

    private class SetBuffer {
        private Set m_bufferedSet = null;
        private boolean m_setUpdated = false;
        private BusException m_lastBusException = null;

        private SetBuffer() {
        }

        synchronized Set getBufferedSet() throws BusException {
            if (!this.m_setUpdated) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_setUpdated = false;
            this.notify();
            if (this.m_lastBusException == null) {
                return this.m_bufferedSet;
            }
            throw this.m_lastBusException;
        }

        synchronized void putBufferedSet(Set set) {
            if (this.m_setUpdated) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_bufferedSet = set;
            this.m_setUpdated = true;
            this.notify();
        }

        synchronized void putBusException(BusException busException) {
            if (this.m_setUpdated) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_lastBusException = busException;
            this.m_setUpdated = true;
            this.notify();
        }
    }
}

