/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.bdf;

import com.baan.b3.boi1.BoiProgrammingRException;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3impl.boi1.IBusinessElementAdapter;
import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.ConnectionFactory;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BackendConnection;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.bdf.Iterator;
import com.eibus.bdf.ProtocolErrors;
import com.eibus.bdf.Synchronization;
import com.eibus.bdf.TupleStore;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.BusinessElement;
import com.eibus.co.CommunicationObject;
import com.eibus.co.Constructor;
import com.eibus.co.ContentInfoCo;
import com.eibus.co.DataSet;
import com.eibus.co.Tuple;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.co.dom.BusinessElementImpl;
import com.eibus.exception.BusException;
import com.eibus.exception.ProgrammingRException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.Registry;
import com.eibus.xml.util.DOMWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BusinessDocumentManager {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.bdf", "BusinessDocumentManager");
    protected BusDocFactory factory;
    long timeout;
    TupleStore memory;
    boolean metaData;
    private int m_transactionScope;
    private Vector m_warnings;
    private UserInfo m_userinfo;
    private UserSession m_userSession;
    private Connection m_connection;
    private boolean unconditional;
    private ContentInfoCo m_contentinfo;
    protected Hashtable IteratorFetchThreads;
    protected Hashtable interfacesToImplementations;
    protected Hashtable tagsToInterfaces;
    static /* synthetic */ Class class$com$eibus$co$BusinessElement;
    static /* synthetic */ Class class$com$baan$b3$boi1$BusinessObject;

    public void setContentInfo(ContentInfoCo contentInfoCo) {
        this.m_contentinfo = contentInfoCo;
        s_logger.message("Added ContentInfo (License) to Manager");
    }

    public ContentInfoCo getContentInfo() {
        return this.m_contentinfo;
    }

    public void setUserInfo(IUserInfo iUserInfo) throws BusException {
        if (this.m_connection != null) {
            throw new BusException("Manager already initialized, add userInfo to manager before initializing.");
        }
        this.m_userinfo = (UserInfo)iUserInfo;
    }

    public void setUnconditional(boolean bl) {
        this.unconditional = bl;
    }

    public void setTransactionScope(int n) {
        this.m_transactionScope = n;
    }

    int getTransactionScope() {
        return this.m_transactionScope;
    }

    public BusinessDocumentManager(String string, String string2) throws BusException {
        this.timeout = 60000L;
        this.metaData = false;
        this.m_transactionScope = 0;
        this.m_warnings = new Vector();
        this.m_userinfo = null;
        this.m_userSession = null;
        this.m_connection = null;
        this.unconditional = false;
        this.m_contentinfo = null;
        this.IteratorFetchThreads = new Hashtable();
        this.interfacesToImplementations = new Hashtable();
        this.tagsToInterfaces = new Hashtable();
        throw new BusException("This constructor is not implemented/'supported' anymore");
    }

    public BusinessDocumentManager() throws BusException {
        block4: {
            this.timeout = 60000L;
            this.metaData = false;
            this.m_transactionScope = 0;
            this.m_warnings = new Vector();
            this.m_userinfo = null;
            this.m_userSession = null;
            this.m_connection = null;
            this.unconditional = false;
            this.m_contentinfo = null;
            this.IteratorFetchThreads = new Hashtable();
            this.interfacesToImplementations = new Hashtable();
            this.tagsToInterfaces = new Hashtable();
            this.factory = new BusDocFactoryImpl();
            this.memory = new TupleStore();
            try {
                AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
                int n = adapterClientConfiguration.getTimeout();
                this.setTimeOut(n);
                String string = adapterClientConfiguration.getDefaultBackend();
                if (string == null || string.length() == 0) break block4;
                try {
                    this.initialize(string);
                }
                catch (BusException busException) {
                    throw new BusException("Error while initializing manager with default backend," + busException.getMessage());
                }
            }
            catch (OWConfigurationException oWConfigurationException) {
                s_logger.errorException(oWConfigurationException);
            }
        }
    }

    public void addToUserSession(UserSession userSession) throws BusException {
        if (this.m_connection != null) {
            throw new BusException("This Manager is initialized, close the Manager Before adding it to an UserSession.");
        }
        if (this.m_userSession != null) {
            throw new BusException("This Manager is already in control of an UserSession");
        }
        this.m_userSession = userSession;
    }

    public void initialize(String string) throws DirectoryException, BusException {
        if (this.m_connection != null) {
            this.close();
        }
        Connection connection = null;
        ConnectionFactory connectionFactory = ConnectionFactory.getInstance();
        if (connectionFactory.isBackendReference(string)) {
            connection = connectionFactory.giveConnectionFromBackendReference(string, this.m_userSession);
        } else {
            if (this.m_userSession == null && this.m_userinfo == null) {
                try {
                    this.m_userSession = (UserSession)BackendConnection.m_DefaultUserSessions.get(string);
                    if (this.m_userSession == null) {
                        Directory directory = new DirectoryServiceProvider().getDirectoryService();
                        BusComponent busComponent = directory.retrieveBusComponent(string);
                        UserSession userSession = busComponent.getDefaultUserSession();
                        if (userSession != null) {
                            s_logger.message("Creating Default UserSession (Configured in BusComponent)");
                            this.m_userSession = userSession;
                            BackendConnection.m_DefaultUserSessions.put(string, this.m_userSession);
                        }
                    } else {
                        s_logger.message("Re-use Default UserSession (Configured in BusComponent)");
                    }
                }
                catch (DirectoryException directoryException) {
                    throw new BusException(directoryException);
                }
                catch (Exception exception) {
                    s_logger.message("An error occured while creating UserSession:" + exception);
                }
            }
            connection = this.m_userSession != null ? connectionFactory.giveConnection(string, this.m_userSession) : connectionFactory.giveConnection(string, this.m_userinfo);
        }
        this.m_connection = connection;
    }

    public BusDoc sendAndWaitForAnswer(BusDoc busDoc) throws BusTimeOutException, BusException {
        try {
            LogEvent logEvent = LoggerFactory.getLogEvent(busDoc.getHeader().getCorrelationId());
            logEvent.storeMessage("Connection trough BusComponentID '" + this.m_connection.getServerComponentId() + "'");
            return this.m_connection.sendAndWaitForAnswer(busDoc, this.timeout);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BusException("Out of memory sending/receiving data");
        }
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public void ping() throws BusTimeOutException, BusException {
        if (this.m_connection == null) {
            throw new BusException("Manager is not initialized yet.");
        }
        this.m_connection.sendControlMessage("ping", "", this.timeout);
    }

    public String getCurrentBackend() {
        if (this.m_connection != null) {
            return this.m_connection.getServerComponentId();
        }
        return null;
    }

    public void update(BusinessElement businessElement, BusinessElement businessElement2) throws IllegalArgumentException, BoiProgrammingRException {
        Vector vector = new Vector();
        if (businessElement != null && businessElement.getManager() != this) {
            throw new ProgrammingRException("p_oldValue must be introduce()d to this manager");
        }
        if (businessElement2 != null && businessElement2.getManager() != this) {
            throw new ProgrammingRException("p_newValue must be introduce()d to this manager");
        }
        if (businessElement == null) {
            if (businessElement2 == null) {
                throw new ProgrammingRException("Trying to use changeBusinessObject function with null arguments");
            }
            businessElement2.createInsertionTuples(vector, this.factory);
        } else if (businessElement2 == null) {
            businessElement.createDeletionTuples(vector, this.factory);
        } else {
            boolean bl = businessElement instanceof IBusinessElementAdapter;
            boolean bl2 = businessElement2 instanceof IBusinessElementAdapter;
            Class clazz = null;
            Class clazz2 = null;
            String string = null;
            if (bl || bl2) {
                if (!bl || !bl2) {
                    throw new ProgrammingRException("p_oldValue and p_newValue are incompatible (boi1/legacy)");
                }
                clazz = ((IBusinessElementAdapter)((Object)businessElement)).getBusinessObjectClass();
                clazz2 = ((IBusinessElementAdapter)((Object)businessElement2)).getBusinessObjectClass();
                string = "boi1";
            } else {
                clazz = businessElement.getClass();
                clazz2 = businessElement2.getClass();
                string = "legacy";
            }
            if (!clazz.equals(clazz2)) {
                throw new ProgrammingRException("p_oldValue and p_newValue are incompatible (" + string + ")");
            }
            BusinessElementImpl.createUpdateTuples(vector, businessElement, businessElement2, this.factory);
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            Tuple tuple = (Tuple)enumeration2.nextElement();
            this.memory.insert(tuple);
        }
    }

    public void add(BusinessElement businessElement) {
        Tuple tuple = businessElement.getTuple();
        if (tuple != null) {
            if (this.memory.contains(tuple)) {
                s_logger.message("Trying to add element to memory of manager that is already present, ignored");
                return;
            }
        } else {
            tuple = this.factory.createTuple();
        }
        tuple.setOriginal(null);
        tuple.setCurrent(businessElement);
        this.memory.insert(tuple);
    }

    public void remove(BusinessElement businessElement) {
        Tuple tuple = businessElement.getTuple();
        if (tuple != null) {
            if (this.memory.contains(tuple)) {
                s_logger.message("remove: Trying to add element to memory of manager that is already present, ignored operation");
                return;
            }
        } else {
            tuple = this.factory.createTuple();
        }
        tuple.setCurrent(null);
        tuple.setOriginal(businessElement);
        this.memory.insert(tuple);
        ((BusinessElementImpl)businessElement).setChanged();
    }

    public void memorize(BusinessElement businessElement) {
        Tuple tuple = businessElement.getTuple();
        if (tuple != null) {
            if (this.memory.contains(tuple)) {
                s_logger.message("Memorize: trying to add element to memory of manager that is already present");
                return;
            }
        } else {
            tuple = this.factory.createTuple();
        }
        tuple.setOriginal((BusinessElement)businessElement.cloneNode(true));
        tuple.setCurrent(businessElement);
        this.memory.insert(tuple);
    }

    public void releaseAll() {
        this.memory = new TupleStore();
    }

    public void release(BusinessElement businessElement) {
        Tuple tuple = businessElement.getTuple();
        if (tuple != null) {
            if (this.memory.contains(tuple)) {
                this.memory.remove(tuple);
            }
            tuple.setCurrent(null);
            tuple.setOriginal(null);
        }
    }

    public BusinessElement create(Class clazz) throws BusException {
        Class clazz2;
        Class clazz3 = (Class)this.interfacesToImplementations.get(clazz);
        if (clazz3 == null) {
            throw new BusException("Cannot find implementation class for " + clazz);
        }
        Class clazz4 = clazz2 = class$com$eibus$co$BusinessElement == null ? (class$com$eibus$co$BusinessElement = BusinessDocumentManager.class$("com.eibus.co.BusinessElement")) : class$com$eibus$co$BusinessElement;
        if (clazz2.isAssignableFrom(clazz3)) {
            try {
                BusinessElement businessElement = (BusinessElement)clazz3.newInstance();
                businessElement.setManager(this);
                return businessElement;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BusException("Failed to instantiate " + clazz + ", due to: " + illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new BusException("Failed to instantiate " + clazz + ", due to: " + instantiationException);
            }
        }
        if ((class$com$baan$b3$boi1$BusinessObject == null ? (class$com$baan$b3$boi1$BusinessObject = BusinessDocumentManager.class$("com.baan.b3.boi1.BusinessObject")) : class$com$baan$b3$boi1$BusinessObject).isAssignableFrom(clazz3)) {
            try {
                BusinessObject businessObject = (BusinessObject)clazz3.newInstance();
                BusinessElement businessElement = BusinessDocumentHack.getElement(businessObject);
                businessElement.setManager(this);
                return businessElement;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BusException("Failed to instantiate " + clazz + ", due to: " + illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new BusException("Failed to instantiate " + clazz + ", due to: " + instantiationException);
            }
        }
        throw new BusException("Cannot find a valid implementation class for " + clazz + " (found class " + clazz3 + ")");
    }

    public BusinessElement createBusinessElement(String string) {
        BusinessElement businessElement;
        block4: {
            businessElement = null;
            try {
                Class clazz = (Class)this.tagsToInterfaces.get(string);
                if (clazz == null) {
                    s_logger.message("Try to map lower case tag name: " + string.toLowerCase());
                    clazz = (Class)this.tagsToInterfaces.get(string.toLowerCase());
                }
                if (clazz == null) {
                    s_logger.message("Using busdocfactory to create business element for name: " + string);
                    businessElement = this.factory.createBusinessElement(string);
                    businessElement.setManager(this);
                    break block4;
                }
                businessElement = this.create(clazz);
            }
            catch (BusException busException) {
                s_logger.errorException(busException);
            }
        }
        return businessElement;
    }

    public void synchronize() throws BusSynchronizationException, BusTimeOutException, BusException {
        this.m_warnings.removeAllElements();
        Synchronization synchronization = new Synchronization();
        synchronization.addManager(this);
        synchronization.setUnconditional(this.unconditional);
        synchronization.execute();
    }

    public DataSet retrieveData(Constructor constructor) throws BusApplicationException, BusTimeOutException, BusException {
        if (this.m_connection == null) {
            throw new BusException("Backend not specified");
        }
        this.m_warnings.removeAllElements();
        BusDoc busDoc = this.factory.createBusDoc();
        busDoc.addCO(constructor);
        busDoc.setContentInfo(this.m_contentinfo);
        Guid guid = busDoc.getHeader().generateNewCorrelationId();
        Registry.registerManager(guid, null, null, this);
        LogEvent logEvent = LoggerFactory.createLogEvent(guid);
        logEvent.storeMessage("BusinessDocumentManager.retrieveData(), Created Busdoc (" + constructor.getLanguage() + ")");
        BusDoc busDoc2 = this.sendAndWaitForAnswer(busDoc);
        logEvent.storeMessage("Retreived answer from backend");
        logEvent.storeXml(busDoc2);
        if (busDoc.getVersion() != busDoc2.getVersion()) {
            logEvent.storeMessage("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
            s_logger.errorEvent(logEvent);
            throw new BusException("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
        }
        s_logger.flowMessage("BusDoc Protocols are equal version = " + busDoc.getVersion());
        Registry.unRegisterManager(guid, null, null);
        ProtocolErrors.seekAndThrowManagerExceptions(busDoc2);
        LoggerFactory.removeLogEvent(logEvent);
        CommunicationObject communicationObject = busDoc2.getFirstCO();
        if (communicationObject != null) {
            if (communicationObject instanceof DataSet) {
                return (DataSet)busDoc2.getFirstCO();
            }
            throw new BusException("Received invalid answer: " + new DOMWriter(communicationObject).toString());
        }
        throw new BusException("Retrieved no answer");
    }

    public void registerManager() {
        s_logger.message("Now registering manager " + this + " in the Registry");
        Enumeration enumeration2 = this.tagsToInterfaces.keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            Registry.registerManager(null, null, string, this);
        }
    }

    public void setTimeOut(long l) {
        if (l >= 0L) {
            this.timeout = l;
        }
    }

    public long getTimeOut() {
        return this.timeout;
    }

    public void close() throws BusException {
        Object object;
        s_logger.flowMessage("called close for instance " + this.toString());
        Enumeration enumeration2 = this.IteratorFetchThreads.elements();
        while (enumeration2.hasMoreElements()) {
            object = (Iterator.FetchThread)enumeration2.nextElement();
            ((Iterator.FetchThread)object).stopAndClear();
        }
        object = ConnectionFactory.getInstance();
        ((ConnectionFactory)object).releaseConnection(this.m_connection);
        this.m_connection = null;
        this.m_transactionScope = 0;
        this.m_userinfo = null;
        this.m_userSession = null;
        this.m_warnings = new Vector();
        this.metaData = false;
    }

    void registerFetchThread(Thread thread) {
        this.IteratorFetchThreads.put(thread, thread);
    }

    void unregisterFetchThread(Thread thread) {
        this.IteratorFetchThreads.remove(thread);
    }

    public void registerName2Interface(String string, Class clazz) {
        s_logger.flowMessage("Registering " + clazz + " for tag " + string);
        this.tagsToInterfaces.put(string, clazz);
    }

    public Class getRegisteredInterface(String string) {
        return (Class)this.tagsToInterfaces.get(string);
    }

    public Class getRegisteredImplementation(Class clazz) {
        return (Class)this.interfacesToImplementations.get(clazz);
    }

    public void registerInterface2Implementation(Class clazz, Class clazz2) {
        s_logger.flowMessage("Registering implementation" + clazz2 + " for interface " + clazz);
        this.interfacesToImplementations.put(clazz, clazz2);
    }

    public BusDocFactory getFactory() {
        return this.factory;
    }

    public void enableMetaData(boolean bl) {
        this.metaData = bl;
    }

    public Enumeration getWarnings() {
        return this.m_warnings.elements();
    }

    public void addWarning(Object object) {
        this.m_warnings.addElement(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BusinessDocumentHack
    extends BusinessObject {
        private BusinessDocumentHack() {
        }

        public static BusinessElement getElement(BusinessObject businessObject) {
            return BusinessObject.getBusinessElement(businessObject);
        }
    }
}

