/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.bdf;

import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.ConnectionFactory;
import com.baan.ow.b3.database.DatabaseException;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LogEvent;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.ProtocolErrors;
import com.eibus.co.BusDoc;
import com.eibus.co.BusDocFactory;
import com.eibus.co.Constructor;
import com.eibus.co.DataSet;
import com.eibus.co.SQLError;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.exception.BusException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.services.guid.Guid;
import java.util.Hashtable;

public class BackendConnection {
    public static String CONTROLMESSAGE_CONNECTION_CREATE = "CreateConnection";
    public static String CONTROLMESSAGE_CONNECTION_RELEASE = "ReleaseConnection";
    private int m_timeout;
    private String m_defaultBackend;
    private UserSession m_userSession = null;
    private Connection m_connection = null;
    private String m_connectionID = null;
    static Hashtable m_DefaultUserSessions = new Hashtable();
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.bdf", "BackendConnection");
    private static ConnectionFactory s_connectionFactory = ConnectionFactory.getInstance();
    private BusDocFactory m_factory = null;

    private BackendConnection() throws BusException {
        s_logger.message("Creating BackendConnection");
        try {
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            this.m_timeout = adapterClientConfiguration.getTimeout();
            this.m_defaultBackend = adapterClientConfiguration.getDefaultBackend();
        }
        catch (OWConfigurationException oWConfigurationException) {
            s_logger.errorMessage("Error creating BackendConnection, " + oWConfigurationException.getMessage());
            throw new BusException(oWConfigurationException.getMessage());
        }
        this.m_factory = new BusDocFactoryImpl();
    }

    public BackendConnection(String string, UserSession userSession, String string2) throws BusException {
        this();
        Directory directory;
        if (string == null) {
            if (this.m_defaultBackend != null) {
                string = this.m_defaultBackend;
            } else {
                throw new BusException("No Buscomponent specified, also default backend not configured");
            }
        }
        if (userSession == null) {
            try {
                userSession = (UserSession)m_DefaultUserSessions.get(string);
                if (userSession == null) {
                    directory = new DirectoryServiceProvider().getDirectoryService();
                    BusComponent busComponent = directory.retrieveBusComponent(string);
                    userSession = busComponent.getDefaultUserSession();
                    if (userSession != null) {
                        s_logger.message("Using Default UserSession (Configured in BusComponent)");
                        m_DefaultUserSessions.put(string, userSession);
                    }
                } else {
                    s_logger.message("Re-use Default UserSession (Configured in BusComponent)");
                }
            }
            catch (DirectoryException directoryException) {
                throw new BusException(directoryException);
            }
            catch (Exception exception) {
                s_logger.message("An error occured while creating UserSession:" + exception);
            }
        }
        if (userSession != null) {
            this.m_connection = s_connectionFactory.giveConnection(string, userSession);
        } else if (s_connectionFactory.isBackendReference(string)) {
            this.m_connection = s_connectionFactory.giveConnectionFromBackendReference(string, userSession);
        } else {
            directory = null;
            this.m_connection = s_connectionFactory.giveConnection(string, (UserInfo)((Object)directory));
        }
        this.m_connectionID = this.m_connection.sendControlMessage(CONTROLMESSAGE_CONNECTION_CREATE, string2, this.m_timeout);
    }

    public void close() throws BusException {
        this.m_connection.sendControlMessage(CONTROLMESSAGE_CONNECTION_RELEASE, this.m_connectionID, this.m_timeout);
        s_connectionFactory.releaseConnection(this.m_connection);
        this.m_connection = null;
    }

    public DataSet sendAndWaitForAnswer(Constructor constructor) throws BusTimeOutException, BusException, DatabaseException {
        return this.sendAndWaitForAnswer(constructor, -1);
    }

    public DataSet sendAndWaitForAnswer(Constructor constructor, int n) throws BusTimeOutException, BusException, DatabaseException {
        BusDoc busDoc = this.m_factory.createBusDoc();
        busDoc.addCO(constructor);
        Guid guid = busDoc.getHeader().getCorrelationId();
        LogEvent logEvent = LoggerFactory.createLogEvent(guid);
        busDoc.getHeader().setProcessId(this.m_connectionID);
        try {
            int n2 = n > 0 ? n : this.m_timeout;
            BusDoc busDoc2 = this.m_connection.sendAndWaitForAnswer(busDoc, n2);
            if (busDoc.getVersion() != busDoc2.getVersion()) {
                logEvent.storeMessage("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
                s_logger.errorEvent(logEvent);
                logEvent = null;
                throw new BusException("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
            }
            s_logger.message("BusDoc Protocols are equal version = " + busDoc.getVersion());
            ProtocolErrors.seekAndThrowManagerExceptions(busDoc2);
            LoggerFactory.removeLogEvent(logEvent);
            DataSet dataSet = (DataSet)busDoc2.getFirstCO();
            SQLError sQLError = dataSet.getSQLError();
            if (sQLError != null) {
                throw new DatabaseException(sQLError.getMessage(), sQLError.getState(), sQLError.getErrorCode());
            }
            return (DataSet)busDoc2.getFirstCO();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BusException("Out of memory sending/receiving data");
        }
    }

    public int getTimeout() {
        return this.m_timeout;
    }
}

