/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.impl.DirectoryURL;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.eibus.services.runtime.BusProperties;

class PropertyListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "PropertyListenerImpl");
    private static final String LOG_PREFIX = "BaanERP property: ";
    private static final String POS_RESULT_TAG = "Ok";
    private static final String NEG_RESULT_TAG = "Failed";
    private static final String GET_PROPERTY = "getProperty";
    private static final String PROP_NOT_PRESENT = "Property not set";
    private static IBaanVM s_iBaanVm = null;
    private static final String GET_B3_JAVA_VERSION = "getB3JavaVersion";
    private static final String GET_DIRECTORY_URL = "getDirectoryUrl";
    private static final String GET_DIRECTORY_FILE = "getDirectoryFile";
    private static final String SET_DIRECTORY_URL = "setDirectoryUrl";
    private int m_toBVMQ;
    private int m_toJVMQ;
    private AdapterClientConfiguration m_configuration = null;

    PropertyListenerImpl(int n, int n2) {
        this.m_toBVMQ = n;
        this.m_toJVMQ = n2;
        if (s_iBaanVm == null) {
            try {
                s_iBaanVm = BucketUtils.getBaanVMInterface();
            }
            catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                s_logger.errorMessage("BaanERP property: Failed to locate IBaanVM interface");
                s_logger.errorException(baanVMNotInstalledException);
            }
        }
        try {
            this.m_configuration = AdapterClientContext.getCurrent();
        }
        catch (OWConfigurationException oWConfigurationException) {
            s_logger.errorException(oWConfigurationException);
        }
    }

    public void onReceive(IBucket iBucket) {
        if (iBucket == null) {
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("BaanERP property: Received bucket, but no header containing the function to be executed. Bucket will be ignored");
            return;
        }
        s_logger.message("BaanERP property: New bucket on queue " + this.m_toJVMQ + "; will try to invoke: " + string);
        if (string.equals(GET_PROPERTY)) {
            IBucket iBucket2;
            String string2 = iBucket.toString();
            String string3 = null;
            if (string2.equals(GET_DIRECTORY_URL)) {
                s_logger.message("BaanERP property: Getting Directory URL");
                string3 = DirectoryURL.get();
            } else if (string2.equals(GET_DIRECTORY_FILE)) {
                s_logger.message("BaanERP property: Getting Directory File");
                string3 = DirectoryURL.getConfigurationPath();
            } else {
                if (string2.startsWith(SET_DIRECTORY_URL)) {
                    String string4 = string2.substring(SET_DIRECTORY_URL.length());
                    s_logger.message("BaanERP property: Setting Directory URL with '" + string4 + "'");
                    try {
                        DirectoryURL.set(string4);
                        IBucket iBucket3 = s_iBaanVm.createBucket("OK", POS_RESULT_TAG);
                        this.sendReply(iBucket3);
                    }
                    catch (OWConfigurationException oWConfigurationException) {
                        s_logger.message("BaanERP property: Error Setting Directory; " + oWConfigurationException);
                        IBucket iBucket4 = s_iBaanVm.createBucket(oWConfigurationException.getMessage(), NEG_RESULT_TAG);
                        this.sendReply(iBucket4);
                    }
                    return;
                }
                if (this.m_configuration != null) {
                    if (string2.equals("bus.bdf.manager.timeout")) {
                        string3 = "" + this.m_configuration.getTimeout();
                    } else if (string2.equals("bus.default.backend")) {
                        string3 = this.m_configuration.getDefaultBackend();
                    } else if (string2.equals("bus.bdf.iterator.size")) {
                        string3 = "" + this.m_configuration.getIteratorSize();
                    } else {
                        s_logger.message("BaanERP property: Retrieving system property " + string2);
                        string3 = System.getProperties().getProperty(string2);
                    }
                } else {
                    s_logger.message("BaanERP property: No CCF AdapterClientConfiguration object found, using old BusProperties");
                    string3 = BusProperties.getProperty(string2);
                }
            }
            if (string3 == null) {
                s_logger.message("BaanERP property: Return error reply Property not set");
                iBucket2 = s_iBaanVm.createBucket(PROP_NOT_PRESENT, NEG_RESULT_TAG);
            } else {
                s_logger.message("BaanERP property: Return successfull reply '" + string3 + "'");
                iBucket2 = s_iBaanVm.createBucket(string3, POS_RESULT_TAG);
            }
            this.sendReply(iBucket2);
        } else if (string.equals(GET_B3_JAVA_VERSION)) {
            this.getB3JavaVersion(iBucket);
        } else {
            s_logger.message("BaanERP property: Ignoring received request to invoke unknown method: " + string);
        }
    }

    private void getB3JavaVersion(IBucket iBucket) {
        IBucket iBucket2;
        String string = iBucket.toString();
        s_logger.message("getB3JavaVersion, '" + string + "'");
        AdapterComponentInfo adapterComponentInfo = new AdapterComponentInfo();
        if (string.equalsIgnoreCase("B3JavaBuildInfo")) {
            String string2 = "(" + adapterComponentInfo.getBuildNumber() + ")-" + adapterComponentInfo.getBuildGuid();
            s_logger.message("BaanERP property: B3JavaBuildInfo, returning '" + string2 + "'");
            iBucket2 = BucketUtils.newMessage(string2);
        } else if (string.equalsIgnoreCase("B3JavaVersionInfo")) {
            String string3 = adapterComponentInfo.getVersion() + " " + adapterComponentInfo.getPatchLevel();
            s_logger.message("BaanERP property: B3JavaVersionInfo, returning '" + string3 + "'");
            iBucket2 = BucketUtils.newMessage(string3);
        } else if (string.equalsIgnoreCase("B3JavaBuildDate")) {
            String string4 = adapterComponentInfo.getBuildDateString();
            s_logger.message("BaanERP property: B3JavaBuildDate, returning '" + string4 + "'");
            iBucket2 = BucketUtils.newMessage(string4);
        } else if (string.equalsIgnoreCase("CCConfigSpec")) {
            s_logger.message("BaanERP property: CCConfigSpec, returning '" + adapterComponentInfo.getSourceControlConfiguration() + "'");
            iBucket2 = BucketUtils.newMessage(adapterComponentInfo.getSourceControlConfiguration());
        } else {
            s_logger.message("BaanERP property: getB3JavaVersion, returning error");
            iBucket2 = BucketUtils.newError("Error in retreiving version info, processing request '" + string + "'");
        }
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }

    private IBucket getErrorBucket(String string) {
        return s_iBaanVm.createBucket(string, NEG_RESULT_TAG);
    }

    private void sendReply(IBucket iBucket) {
        int n = s_iBaanVm.putBucket(this.m_toBVMQ, iBucket);
        if (n < 0) {
            Object[] objectArray = new Object[]{new Integer(n), new String(iBucket.getBucket())};
            s_logger.errorMessage("BaanERP property: Failed to put bucket " + objectArray.toString());
        }
    }
}

