/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BaanERPServerActivationListenerImpl;
import com.eibus.baanC.BucketUtils;
import com.eibus.baanC.ConnectionListenerImpl;
import com.eibus.baanC.DSListenerImpl;
import com.eibus.baanC.LicenseListenerImpl;
import com.eibus.baanC.LogListener;
import com.eibus.baanC.PropertyListenerImpl;

public class ListenerFactory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "ListenerFactory");

    public static void startLogListener(int n) {
        try {
            LogListener logListener = new LogListener(n);
            BucketUtils.getBaanVMInterface().installListener(n, logListener);
            s_logger.message("Installed Logging listener");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to install Logging listener: " + exception);
        }
    }

    public static void startDSListener(int n, int n2) {
        IBucket iBucket;
        try {
            DSListenerImpl dSListenerImpl = new DSListenerImpl(n2, n);
            BucketUtils.getBaanVMInterface().installListener(n, dSListenerImpl);
            s_logger.message("Installed Directory-Service listener");
            iBucket = BucketUtils.newMessage("Ok");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to install Directory-Service listener: " + exception);
            iBucket = BucketUtils.newError(exception.toString());
        }
        s_logger.message("Sending back message to bshell on queue nr '" + n2 + "'");
        BucketUtils.send(n2, iBucket);
    }

    public static void startPropListener(int n, int n2) {
        IBucket iBucket;
        try {
            PropertyListenerImpl propertyListenerImpl = new PropertyListenerImpl(n2, n);
            BucketUtils.getBaanVMInterface().installListener(n, propertyListenerImpl);
            s_logger.message("Installed Property listener");
            iBucket = BucketUtils.newMessage("Ok");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to install Property listener: " + exception);
            iBucket = BucketUtils.newError(exception.toString());
        }
        s_logger.message("Sending back message to bshell on queue nr '" + n2 + "'");
        BucketUtils.send(n2, iBucket);
    }

    public static void startLicenseListener(int n, int n2) {
        IBucket iBucket;
        try {
            LicenseListenerImpl licenseListenerImpl = new LicenseListenerImpl(n2, n);
            BucketUtils.getBaanVMInterface().installListener(n, licenseListenerImpl);
            s_logger.message("Installed License listener");
            iBucket = BucketUtils.newMessage("Ok");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to install License listener: " + exception);
            iBucket = BucketUtils.newError(exception.toString());
        }
        s_logger.message("Sending back message to bshell on queue nr '" + n2 + "'");
        BucketUtils.send(n2, iBucket);
    }

    public static void startConnectionListener(int n, int n2) {
        IBucket iBucket;
        try {
            ConnectionListenerImpl connectionListenerImpl = new ConnectionListenerImpl(n2, n);
            BucketUtils.getBaanVMInterface().installListener(n, connectionListenerImpl);
            s_logger.message("Installed Connection listener");
            iBucket = BucketUtils.newMessage("Ok");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to install Connection listener: " + exception);
            iBucket = BucketUtils.newError(exception.toString());
        }
        s_logger.message("Sending back message to bshell on queue nr '" + n2 + "'");
        BucketUtils.send(n2, iBucket);
    }

    public static void startBaanERPServerActivationListener(int n, int n2) {
        IBucket iBucket;
        try {
            BaanERPServerActivationListenerImpl baanERPServerActivationListenerImpl = BaanERPServerActivationListenerImpl.createBaanERPServerActivationListenerImpl(n2, n);
            BucketUtils.getBaanVMInterface().installListener(n, baanERPServerActivationListenerImpl);
            s_logger.message("Installed BaanERPServerActivation listener");
            iBucket = BucketUtils.newMessage("Ok");
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to install BaanERPServerActivation listener: " + exception);
            iBucket = BucketUtils.newError(exception.toString());
        }
        s_logger.message("Sending back message to bshell on queue nr '" + n2 + "'");
        BucketUtils.send(n2, iBucket);
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_BAANERP_ADAPTER);
    }
}

