/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.services.licensing.LicenseListener;
import java.util.Hashtable;

class LicenseListenerImpl
implements IQueueListener,
LicenseListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "LicenseListenerImpl");
    private static final String SET_EVENT_QUEUE = "SetEventQueue";
    private static final String CREATE_LICENSE_HEADER = "CreateLicense";
    private static final String CREATE_SERVER_LICENSE_HEADER = "CreateServerLicense";
    private static final String RELEASE_LICENSE_HEADER = "ReleaseLicense";
    private static final String GET_HOSTNAME_HEADER = "GetHostNameFromLicense";
    private static final String GET_DAYS_LEFT_HEADER = "GetDaysLeftFromLicense";
    private static final String GET_EXPIRATION_DATE_HEADER = "GetExpirationDateFromLicense";
    private static final String LICENSE_WARNING_HEADER = "LicenseEventWarning";
    private static final String LICENSE_EXPIRED_HEADER = "LicenseEventExpired";
    private static final String LICENSE_EXTENDED_HEADER = "LicenseEventExtended";
    private int m_toBVMQ;
    private int m_toJVMQ;
    private int m_eventQ;
    private Hashtable m_licenses = new Hashtable();
    private static int s_id = 0;

    LicenseListenerImpl(int n, int n2) {
        this.m_toBVMQ = n;
        this.m_toJVMQ = n2;
        this.m_eventQ = 0;
        s_logger.message("LicenseListenerImpl: Listener up and running, using ToBVMQ: " + this.m_toBVMQ + "and ToJVMQ: " + this.m_toJVMQ);
    }

    public void onReceive(IBucket iBucket) {
        if (iBucket == null) {
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("LicenseListnerImpl: Received bucket, but no header containing the function to be executed. Bucket will be ignored");
            return;
        }
        s_logger.message("LicenseListnerImpl: New bucket on queue " + this.m_toJVMQ + "; will try to invoke: '" + string + "'");
        String string2 = iBucket.toString();
        if (string.equals(SET_EVENT_QUEUE)) {
            this.setEventQueue(string2);
        } else if (string.equals(CREATE_LICENSE_HEADER)) {
            this.createLicense(string2);
        } else if (string.equals(CREATE_SERVER_LICENSE_HEADER)) {
            this.createLicense(string2);
        } else if (string.equals(RELEASE_LICENSE_HEADER)) {
            this.releaseServerLicense(string2);
        } else if (string.equals(GET_HOSTNAME_HEADER)) {
            this.getHostNameFromLicense(string2);
        } else if (string.equals(GET_DAYS_LEFT_HEADER)) {
            this.getDaysLeftFromLicense(string2);
        } else if (string.equals(GET_EXPIRATION_DATE_HEADER)) {
            this.getExpirationDateFromLicense(string2);
        } else {
            s_logger.message("Received request to invoke unknown method: " + string);
            IBucket iBucket2 = BucketUtils.newError("Received request to invoke unknown method: " + string);
            BucketUtils.send(this.m_toBVMQ, iBucket2);
        }
    }

    private void setEventQueue(String string) {
        s_logger.message("setEventQueue, '" + string + "'");
        this.m_eventQ = Integer.parseInt(string);
        IBucket iBucket = BucketUtils.newMessage("Ok");
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    private void createLicense(String string) {
        IBucket iBucket;
        s_logger.message("createLicense, '" + string + "'");
        int n = string.indexOf(";");
        int n2 = string.lastIndexOf(";");
        if (n > 0) {
            int n3 = Integer.parseInt(string.substring(0, n));
            String string2 = null;
            String string3 = null;
            if (n != n2) {
                string2 = string.substring(n + 1, n2);
                string3 = string.substring(n2 + 1);
            } else {
                string2 = string.substring(n + 1);
            }
            try {
                ILicense iLicense = null;
                iLicense = string3 == null ? LicenseFactory.createServerLicense(n3, string2) : LicenseFactory.createNamedUserLicense(n3, string2, string3);
                this.m_licenses.put(new Integer(++s_id), iLicense);
                iLicense.addLicenseListener(this);
                iBucket = BucketUtils.newMessage("" + s_id);
                s_logger.message("createServerLicense, Created server License with id " + s_id);
            }
            catch (LicenseException licenseException) {
                iBucket = BucketUtils.newError("LicenseException in createServerLicense, " + licenseException.toString());
                s_logger.message("createServerLicense, Failed to create ServerLicense. '" + licenseException.toString() + "'");
            }
        } else {
            s_logger.message("createServerLicense, returning error");
            iBucket = BucketUtils.newError("Error in createServerLicense, illegal parameter format '" + string + "'");
        }
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    private void releaseServerLicense(String string) {
        IBucket iBucket;
        s_logger.message("releaseServerLicense, '" + string + "'");
        Integer n = new Integer(string);
        ILicense iLicense = (ILicense)this.m_licenses.get(n);
        if (iLicense == null) {
            s_logger.message("Error, License with id, '" + n + "' not found.");
            iBucket = BucketUtils.newError("Unknown license with id " + n);
        } else {
            iLicense.removeLicenseListener(this);
            iLicense.release();
            this.m_licenses.remove(n);
            s_logger.message("releaseServerLicense, License with id, '" + n + "' released, returning 'Ok'");
            iBucket = BucketUtils.newMessage("Ok");
        }
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    private void getHostNameFromLicense(String string) {
        IBucket iBucket;
        s_logger.message("getHostNameFromLicense, '" + string + "'");
        Integer n = new Integer(string);
        ILicense iLicense = (ILicense)this.m_licenses.get(n);
        if (iLicense == null) {
            s_logger.message("Error, License with id, '" + n + "' not found.");
            iBucket = BucketUtils.newError("Unknown license with id " + n);
        } else {
            s_logger.message("getHostNameFromLicense, License with ID '" + n + "' found, returning '" + iLicense.getHostName() + "'");
            iBucket = BucketUtils.newMessage(iLicense.getHostName());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    private void getDaysLeftFromLicense(String string) {
        IBucket iBucket;
        s_logger.message("getDaysLeftFromLicense, '" + string + "'");
        Integer n = new Integer(string);
        ILicense iLicense = (ILicense)this.m_licenses.get(n);
        if (iLicense == null) {
            s_logger.message("Error, License with id, '" + n + "' not found.");
            iBucket = BucketUtils.newError("Unknown license with id " + n);
        } else {
            s_logger.message("getDaysLeftFromLicense, License with ID '" + n + "' found, returning '" + iLicense.getDaysLeft() + "'");
            iBucket = BucketUtils.newMessage("" + iLicense.getDaysLeft());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    private void getExpirationDateFromLicense(String string) {
        IBucket iBucket;
        s_logger.message("getExpirationDateFromLicense, '" + string + "'");
        Integer n = new Integer(string);
        ILicense iLicense = (ILicense)this.m_licenses.get(n);
        if (iLicense == null) {
            s_logger.message("Error, License with id, '" + n + "' not found.");
            iBucket = BucketUtils.newError("Unknown license with id " + n);
        } else {
            s_logger.message("getExpirationDateFromLicense, License with ID '" + n + "' found, returning '" + iLicense.getFormattedExpirationDate() + "'");
            iBucket = BucketUtils.newMessage(iLicense.getFormattedExpirationDate());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    public void licenseChanged(LicenseEvent licenseEvent) {
        if (this.m_eventQ != 0) {
            ILicense iLicense = licenseEvent.getLicense();
            String string = null;
            String string2 = null;
            int n = licenseEvent.getReason();
            switch (n) {
                case 1: 
                case 4: {
                    string = LICENSE_EXPIRED_HEADER;
                    string2 = iLicense.getUserName();
                    break;
                }
                case 2: {
                    string = LICENSE_EXTENDED_HEADER;
                    string2 = iLicense.getUserName();
                    break;
                }
                case 3: {
                    string = LICENSE_WARNING_HEADER;
                    string2 = iLicense.getUserName() + "::" + licenseEvent.getMessage();
                    break;
                }
                default: {
                    return;
                }
            }
            s_logger.message(string + ":" + string2);
            IBucket iBucket = BucketUtils.newBucket(string2, string);
            BucketUtils.send(this.m_eventQ, iBucket);
        }
    }
}

