/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.xml.util.DOMWriter;
import com.eibus.xml.util.NiceDOMWriter;

public class DSListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "DSListenerImpl");
    private static final String RETRIEVE_COMPONENT = "retrieveComponent";
    private static final String LIST_ALL_COMPONENTS = "listAllComponentIDs";
    private static final String LIST_ALL_CATEGORIES = "listAllCategories";
    private static final String LIST_COMPONENTS_BY_CATEGORY = "listComponentsByCategory";
    private int m_toBVMQ;
    private int m_toJVMQ;
    private static Directory s_directoryService = null;

    public static void createAnonymousComponent(int n, String string, String string2) {
        try {
            if (s_directoryService == null) {
                s_directoryService = new DirectoryServiceProvider().getDirectoryService();
            }
            BusComponent busComponent = s_directoryService.createAnonymousComponent(string, string2, "");
            String string3 = new DOMWriter(busComponent.toDOM()).toString();
            IBucket iBucket = BucketUtils.newMessage(string3);
            BucketUtils.send(n, iBucket);
        }
        catch (DirectoryException directoryException) {
            IBucket iBucket = BucketUtils.newError("Error: " + directoryException);
            BucketUtils.send(n, iBucket);
        }
    }

    DSListenerImpl(int n, int n2) throws DirectoryException {
        this.m_toBVMQ = n;
        this.m_toJVMQ = n2;
        if (s_directoryService == null) {
            s_directoryService = new DirectoryServiceProvider().getDirectoryService();
        }
    }

    public void onReceive(IBucket iBucket) {
        if (iBucket == null) {
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("Received bucket, but no header containing the function to be executed. Bucket will be ignored");
            return;
        }
        s_logger.message("New bucket on queue " + this.m_toJVMQ + "; will try to invoke: " + string);
        if (string.equals(RETRIEVE_COMPONENT)) {
            this.retrieveComponent(iBucket);
        } else if (string.equals(LIST_ALL_COMPONENTS)) {
            this.retrieveAllComponentIDs(iBucket);
        } else if (string.equals(LIST_ALL_CATEGORIES)) {
            this.listAllCategories(iBucket);
        } else if (string.equals(LIST_COMPONENTS_BY_CATEGORY)) {
            this.listComponentsByCategory(iBucket);
        } else {
            s_logger.message("Received request to invoke unknown method: " + string);
            IBucket iBucket2 = BucketUtils.newError("Received request to invoke unknown method: " + string);
            BucketUtils.send(this.m_toBVMQ, iBucket2);
            return;
        }
    }

    private void retrieveComponent(IBucket iBucket) {
        IBucket iBucket2;
        String string = iBucket.toString();
        try {
            BusComponent busComponent = s_directoryService.retrieveBusComponent(string);
            String string2 = new DOMWriter(busComponent.toDOM()).toString();
            iBucket2 = BucketUtils.newMessage(string2);
            s_logger.message(new NiceDOMWriter(busComponent.toDOM()).toString());
        }
        catch (DirectoryException directoryException) {
            iBucket2 = BucketUtils.newError(directoryException.toString());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }

    private void retrieveAllComponentIDs(IBucket iBucket) {
        IBucket iBucket2;
        try {
            String[] stringArray = s_directoryService.listAllBusComponents();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n] + "#");
                ++n;
            }
            String string = "#" + stringArray.length + "#" + stringBuffer.toString();
            iBucket2 = BucketUtils.newMessage(string);
            s_logger.message("Returning: " + string);
        }
        catch (DirectoryException directoryException) {
            iBucket2 = BucketUtils.newError(directoryException.toString());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }

    private void listComponentsByCategory(IBucket iBucket) {
        IBucket iBucket2;
        String string = iBucket.toString();
        s_logger.message("Category: " + string);
        try {
            String[] stringArray = s_directoryService.listBusComponentIdsWithCategory(string);
            s_logger.message("Retrieved " + stringArray.length + " component names");
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n] + "#");
                ++n;
            }
            String string2 = "#" + stringArray.length + "#" + stringBuffer.toString();
            iBucket2 = BucketUtils.newMessage(string2);
            s_logger.message("Returning: " + string2);
        }
        catch (DirectoryException directoryException) {
            iBucket2 = BucketUtils.newError(directoryException.toString());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }

    private void listAllCategories(IBucket iBucket) {
        IBucket iBucket2;
        try {
            String[] stringArray = s_directoryService.listAllBusComponentCategories();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n] + "#");
                ++n;
            }
            String string = "#" + stringArray.length + "#" + stringBuffer.toString();
            iBucket2 = BucketUtils.newMessage(string);
            s_logger.message("Returning: " + string);
        }
        catch (DirectoryException directoryException) {
            iBucket2 = BucketUtils.newError(directoryException.toString());
        }
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }
}

