/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.legacydirectory.DirectoryException;
import com.baan.b3.legacydirectory.DirectoryToolkit;
import com.baan.b3impl.boi1.UserInfo;
import com.baan.b3impl.boi1.UserSession;
import com.baan.b3impl.connection.Connection;
import com.baan.b3impl.connection.ConnectionFactory;
import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.eibus.bdf.BusApplicationException;
import com.eibus.bdf.BusSynchronizationException;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.bdf.ProtocolErrors;
import com.eibus.co.BusDoc;
import com.eibus.co.UserInfoCo;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.co.dom.ContentInfoCoImpl;
import com.eibus.exception.BusException;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.Registry;
import com.eibus.services.security.BlockEncryption;
import com.eibus.xml.util.DOMWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ConnectionListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "ConnectionListenerImpl");
    private static final String CREATECONNECTIONUI_HEADER = "CreateConnectionUserInfo";
    private static final String CREATECONNECTIONUS_HEADER = "CreateConnectionUserSession";
    private static final String CREATEUSERSESSION_HEADER = "CreateUserSession";
    private static final String REMOVEUSERSESSION_HEADER = "RemoveUserSession";
    private static final String CLOSECONNECTION_HEADER = "CloseConnection";
    private static final String SENDBUSDOC_HEADER = "SendBusDoc";
    private static final String PINGBACKEND_HEADER = "PingBackend";
    private static final String ENABABLELICENSEINFO_HEADER = "EnableLicenseInfoOnSession";
    private int m_toBVMQ;
    private int m_toJVMQ;
    private ConnectionFactory m_connectionFactory = ConnectionFactory.getInstance();
    private Hashtable m_Connections = new Hashtable();
    private Hashtable m_UserSessions = new Hashtable();
    private static int m_ConnectionCounter = 1;
    private static int m_UserSessionCounter = 1;
    private static final String CONSTRUCTOR_TYPE = "constructor";
    private static final String UPDATE_TYPE = "update";
    private static Hashtable DefaultUserSessions = new Hashtable();

    ConnectionListenerImpl(int n, int n2) {
        this.m_toBVMQ = n;
        this.m_toJVMQ = n2;
        s_logger.message("ConnectionListenerImpl: Listener up and running, using ToBVMQ: " + this.m_toBVMQ + "and ToJVMQ: " + this.m_toJVMQ);
    }

    public void onReceive(IBucket iBucket) {
        IBucket iBucket2 = null;
        if (iBucket == null) {
            s_logger.message("ConnectionListenerImpl: onReceive without parameters");
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("ConnectionListenerImpl: Received bucket, but no header containing the function to be executed. Bucket will be ignored");
            return;
        }
        s_logger.message("ConnectionListenerImpl: calling : '" + string + "', '" + iBucket.toString() + "'");
        if (string.equals(CREATECONNECTIONUI_HEADER)) {
            iBucket2 = this.CreateUIConnection(iBucket.toString());
        } else if (string.equals(CREATECONNECTIONUS_HEADER)) {
            iBucket2 = this.CreateUSConnection(iBucket.toString());
        } else if (string.equals(CLOSECONNECTION_HEADER)) {
            iBucket2 = this.CloseConnection(iBucket.toString());
        } else if (string.equals(SENDBUSDOC_HEADER)) {
            iBucket2 = this.SendBusDocSynchronous(iBucket.getBucket());
        } else if (string.equals(CREATEUSERSESSION_HEADER)) {
            iBucket2 = this.CreateUsersession(iBucket.toString());
        } else if (string.equals(REMOVEUSERSESSION_HEADER)) {
            iBucket2 = this.RemoveUserSession(iBucket.toString());
        } else if (string.equals(ENABABLELICENSEINFO_HEADER)) {
            iBucket2 = this.EnableLicenseInfoOnSession(iBucket.toString());
        } else if (string.equals(PINGBACKEND_HEADER)) {
            iBucket2 = this.PingBackend(iBucket.toString());
        } else {
            s_logger.message("ConnectionListenerImpl Error, Found unknown Header");
        }
        s_logger.message(this.getBucketLogDetails(iBucket2));
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }

    private String getBucketLogDetails(IBucket iBucket) {
        String string = iBucket.toString();
        int n = string.length();
        if (n > 256) {
            return new String("ConnectionListenerImpl: sending back on queue :'" + this.m_toBVMQ + "', (" + n + ")'" + string.substring(0, 255) + " . . .'");
        }
        return new String("ConnectionListenerImpl: sending back on queue :'" + this.m_toBVMQ + "', (" + n + ")'" + string + "'");
    }

    private IBucket RemoveUserSession(String string) {
        try {
            if (this.m_UserSessions.containsKey(string)) {
                s_logger.message("ConnectionListenerImpl: Removing UserSession with id '" + string + "'");
                this.m_UserSessions.remove(string);
            } else {
                s_logger.message("ConnectionListenerImpl: UserSession with id '" + string + "', not found");
            }
            return BucketUtils.newMessage("Removed");
        }
        catch (Exception exception) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: RemoveUserSession: " + exception.toString());
        }
    }

    private IBucket CreateUsersession(String string) {
        try {
            UserInfo userInfo = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            IUserSession iUserSession = null;
            if (string2.equals("203D7660BEB2406159D5A9B5DD9D86D9") && string3.equals("57DE14C9E523995AFD24AE835C977004")) {
                iUserSession = BoiToolkit.getDefaultToolkit().createUserSession();
                s_logger.message("ConnectionListenerImpl: UserSession created (Without UserInfo)");
            } else {
                IUserInfo iUserInfo = BoiToolkit.getDefaultToolkit().createUserInfo();
                userInfo = (UserInfo)iUserInfo;
                UserInfoCo userInfoCo = userInfo.getInternalObject();
                userInfoCo.setPassword(string3, true);
                userInfoCo.setUsername(string2, true);
                iUserSession = BoiToolkit.getDefaultToolkit().createUserSession(iUserInfo);
                s_logger.message("ConnectionListenerImpl: UserSession for user '" + userInfo.getUsername() + "' created");
            }
            this.m_UserSessions.put("" + m_UserSessionCounter, iUserSession);
            return BucketUtils.newMessage("" + (++m_UserSessionCounter - 1));
        }
        catch (Exception exception) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: CreateUsersession: " + exception.toString());
        }
    }

    private IBucket SendBusDocSynchronous(byte[] byArray) {
        try {
            BusDoc[] busDocArray;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = 0;
            while (n < byArray.length && byArray[n] != 59) {
                ++n;
            }
            string = new String(byArray, 0, n);
            int n2 = ++n;
            while (n < byArray.length && byArray[n] != 59) {
                ++n;
            }
            string2 = new String(byArray, n2, n - n2);
            n2 = ++n;
            while (n < byArray.length && byArray[n] != 59) {
                ++n;
            }
            string3 = new String(byArray, n2, n - n2);
            int n3 = byArray.length - ++n;
            byte[] byArray2 = new byte[n3];
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = byArray[n4 + n];
                ++n4;
            }
            int n5 = Integer.parseInt(string2);
            Connection connection = (Connection)this.m_Connections.get(string);
            Element element = XMLNode.FromByteArray2XmlElement(byArray2);
            if (element != null) {
                string4 = element.getNodeName();
            }
            BusDocFactoryImpl busDocFactoryImpl = new BusDocFactoryImpl();
            BusDoc busDoc = busDocFactoryImpl.createBusDoc();
            if (string3.length() != 0) {
                s_logger.message("ConnectionListenerImpl: Content Info (License) added to request ");
                busDoc.setContentInfo(new ContentInfoCoImpl(string3));
            }
            Guid guid = busDoc.getHeader().generateNewCorrelationId();
            busDoc.getDocumentElement().appendChild(element);
            BusinessDocumentManager businessDocumentManager = new BusinessDocumentManager();
            Registry.registerManager(guid, null, null, businessDocumentManager);
            BusDoc busDoc2 = connection.sendAndWaitForAnswer(busDoc, n5);
            Registry.unRegisterManager(guid, null, null);
            if (busDoc2.getVersion() != busDoc.getVersion()) {
                s_logger.message("ConnectionListenerImpl:  BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
                throw new BusException("BusDoc protocol versions are not equal. request ver.= " + busDoc.getVersion() + ", reply ver.= " + busDoc2.getVersion());
            }
            s_logger.message("ConnectionListenerImpl: BusDoc Protocols are equal version = " + busDoc.getVersion());
            if (string4 != null && string4.equals(CONSTRUCTOR_TYPE)) {
                ProtocolErrors.seekAndThrowManagerExceptions(busDoc2);
            }
            if (string4 != null && string4.equals(CONSTRUCTOR_TYPE)) {
                ProtocolErrors.seekAndThrowManagerExceptions(busDoc2);
            }
            if (string4 != null && string4.equals(UPDATE_TYPE)) {
                busDocArray = new BusDoc[]{busDoc2};
                ProtocolErrors.seekAndThrowSynchronizeExceptions(busDocArray);
            }
            busDocArray = busDoc2.getFirstCO();
            byte[] byArray3 = new DOMWriter((Node)busDocArray).getBytes();
            return BucketUtils.newMessage(byArray3);
        }
        catch (BusSynchronizationException busSynchronizationException) {
            String string = busSynchronizationException.toString().substring(busSynchronizationException.toString().indexOf("<"), busSynchronizationException.toString().length());
            return BucketUtils.newError("syn:" + string);
        }
        catch (BusApplicationException busApplicationException) {
            String string = busApplicationException.toString().substring(busApplicationException.toString().indexOf("<"), busApplicationException.toString().length());
            return BucketUtils.newError("app:" + string);
        }
        catch (BusException busException) {
            return BucketUtils.newError("bus:" + busException.getMessage());
        }
        catch (Exception exception) {
            return BucketUtils.newError(exception.toString());
        }
    }

    private IBucket CloseConnection(String string) {
        try {
            int n = Integer.parseInt(string);
            Connection connection = (Connection)this.m_Connections.get("" + n);
            if (connection != null) {
                this.m_connectionFactory.releaseConnection(connection);
                this.m_Connections.remove("" + n);
            } else {
                s_logger.message("ConnectionListenerImpl: CloseConnection, could not find connection with id : '" + string + "'");
            }
            return BucketUtils.newMessage("closed");
        }
        catch (BusException busException) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection With UserSession: " + busException.toString());
        }
        catch (Exception exception) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection With UserSession: " + exception.toString());
        }
    }

    private IBucket CreateUSConnection(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt(string2);
            Connection connection = null;
            if (this.m_connectionFactory.isBackendReference(string3)) {
                UserSession userSession = (UserSession)this.m_UserSessions.get("" + n);
                connection = this.m_connectionFactory.giveConnectionFromBackendReference(string3, userSession);
            } else {
                UserSession userSession = (UserSession)this.m_UserSessions.get("" + n);
                connection = this.m_connectionFactory.giveConnection(string3, userSession);
            }
            this.m_Connections.put("" + m_ConnectionCounter, connection);
            return BucketUtils.newMessage("" + (++m_ConnectionCounter - 1));
        }
        catch (BusException busException) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection With UserSession: " + busException.toString());
        }
        catch (Exception exception) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection With UserSession: " + exception.toString());
        }
    }

    private IBucket PingBackend(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt(string3);
            Connection connection = (Connection)this.m_Connections.get(string2);
            connection.sendControlMessage("ping", "", n);
            return BucketUtils.newMessage("OK");
        }
        catch (BusException busException) {
            return BucketUtils.newError("bus:" + busException.getMessage());
        }
        catch (Exception exception) {
            return BucketUtils.newError(exception.toString());
        }
    }

    private IBucket CreateUIConnection(String string) {
        try {
            Object object;
            UserInfo userInfo = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            String string4 = (String)stringTokenizer.nextElement();
            if (this.m_connectionFactory.isBackendReference(string4)) {
                Connection connection = this.m_connectionFactory.giveConnectionFromBackendReference(string4, null);
                this.m_Connections.put("" + m_ConnectionCounter, connection);
                return BucketUtils.newMessage("" + (++m_ConnectionCounter - 1));
            }
            if (!string2.equals("-")) {
                object = BoiToolkit.getDefaultToolkit().createUserInfo();
                userInfo = (UserInfo)object;
                UserInfoCo userInfoCo = userInfo.getInternalObject();
                userInfoCo.setPassword(string3, true);
                userInfoCo.setUsername(string2, true);
            } else {
                try {
                    Object object2;
                    object = (UserSession)DefaultUserSessions.get(string4);
                    if (object == null) {
                        object2 = DirectoryToolkit.getDefaultToolkit().getBusComponent(string4);
                        object = (UserSession)object2.getDefaultUserSession();
                        if (object != null) {
                            s_logger.message("Using Default UserSession (Configured in BusComponent)");
                            DefaultUserSessions.put(string4, object);
                        }
                    } else {
                        s_logger.message("Re-use Default UserSession (Configured in BusComponent)");
                    }
                    if (object != null) {
                        object2 = this.m_connectionFactory.giveConnection(string4, (UserSession)object);
                        this.m_Connections.put("" + m_ConnectionCounter, object2);
                        return BucketUtils.newMessage("" + (++m_ConnectionCounter - 1));
                    }
                }
                catch (DirectoryException directoryException) {
                    return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection : " + directoryException.toString());
                }
                catch (Exception exception) {
                    s_logger.errorMessage("An error occured while Activating backend");
                    s_logger.errorException(exception);
                    return BucketUtils.newError("Error: An error occured while Activating backend :" + exception);
                }
            }
            object = this.m_connectionFactory.giveConnection(string4, userInfo);
            this.m_Connections.put("" + m_ConnectionCounter, object);
            return BucketUtils.newMessage("" + (++m_ConnectionCounter - 1));
        }
        catch (BusException busException) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection With UserInfo: " + busException.toString());
        }
        catch (Exception exception) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: Create Connection With UserInfo: " + exception.toString());
        }
    }

    private IBucket EnableLicenseInfoOnSession(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            String string4 = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string4);
            UserSession userSession = (UserSession)this.m_UserSessions.get("" + n);
            string3 = BlockEncryption.DecryptToString(string3, "653FC735ACE60236B5C43d8A9C49A31959AB4639ADE73FBD2940429E9A4D5801");
            userSession.enableLicenseOverrideWithId(string3, n2);
        }
        catch (Exception exception) {
            return BucketUtils.newError("Error: ConnectionListenerImpl: cannot EnableLicenseInfoOnSession: " + exception.toString());
        }
        return BucketUtils.newMessage("Enabled");
    }
}

