/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.eibus.baanC.BusConnection;
import com.eibus.exception.BusException;
import com.eibus.xml.util.DOMWriter;
import java.util.Dictionary;
import java.util.Hashtable;

public class ConnectionFactory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "ConnectionFactory");
    private static Dictionary mBusConnections = new Hashtable();

    public static void startSyncConnection(int n, int n2, String string) {
        try {
            if (string == null) {
                s_logger.message("It's a null component name!");
                string = "45";
            }
            BusConnection busConnection = null;
            busConnection = (BusConnection)mBusConnections.get(string);
            if (busConnection == null) {
                busConnection = new BusConnection(string);
                mBusConnections.put(string, busConnection);
            }
            busConnection.registerSyncConnection(n, n2);
            String string2 = new DOMWriter(busConnection.getComponent().toDOM()).toString();
            IBucket iBucket = BucketUtils.newMessage(string2);
            BucketUtils.send(n2, iBucket);
        }
        catch (BusException busException) {
            s_logger.errorMessage("Failed to start sync connection");
            s_logger.errorException(busException);
            IBucket iBucket = BucketUtils.newError(busException.toString());
            s_logger.errorMessage("Sending <" + iBucket + "> on queue <" + n2 + ">");
            BucketUtils.send(n2, iBucket);
        }
        catch (Throwable throwable) {
            s_logger.errorException(throwable);
        }
    }

    public static void startAsyncConnection(int n, int n2, String string) {
        try {
            BusConnection busConnection = null;
            busConnection = (BusConnection)mBusConnections.get(string);
            if (busConnection == null) {
                busConnection = new BusConnection(string);
                mBusConnections.put(string, busConnection);
            }
            busConnection.registerAsyncConnection(n, n2);
            IBucket iBucket = BucketUtils.newMessage(new DOMWriter(busConnection.getComponent().toDOM()).toString());
            BucketUtils.send(n2, iBucket);
        }
        catch (BusException busException) {
            s_logger.errorMessage("Failed to start Async connection: " + busException);
            IBucket iBucket = BucketUtils.newError(busException.toString());
            BucketUtils.send(n2, iBucket);
        }
    }

    public static void stopSyncConnection(String string) {
        try {
            BusConnection busConnection = (BusConnection)mBusConnections.get(string);
            if (busConnection == null) {
                s_logger.message("Cannot find busconnection for component " + string);
                return;
            }
            if (busConnection.unRegisterSyncConnection()) {
                mBusConnections.remove(string);
            }
        }
        catch (BusException busException) {
            s_logger.errorException(busException);
        }
    }

    public static void stopAsyncConnection(String string) {
    }
}

