/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.eibus.baanC.BusDocUtils;
import com.eibus.connection.BusListener;
import com.eibus.connection.Message;
import com.eibus.exception.BusException;
import com.eibus.services.profiling.ITimer;

class BusListenerImpl
implements BusListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "BusListenerImpl");
    private String m_syncMessageID;
    private int m_toBVMSyncQ;
    private int m_toBVMAsyncQ;
    private int m_numSent;
    private static IBaanVM s_iBaanVm = null;
    private ITimer m_timer;
    private int m_state;
    private static final int INITIAL = 0;
    private static final int SYNC_ONLY = 1;
    private static final int ASYNC_ONLY = 2;
    private static final int SYNC_ASYNC = 3;
    private static final int SYNC_ID = 4;
    private static final int SYNC_ASYNC_ID = 5;

    public BusListenerImpl() {
        block2: {
            this.m_syncMessageID = null;
            this.m_toBVMSyncQ = 0;
            this.m_toBVMAsyncQ = 0;
            this.m_numSent = 0;
            this.m_timer = null;
            this.m_state = 0;
            if (s_iBaanVm != null) break block2;
            try {
                s_iBaanVm = BucketUtils.getBaanVMInterface();
            }
            catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                s_logger.message("BusListenerImpl: failed to locate IBaanVM interface!");
            }
        }
    }

    public synchronized void onReceive(Message message) {
        s_logger.message("About to process a new message from the bus");
        if (message.HasMessageDigest()) {
            s_logger.message("checking Message Digests ");
            if (!message.CheckMessageDigest()) {
                s_logger.message("Wrong Message Digest, message ignored !!");
                return;
            }
        }
        switch (this.m_state) {
            case 0: {
                s_logger.errorMessage("Programming Error: This should not be happening.");
                break;
            }
            case 1: {
                s_logger.errorMessage("Cannot process messages while in SYNC_ONLY Mode.");
                break;
            }
            case 2: 
            case 3: {
                s_logger.message("No ID, sending Async message to BVM");
                IBucket iBucket = s_iBaanVm.createBucket(message.getText(), "Ok");
                BucketUtils.send(this.m_toBVMAsyncQ, iBucket);
                break;
            }
            case 4: {
                IBucket iBucket = s_iBaanVm.createBucket(message.getText(), "Ok");
                String string = BusDocUtils.getMessageID(message);
                if (string.equals(this.m_syncMessageID)) {
                    s_logger.message("ID Matches! Sending Sync message to BVM");
                    BucketUtils.send(this.m_toBVMSyncQ, iBucket);
                    this.m_state = 1;
                    break;
                }
                s_logger.message("Received BusDoc with unexpected message ID: <" + string + ">. Expected ID: <" + this.m_syncMessageID + "> [state = SYNC_ID]");
                break;
            }
            case 5: {
                IBucket iBucket = s_iBaanVm.createBucket(message.getText(), "Ok");
                String string = BusDocUtils.getMessageID(message);
                if (string.equals(this.m_syncMessageID)) {
                    s_logger.message("IDs match! Using sync queue(" + this.m_toBVMSyncQ + ") to send Sync message to BVM");
                    BucketUtils.send(this.m_toBVMSyncQ, iBucket);
                    this.m_state = 3;
                    break;
                }
                s_logger.message("IDs do not match! Using async queue(" + this.m_toBVMAsyncQ + ") to send Async message to BVM");
                BucketUtils.send(this.m_toBVMAsyncQ, iBucket);
                break;
            }
            default: {
                s_logger.message("Unknown state (suppressed)");
            }
        }
    }

    public synchronized void setSyncQueue(int n) throws BusException {
        s_logger.message("About to set sync queue");
        switch (this.m_state) {
            case 0: {
                this.m_state = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.m_state = 3;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new BusException("Sync Queue waiting for reply, unable to switch queues");
            }
            case 5: {
                throw new BusException("Sync Queue waiting for reply, unable to switch queues");
            }
            default: {
                throw new BusException("Illegal state");
            }
        }
        this.m_toBVMSyncQ = n;
    }

    public synchronized void setAsyncQueue(int n) throws BusException {
        s_logger.message("About to set async queue");
        switch (this.m_state) {
            case 0: {
                this.m_state = 2;
                break;
            }
            case 1: {
                this.m_state = 3;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.m_state = 5;
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new BusException("Illegal state");
            }
        }
        this.m_toBVMAsyncQ = n;
    }

    public synchronized void syncWaitingForID(String string) throws BusException {
        s_logger.message("Trying to sync on " + string);
        switch (this.m_state) {
            case 0: {
                throw new BusException("Illegal state (" + this.m_state + ")");
            }
            case 1: {
                this.m_state = 4;
                break;
            }
            case 2: {
                throw new BusException("Cannot set an ID without a synchronous queue set");
            }
            case 3: {
                this.m_state = 5;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new BusException("Illegal state");
            }
        }
        this.m_syncMessageID = string;
    }

    public synchronized void cancelWaitingForID() throws BusException {
        s_logger.message("Cancelling current ID");
        switch (this.m_state) {
            case 0: {
                break;
            }
            case 1: {
                this.m_state = 4;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.m_state = 1;
                break;
            }
            case 5: {
                this.m_state = 3;
                break;
            }
            default: {
                throw new BusException("Illegal state");
            }
        }
        this.m_syncMessageID = null;
    }

    public void setITimer(ITimer iTimer) {
        this.m_timer = iTimer;
    }

    public ITimer getITimer() {
        return this.m_timer;
    }
}

