/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.b3.xml.sax.InputSource;
import com.baan.b3.xml.sax.Parser;
import com.baan.b3.xml.sax.SAXException;
import com.baan.b3.xml.sax.helpers.ParserFactory;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.MessageIdFound;
import com.eibus.baanC.SAXEventHandler;
import com.eibus.connection.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class BusDocUtils {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "BusDocUtils");
    private static Parser mSaxEventGenerator = null;
    private static SAXEventHandler mSaxEventHandler = null;
    private static ParserFactory mSaxManager = null;
    private static boolean mReset = true;

    public static String getMessageID(Message message) {
        try {
            if (mReset) {
                BusDocUtils.resetParser();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(message.getText());
            InputSource inputSource = new InputSource(byteArrayInputStream);
            mSaxEventGenerator.parse(inputSource);
        }
        catch (MessageIdFound messageIdFound) {
            return messageIdFound.getMessageId();
        }
        catch (SAXException sAXException) {
            s_logger.errorMessage("Failed to parse xml upon parsing message");
            s_logger.errorException(sAXException);
            mReset = true;
        }
        catch (IOException iOException) {
            s_logger.errorMessage("Failed on I/O upon parsing message");
            s_logger.errorException(iOException);
            mReset = true;
        }
        catch (Exception exception) {
            s_logger.errorMessage("Failed to do something with message");
            s_logger.errorException(exception);
            mReset = true;
        }
        return "";
    }

    private static void resetParser() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        mSaxEventGenerator = mSaxManager.makeParser();
        mSaxEventHandler = new SAXEventHandler();
        mSaxEventGenerator.setDocumentHandler(mSaxEventHandler);
        mReset = false;
    }
}

