/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BVMListenerImpl;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.eibus.baanC.BusListenerImpl;
import com.eibus.baanC.ConnectionFactory;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.xml.util.DOMWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class BusConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "BusConnection");
    private static final boolean PRINT_DEBUG_INFO = false;
    private static Dictionary s_middlewareConnections = new Hashtable();
    private static Directory s_directory;
    private static boolean s_initialized;
    private static IBaanVM s_iBaanVm;
    private Directory m_directory = new DirectoryServiceProvider().getDirectoryService();
    private String m_componentName = null;
    private BusComponent m_component = null;
    private BusListenerImpl m_busListener = null;
    private Middleware m_middleware = null;
    private BVMListenerImpl m_syncListener = null;
    private BVMListenerImpl m_asyncListener = null;

    public static void initialize() throws DirectoryException {
        if (!s_initialized) {
            s_directory = new DirectoryServiceProvider().getDirectoryService();
            if (s_iBaanVm == null) {
                try {
                    s_iBaanVm = BucketUtils.getBaanVMInterface();
                }
                catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                    s_logger.errorMessage("BusConnection.initialize: Failed to locate IBaanVM interface, check BaanERP installation!");
                    s_logger.errorException(baanVMNotInstalledException);
                    throw new DirectoryException(baanVMNotInstalledException.getMessage());
                }
            }
            s_initialized = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initialize4GLLocationService(String string, int n) {
        try {
            BusConnection.initialize();
            Enumeration enumeration2 = s_directory.findAllBusComponents(2000);
            if (enumeration2 == null) {
                IBucket iBucket = s_iBaanVm.createBucket("No objects present in Directory Service ", "failed");
                if (s_iBaanVm.putBucket(n, iBucket) >= 0) return;
                Object[] objectArray = new Object[]{iBucket};
                s_logger.errorMessage("Failed to put bucket. " + objectArray.toString());
                return;
            }
            while (true) {
                String string2;
                Object object;
                if (!enumeration2.hasMoreElements()) {
                    return;
                }
                BusComponent busComponent = (BusComponent)enumeration2.nextElement();
                Enumeration enumeration3 = null;
                try {
                    enumeration3 = busComponent.getCategories();
                }
                catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                    // empty catch block
                }
                if (string != null && !string.equals("")) {
                    boolean bl = false;
                    if (enumeration3 != null) {
                        while (enumeration3.hasMoreElements()) {
                            object = (String)enumeration3.nextElement();
                            if (!((String)object).equalsIgnoreCase(string)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                }
                if (s_iBaanVm.putBucket(n, (IBucket)(object = s_iBaanVm.createBucket(string2 = new String(new DOMWriter(busComponent.toDOM()).toString()), "add"))) < 0) break;
            }
            s_logger.errorMessage("Failed to put bucket - identification bucket");
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.toString()};
            s_logger.errorMessage("Failed to initialize directory ");
            s_logger.errorException(exception);
            IBucket iBucket = s_iBaanVm.createBucket("" + exception, "failed");
            if (s_iBaanVm.putBucket(n, iBucket) >= 0) return;
            s_logger.errorMessage("Failed to post exception-bucket");
            return;
        }
    }

    public static void startConnection(int n, int n2, String string, String string2) {
        s_logger.message("Using deprecated method: BusConnection.startConnection(int,int,String,String)");
        ConnectionFactory.startAsyncConnection(n, n2, string);
    }

    public static void stopConnection(String string, int n) {
        block4: {
            try {
                BusConnection.initialize();
                BusComponent busComponent = s_directory.retrieveBusComponent(string);
                Middleware middleware = (Middleware)s_middlewareConnections.remove(string);
                if (middleware != null) {
                    middleware.close();
                    s_middlewareConnections.remove(busComponent);
                    IBucket iBucket = s_iBaanVm.createBucket("Stopped connections for " + string, "stop");
                    if (s_iBaanVm.putBucket(n, iBucket) < 0) {
                        s_logger.message("Failed to put 'stop' bucket on queue " + n);
                    }
                    s_logger.message("Stopped connection for " + busComponent.getIdentifier());
                    break block4;
                }
                s_logger.message("Connection for component " + string + " cannot be found");
            }
            catch (BusException busException) {
                s_logger.errorMessage("Failed to close connection for " + string);
                s_logger.errorException(busException);
            }
        }
    }

    public BusConnection(String string) throws DirectoryException {
        this.m_componentName = string;
        try {
            this.m_component = this.m_directory.retrieveBusComponent(this.m_componentName);
            String string2 = new DOMWriter(this.m_component.toDOM()).toString();
            this.m_component = new BusComponent(string2);
            this.m_componentName = this.m_component.getIdentifier();
        }
        catch (DirectoryException directoryException) {
            String string3 = System.getProperty("user.name");
            this.m_component = this.m_directory.createAnonymousComponent(this.m_componentName, string3, "");
            this.m_componentName = this.m_component.getIdentifier();
        }
        this.m_component.isClientComponent(true);
        s_logger.message("Marked as client buscomponent: " + this.m_component.getIdentifier());
        if (s_iBaanVm == null) {
            try {
                s_iBaanVm = BucketUtils.getBaanVMInterface();
            }
            catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                s_logger.errorMessage("BusConnection.initialize: Failed to locate IBaanVM interface, check BaanERP installation!");
                s_logger.errorException(baanVMNotInstalledException);
                throw new DirectoryException(baanVMNotInstalledException.getMessage());
            }
        }
    }

    public void registerSyncConnection(int n, int n2) throws BusException {
        if (this.m_syncListener != null) {
            s_logger.message("Synchronous Connection for " + this.m_componentName + " already exists");
            throw new BusException("Synchronous connection already exists");
        }
        if (this.m_busListener == null) {
            this.m_busListener = new BusListenerImpl();
        }
        this.m_busListener.setSyncQueue(n2);
        if (this.m_middleware == null) {
            this.m_middleware = new Middleware(this.m_component, this.m_busListener);
        }
        this.m_syncListener = new BVMListenerImpl(n, true, this.m_busListener, this.m_middleware, this.m_component, this.m_directory);
        try {
            s_iBaanVm.installListener(n, this.m_syncListener);
        }
        catch (Exception exception) {
            throw new BusException(exception.getMessage());
        }
    }

    public void registerAsyncConnection(int n, int n2) throws BusException {
        if (this.m_asyncListener != null) {
            s_logger.message("Asynchronous Connection for " + this.m_componentName + " already exists");
            throw new BusException("Asynchronous connection already exists");
        }
        if (this.m_busListener == null) {
            this.m_busListener = new BusListenerImpl();
        }
        this.m_busListener.setAsyncQueue(n2);
        if (this.m_middleware == null) {
            this.m_middleware = new Middleware(this.m_component, this.m_busListener);
        }
        this.m_asyncListener = new BVMListenerImpl(n, false, this.m_busListener, this.m_middleware, this.m_component, this.m_directory);
        try {
            s_iBaanVm.installListener(n, this.m_asyncListener);
        }
        catch (Exception exception) {
            throw new BusException(exception.getMessage());
        }
    }

    public boolean unRegisterSyncConnection() throws BusException {
        if (this.m_syncListener == null) {
            throw new BusException("Sync Connection not registered");
        }
        this.m_syncListener = null;
        if (this.m_asyncListener == null) {
            this.shutdown();
            return true;
        }
        return false;
    }

    public boolean unRegisterAsyncConnection() throws BusException {
        if (this.m_asyncListener == null) {
            throw new BusException("Async Connection not registered");
        }
        this.m_asyncListener = null;
        if (this.m_syncListener == null) {
            this.shutdown();
            return true;
        }
        return false;
    }

    private void shutdown() throws BusException {
        this.m_middleware.close();
        this.m_middleware = null;
        this.m_busListener = null;
        this.m_component = null;
        this.m_componentName = null;
        this.m_directory = null;
    }

    public BusComponent getComponent() {
        return this.m_component;
    }

    static {
        s_initialized = false;
        s_iBaanVm = null;
    }
}

