/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BaanVMNotInstalledException;

public class BucketUtils {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "BucketUtils");
    static final String POS_RESULT_TAG = "Ok";
    static final String NEG_RESULT_TAG = "Failed";
    private static IBaanVM s_iBaanVm = null;
    private static boolean s_initialized = false;

    public static IBaanVM getBaanVMInterface() throws BaanVMNotInstalledException {
        if (s_iBaanVm != null) {
            return s_iBaanVm;
        }
        try {
            s_iBaanVm = (IBaanVM)Class.forName("com.baan.baanvm.BaanVMImpl").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            s_logger.errorMessage("ClassNotFoundException: Unable to locate IBaanVM interface implementation. Make sure JVMI for BaanERP is installed!");
            throw new BaanVMNotInstalledException("Unable to locate IBaanVM interface (class not found). Make sure JVMI for BaanERP is installed!");
        }
        catch (IllegalAccessException illegalAccessException) {
            s_logger.errorMessage("IllegalAccessException: Unable to locate IBaanVM interface implementation. Make sure JVMI for BaanERP is installed!");
            throw new BaanVMNotInstalledException("Unable to locate IBaanVM interface (illegal access). Make sure JVMI for BaanERP is installed!");
        }
        catch (InstantiationException instantiationException) {
            s_logger.errorMessage("InstantiationException: Instantiation of IBaanVM interface failed. Make sure JVMI for BaanERP is installed!");
            throw new BaanVMNotInstalledException("Unable to instantiate IBaanVM interface. Make sure JVMI for BaanERP is installed!");
        }
        return s_iBaanVm;
    }

    public static synchronized void initialize() {
        if (!s_initialized || s_iBaanVm == null) {
            try {
                s_iBaanVm = BucketUtils.getBaanVMInterface();
            }
            catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                s_logger.errorMessage("BucketUtils.initialize: Failed to initialize IBaanVM: ignoring at this stage...");
            }
            s_initialized = true;
        }
    }

    public static IBucket newBucket(String string, String string2) {
        BucketUtils.initialize();
        return s_iBaanVm.createBucket(string, string2);
    }

    public static IBucket newMessage(String string) {
        BucketUtils.initialize();
        return s_iBaanVm.createBucket(string, POS_RESULT_TAG);
    }

    public static IBucket newMessage(byte[] byArray) {
        BucketUtils.initialize();
        return s_iBaanVm.createBucket(byArray, POS_RESULT_TAG);
    }

    public static IBucket newError(String string) {
        BucketUtils.initialize();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return s_iBaanVm.createBucket(string2, NEG_RESULT_TAG);
    }

    public static void send(int n, IBucket iBucket) {
        BucketUtils.initialize();
        int n2 = s_iBaanVm.putBucket(n, iBucket);
        if (n2 < 0) {
            Object[] objectArray = new Object[]{new Integer(n2), iBucket.getBucket()};
            s_logger.errorMessage("Failed to put bucket:" + objectArray.toString());
        }
    }
}

