/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.b3.server.ServerActivationCallBack;
import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.eibus.services.activation.ActivationCallBackInproc;
import com.eibus.services.directory.BusComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class BaanERPServerActivationListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "BaanERPServerActivationListenerImpl");
    private static final String START_CORBA_GATEWAY_HEADER = "startCorbaGateway";
    private static final String START_OWREGRESSION_TEST_HEADER = "startOWRegressionTest";
    private static final String SET_SERVERACTIVATION_QUEUES_HEADER = "setOWServerActivationQueues";
    private static final String CORBAGATEWAY_STOP_MESSAGE = "stop";
    private static final String START_OPENWORLD_SERVER_MESSAGE = "startOWServer";
    private static final String START_BAANERPBACKEND_HEADER = "startBaanERPBackend";
    private static final String SET_SERVER_REFERENCE_HEADER = "setStartedBackendReference";
    private SynchronizeMessages m_SynchronizeObject = null;
    private int m_toBVMQ = 0;
    private int m_toJVMQ = 0;
    private int m_toBVMQ_activateOWServer = 0;
    private int m_toJVMQ_activateOWServer = 0;
    private static IBaanVM s_iBaanVm = null;
    private static BaanERPServerActivationListenerImpl m_instance = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static BaanERPServerActivationListenerImpl createBaanERPServerActivationListenerImpl(int n, int n2) {
        if (m_instance == null) {
            m_instance = new BaanERPServerActivationListenerImpl(n, n2);
        }
        return m_instance;
    }

    public static BaanERPServerActivationListenerImpl getBaanERPServerActivationListenerImpl() {
        return m_instance;
    }

    public static void stopActivationprocess() {
        m_instance.stop3GLCorbaGateway();
    }

    public static void startBaanERPBackend(String string) {
        s_logger.message("ERPActivation: startBaanERPBackend request from baan");
        m_instance.startBaanERPBackend1(string);
    }

    public void startBaanERPBackend1(String string) {
        s_logger.message("ERPActivation: Starting BaanERPServer with programatic Activation");
        if (s_iBaanVm == null || this.m_toBVMQ_activateOWServer == 0) {
            s_logger.message("startOpenWorldServer: No Connection to inproc BaanERP Server present");
        }
        s_logger.message("startOpenWorldServer: Sending request for OWserver to 3GL, buscomponent to start = '" + string + "'");
        IBucket iBucket = BucketUtils.newMessage("startOWServer;" + string);
        BucketUtils.send(this.m_toBVMQ_activateOWServer, iBucket);
        String string2 = this.m_SynchronizeObject.getReplyMessage();
        s_logger.message("Reply from started server: '" + string2 + "'");
        string2 = string2.endsWith("</BusComponent>") ? BusComponent.toBackendReference(string2) : "error, " + string2;
        s_logger.message("startOpenWorldServer: Reply on request for OWserver to 3GL, '" + string2 + "'");
        IBucket iBucket2 = BucketUtils.newMessage("setStartedBackendReference;" + string2);
        BucketUtils.send(this.m_toBVMQ_activateOWServer, iBucket2);
    }

    private BaanERPServerActivationListenerImpl(int n, int n2) {
        this.m_toBVMQ = n;
        this.m_toJVMQ = n2;
        try {
            s_iBaanVm = BucketUtils.getBaanVMInterface();
        }
        catch (BaanVMNotInstalledException baanVMNotInstalledException) {
            s_logger.errorMessage("Error Cannot get interface to BaanVM");
            s_logger.errorException(baanVMNotInstalledException);
        }
        s_logger.message("BaanERPServerActivationListenerImpl: Listener up and running, using ToBVMQ: " + this.m_toBVMQ + "and ToJVMQ: " + this.m_toJVMQ);
    }

    public void onReceive(IBucket iBucket) {
        block8: {
            String string = "";
            try {
                if (iBucket == null) {
                    return;
                }
                string = iBucket.getHeader();
                if (string == null) {
                    s_logger.message("BaanERPServerActivationListenerImpl: Received bucket, but no header containing the function to be executed. Bucket will be ignored");
                    return;
                }
                s_logger.message("BaanERPServerActivationListenerImpl: New bucket on queue " + this.m_toJVMQ + "; will try to invoke: '" + string + "'");
                String string2 = iBucket.toString();
                if (string.equals(START_OWREGRESSION_TEST_HEADER)) {
                    this.startOpenWorldRegressionTest(string2);
                    break block8;
                }
                if (string.equals(START_CORBA_GATEWAY_HEADER)) {
                    this.startCorbaGateway(string2);
                    break block8;
                }
                if (string.equals(SET_SERVERACTIVATION_QUEUES_HEADER)) {
                    this.setOWServerActivationQueues(string2);
                    break block8;
                }
                if (string.equals(START_BAANERPBACKEND_HEADER)) {
                    BaanERPServerActivationListenerImpl.startBaanERPBackend(string2.toString());
                    break block8;
                }
                s_logger.message("BaanERPServerActivationListenerImpl: Received request to invoke unknown method: " + string);
                IBucket iBucket2 = BucketUtils.newMessage("JAVA: Received request to invoke unknown method: " + string);
                BucketUtils.send(this.m_toBVMQ, iBucket2);
            }
            catch (Exception exception) {
                IBucket iBucket3 = BucketUtils.newMessage("JAVA: Unexpected exception, " + string);
                BucketUtils.send(this.m_toBVMQ, iBucket3);
                s_logger.errorMessage("BaanERPServerActivationListenerImpl: Unexpected exception occured :" + exception);
            }
        }
    }

    private void startOpenWorldRegressionTest(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = (String)stringTokenizer.nextElement();
        String string3 = (String)stringTokenizer.nextElement();
        int n = Integer.parseInt(string3);
        s_logger.message("startOpenWorldRegressionTest, bc='" + string2 + "', nrThreads='" + n + "'");
        IBucket iBucket = BucketUtils.newMessage("JAVA: startOpenWorldRegressionTest, OK");
        BucketUtils.send(this.m_toBVMQ, iBucket);
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
            Class<?> clazz = Class.forName("com.eibus.test.regression.B3testInproc");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BaanERPServerActivationListenerImpl.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{new String(string2), new Integer(n)};
            Object obj = constructor.newInstance(objectArray);
            Method method = clazz.getMethod("run", null);
            method.invoke(obj, null);
        }
        catch (Exception exception) {
            s_logger.errorMessage("startOpenWorldRegressionTest: " + exception.toString());
        }
    }

    private void startCorbaGateway(String string) {
        String[] stringArray = new String[1];
        s_logger.message("startCorbaGateway, '" + string + "'");
        IBucket iBucket = BucketUtils.newMessage("JAVA: startCorbaGateway, OK");
        BucketUtils.send(this.m_toBVMQ, iBucket);
        try {
            s_logger.message("Loading InboundCorbaServer()");
            Class<?> clazz = Class.forName("com.baan.owimpl.b3.corbaconnector.InboundCorbaServer");
            Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = BaanERPServerActivationListenerImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[1];
            stringArray[0] = string;
            objectArray[0] = stringArray;
            s_logger.message("Making InboundCorbaServer Constructor");
            Object obj = constructor.newInstance(objectArray);
            s_logger.message("Invoking InboundCorbaServer run()");
            Method method = clazz.getMethod("run", null);
            method.invoke(obj, null);
        }
        catch (Exception exception) {
            s_logger.errorMessage("Error in  startCorbaGateway: Could not start InboundCorbaServer" + exception.toString());
        }
    }

    public void stop3GLCorbaGateway() {
        s_logger.message("send stop message to 3GL Server Activation Process on queue '" + this.m_toBVMQ_activateOWServer + "'");
        BucketUtils.send(this.m_toBVMQ_activateOWServer, BucketUtils.newMessage(CORBAGATEWAY_STOP_MESSAGE));
        s_logger.message("Re-initialize all members of this class");
        s_iBaanVm = null;
        m_instance = null;
        this.m_toBVMQ = 0;
        this.m_toJVMQ = 0;
        this.m_toBVMQ_activateOWServer = 0;
        this.m_toJVMQ_activateOWServer = 0;
    }

    private void setOWServerActivationQueues(String string) {
        IBucket iBucket;
        s_logger.message("setOWServerActivationQueues, '" + string + "'");
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            this.m_toBVMQ_activateOWServer = Integer.parseInt(string2);
            this.m_toJVMQ_activateOWServer = Integer.parseInt(string3);
            this.m_SynchronizeObject = new SynchronizeMessages();
            s_iBaanVm.installListener(this.m_toJVMQ_activateOWServer, this.m_SynchronizeObject);
            s_logger.message("setOWServerActivationQueues, toBVM'" + this.m_toBVMQ_activateOWServer + "', toJVM'" + this.m_toJVMQ_activateOWServer + "'");
            iBucket = BucketUtils.newMessage("JAVA: setOWServerActivationQueues, OK");
        }
        catch (Exception exception) {
            iBucket = BucketUtils.newError("JAVA: setOWServerActivationQueues, error");
        }
        BucketUtils.send(this.m_toBVMQ, iBucket);
    }

    public synchronized void startOpenWorldServer(String string, ServerActivationCallBack serverActivationCallBack) {
        if (s_iBaanVm == null || this.m_toBVMQ_activateOWServer == 0) {
            s_logger.message("startOpenWorldServer: No Connection to inproc BaanERP Server present");
            serverActivationCallBack.setActivationError("No inproc connection to BaanERP Server present");
        }
        s_logger.message("startOpenWorldServer: Sending request for OWserver to 3GL, buscomponent to start = '" + string + "'");
        IBucket iBucket = BucketUtils.newMessage("startOWServer;" + string);
        BucketUtils.send(this.m_toBVMQ_activateOWServer, iBucket);
        String string2 = this.m_SynchronizeObject.getReplyMessage();
        BusComponent busComponent = new BusComponent(string2);
        ((ActivationCallBackInproc)serverActivationCallBack).setBusComponent(busComponent);
        s_logger.message("startOpenWorldServer: Reply on request for OWserver to 3GL, '" + string2 + "'");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SynchronizeMessages
    implements IQueueListener {
        private boolean m_NewMessageReceived = false;
        private String m_Message = "";

        private SynchronizeMessages() {
        }

        synchronized String getReplyMessage() {
            if (!this.m_NewMessageReceived) {
                try {
                    s_logger.message("Waiting for reply from 3GL");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_NewMessageReceived = false;
            return this.m_Message;
        }

        public synchronized void onReceive(IBucket iBucket) {
            this.m_Message = iBucket.toString();
            this.m_NewMessageReceived = true;
            s_logger.message("Reply Message received from 3GL - '" + this.m_Message + "'");
            this.notify();
        }
    }
}

