/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BusDocUtils;
import com.eibus.baanC.BusListenerImpl;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.exception.ExceptionGroup;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import com.eibus.util.MRUCache;
import java.util.Dictionary;
import java.util.Vector;

public class BVMListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "BVMListenerImpl");
    private int m_toJVMQ;
    private boolean m_synchronous;
    private BusListenerImpl m_busListener;
    private Middleware m_middleware;
    private BusComponent m_component;
    private Directory m_directory;
    private Dictionary m_componentCache = new MRUCache(500);
    private static final String CANCEL_HEADER = "CancelRequest";

    public BVMListenerImpl(int n, boolean bl, BusListenerImpl busListenerImpl, Middleware middleware, BusComponent busComponent, Directory directory) {
        this.m_toJVMQ = n;
        this.m_synchronous = bl;
        this.m_busListener = busListenerImpl;
        this.m_middleware = middleware;
        this.m_component = busComponent;
        this.m_directory = directory;
    }

    public void onReceive(IBucket iBucket) {
        Object object;
        if (iBucket == null) {
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("Received bucket, but no header containing the receiver for the message. Bucket will be ignored");
            return;
        }
        s_logger.message("BVMListener: New bucket on queue " + this.m_toJVMQ + " has supposed receiver: " + string);
        if (this.m_synchronous && string.equals(CANCEL_HEADER)) {
            try {
                this.m_busListener.cancelWaitingForID();
            }
            catch (BusException busException) {
                s_logger.errorException(busException);
            }
            return;
        }
        Message message = new Message(iBucket.getBucket());
        if (this.m_synchronous) {
            try {
                this.m_busListener.syncWaitingForID(BusDocUtils.getMessageID(message));
            }
            catch (BusException busException) {
                s_logger.errorMessage("Failed to install SyncID at BusListener");
                s_logger.errorException(busException);
                return;
            }
        }
        IConnection iConnection = null;
        Vector<BusException> vector = new Vector<BusException>();
        URI uRI = null;
        try {
            s_logger.message("Trying to convert header to URI...");
            uRI = URI.createURI(string);
            iConnection = this.m_middleware.getConnected(uRI);
            message.setURI(uRI);
            if (message.HasMessageDigest()) {
                s_logger.message("Calculate and Adding message digest");
                message.addMessageDigest();
            }
            iConnection.send(message);
            return;
        }
        catch (MalformedURIException malformedURIException) {
            vector.addElement(malformedURIException);
        }
        catch (BusException busException) {
            vector.addElement(busException);
        }
        s_logger.message("Failed. Trying to interpret header to component name");
        BusComponent busComponent = null;
        try {
            busComponent = this.m_directory.retrieveBusComponent(string);
        }
        catch (DirectoryException directoryException) {
            Object[] objectArray = new Throwable[vector.size()];
            vector.copyInto(objectArray);
            s_logger.errorException(new ExceptionGroup((Throwable[])objectArray));
            return;
        }
        iConnection = (IConnection)this.m_componentCache.get(busComponent.getIdentifier());
        if (iConnection != null) {
            try {
                iConnection.send(message);
                return;
            }
            catch (BusException busException) {
                vector.addElement(busException);
                this.m_componentCache.remove(busComponent.getIdentifier());
                s_logger.errorException(busException);
            }
        }
        try {
            object = busComponent.getPreferredConnection();
            if (object != null) {
                uRI = ((ConnectionPoint)object).getURI();
                iConnection = this.m_middleware.getConnected(uRI);
                message.setURI(uRI);
                iConnection.send(message);
                this.m_componentCache.put(busComponent.getIdentifier(), iConnection);
                return;
            }
        }
        catch (BusException busException) {
            vector.addElement(busException);
            s_logger.errorException(busException);
        }
        s_logger.message("Failed to use preferred connection. Trying all other connectionpoints");
        object = busComponent.getConnectionPoints();
        while (object.hasMoreElements()) {
            try {
                ConnectionPoint connectionPoint = (ConnectionPoint)object.nextElement();
                uRI = connectionPoint.getURI();
                iConnection = this.m_middleware.getConnected(uRI);
                message.setURI(uRI);
                iConnection.send(message);
                this.m_componentCache.put(busComponent.getIdentifier(), iConnection);
                return;
            }
            catch (BusException busException) {
                vector.addElement(busException);
                s_logger.errorException(busException);
            }
        }
        s_logger.message("Failed alltogether. Give up");
        Object[] objectArray = new Throwable[vector.size()];
        vector.copyInto(objectArray);
        s_logger.errorException(new ExceptionGroup("Unable to send bucket from queue " + this.m_toJVMQ + " with header " + string + " to Bus", (Throwable[])objectArray));
    }
}

