/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baanC;

import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baanC.BucketUtils;
import com.eibus.co.dom.UserInfoCoImpl;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ActivationServiceFactory;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import java.util.Hashtable;

public class ActivationListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baanC", "ActivationListenerImpl");
    private static final String ACTIVATE_HEADER = "activate";
    private static final String DEACTIVATE_HEADER = "deactivate";
    private static final String GETBUSCOMPONENT_HEADER = "getstartedbuscomponent";
    private int m_toBVMQ;
    private int m_toJVMQ;
    private Hashtable ActivationServices = new Hashtable();
    private static int ActivationServicesCounter = 0;

    ActivationListenerImpl(int n, int n2) {
        this.m_toBVMQ = n;
        this.m_toJVMQ = n2;
        s_logger.message("ActivationListenerImpl: Listener up and running, using ToBVMQ: " + this.m_toBVMQ + "and ToJVMQ: " + this.m_toJVMQ);
    }

    public void onReceive(IBucket iBucket) {
        IBucket iBucket2 = null;
        if (iBucket == null) {
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("ActivationListenerImpl: Received bucket, but no header containing the function to be executed. Bucket will be ignored");
            return;
        }
        s_logger.message("ActivationListenerImpl: calling :'activate'");
        s_logger.message("ActivationListenerImpl: busComponent = 'activate'");
        s_logger.message("ActivationListenerImpl: UserInfo = 'activate'");
        String string2 = iBucket.toString();
        if (string.equals(ACTIVATE_HEADER)) {
            Object object;
            Object object2;
            int n = string2.lastIndexOf(";");
            BusComponent busComponent = null;
            UserInfoCoImpl userInfoCoImpl = null;
            String string3 = "";
            String string4 = "";
            IActivationService iActivationService = null;
            boolean bl = true;
            if (n > 0) {
                block24: {
                    bl = false;
                    object2 = new String[]{string2.substring(0, n), string2.substring(n + 1, string2.length())};
                    s_logger.message("ActivationListenerImpl: calling :'activate'");
                    s_logger.message("ActivationListenerImpl: busComponent = '" + (String)object2[0] + "'");
                    s_logger.message("ActivationListenerImpl: UserInfo = '" + (String)object2[1] + "'");
                    busComponent = new BusComponent((String)object2[0]);
                    if (busComponent != null) {
                        try {
                            object = busComponent.getActivation();
                            if (object != null) {
                                string3 = ((Activation)object).getType();
                                break block24;
                            }
                            s_logger.errorMessage("Type of activation cannot be retrieved from the buscomponent.");
                            bl = true;
                        }
                        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                            s_logger.errorMessage("Type of activation cannot be retrieved from the buscomponent.");
                            s_logger.errorException(attributeNotSpecifiedException);
                            bl = true;
                        }
                    } else {
                        s_logger.errorMessage("Failed creating BusComponent from String.");
                        bl = true;
                    }
                }
                userInfoCoImpl = new UserInfoCoImpl((String)object2[1]);
                if (userInfoCoImpl == null) {
                    s_logger.errorMessage("Failed creating UserInfo from String.");
                    bl = true;
                }
            }
            if (!bl) {
                try {
                    iActivationService = ActivationServiceFactory.createActivationService(string3);
                    object2 = iActivationService.Activate(busComponent, userInfoCoImpl);
                    string4 = XMLNode.FromXmlNode2String(((BusComponent)object2).toDOM());
                }
                catch (BusException busException) {
                    object = new Object[]{string3};
                    s_logger.errorMessage("Activation with service failed. " + object.toString());
                    bl = true;
                }
            }
            if (bl) {
                iBucket2 = BucketUtils.newError("Error in ActivationListenerImpl, backend not activated");
            } else {
                this.ActivationServices.put("" + ActivationServicesCounter, iActivationService);
                s_logger.message("ActivationService is started, id send back = '" + ActivationServicesCounter + "'");
                iBucket2 = BucketUtils.newMessage("" + ActivationServicesCounter);
                ++ActivationServicesCounter;
            }
        } else if (string.equals(DEACTIVATE_HEADER)) {
            s_logger.message("ActivationListenerImpl, function 'deactivate', parameters='" + string2 + "'");
            try {
                iBucket2 = BucketUtils.newMessage("Not implemented because De-Activation needs a Java Connection");
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{DEACTIVATE_HEADER};
                s_logger.errorMessage("Error in ActivationListenerImpl. " + objectArray.toString());
                iBucket2 = BucketUtils.newError("Error in ActivationListenerImpl, 'deactivate'");
            }
        } else if (string.equals(GETBUSCOMPONENT_HEADER)) {
            s_logger.message("ActivationListenerImpl, function 'getstartedbuscomponent', parameters='" + string2 + "'");
            try {
                int n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{GETBUSCOMPONENT_HEADER};
                s_logger.errorMessage("Error in ActivationListenerImpl " + objectArray.toString());
                iBucket2 = BucketUtils.newError("Error in ActivationListenerImpl, 'getstartedbuscomponent'");
            }
        } else {
            s_logger.message("ActivationListenerImpl: Received request to invoke unknown method: " + string);
        }
        BucketUtils.send(this.m_toBVMQ, iBucket2);
    }
}

