/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baan4GL;

import com.baan.baanvm.IBucket;
import com.baan.baanvm.IQueueListener;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.connection.BusListener;
import com.eibus.connection.IConnection;
import com.eibus.connection.Message;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.exception.ExceptionGroup;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import com.eibus.services.profiling.ITimer;
import com.eibus.util.MRUCache;
import java.util.Dictionary;
import java.util.Vector;

class QueueListenerImpl
implements IQueueListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baan4GL", "QueueListenerImpl");
    private int m_queueId;
    private Middleware m_middleware;
    private Dictionary m_componentCache = new MRUCache(500);
    private BusComponent m_component;
    private Directory m_directory;
    public static int m_messagesInBshell;

    QueueListenerImpl(int n, Middleware middleware, BusComponent busComponent, Directory directory) {
        this.m_queueId = n;
        this.m_middleware = middleware;
        this.m_component = busComponent;
        this.m_directory = directory;
    }

    public void onReceive(IBucket iBucket) {
        Object object;
        BusListener busListener = this.m_middleware.getBusListener();
        ITimer iTimer = busListener.getITimer();
        --m_messagesInBshell;
        if (iTimer != null) {
            iTimer.split("from BaanVM");
        }
        if (iBucket == null) {
            return;
        }
        String string = iBucket.getHeader();
        if (string == null) {
            s_logger.message("Received bucket, but no header containing the receiver for the message. Bucket will be ignored");
            return;
        }
        s_logger.message("New (reply) bucket from queue " + this.m_queueId + " has supposed receiver: " + string);
        Message message = new Message(iBucket.getBucket());
        message.setITimer(iTimer);
        IConnection iConnection = null;
        Vector<BusException> vector = new Vector<BusException>();
        URI uRI = null;
        try {
            uRI = URI.createURI(string);
            iConnection = this.m_middleware.getConnected(uRI);
            message.setURI(uRI);
            if (message.HasMessageDigest()) {
                message.addMessageDigest();
            }
            iConnection.send(message);
            iTimer = message.getITimer();
            if (iTimer != null) {
                iTimer.stop();
            }
            return;
        }
        catch (MalformedURIException malformedURIException) {
            vector.addElement(malformedURIException);
        }
        catch (BusException busException) {
            vector.addElement(busException);
        }
        BusComponent busComponent = null;
        try {
            busComponent = this.m_directory.retrieveBusComponent(string);
        }
        catch (DirectoryException directoryException) {
            Object[] objectArray = new Throwable[vector.size()];
            vector.copyInto(objectArray);
            s_logger.errorException(new ExceptionGroup((Throwable[])objectArray));
            return;
        }
        iConnection = (IConnection)this.m_componentCache.get(busComponent.getIdentifier());
        if (iConnection != null) {
            try {
                iConnection.send(message);
                iTimer = message.getITimer();
                if (iTimer != null) {
                    iTimer.stop();
                }
                return;
            }
            catch (BusException busException) {
                vector.addElement(busException);
                this.m_componentCache.remove(busComponent.getIdentifier());
                s_logger.errorException(busException);
            }
        }
        try {
            object = busComponent.getPreferredConnection();
            if (object != null) {
                uRI = ((ConnectionPoint)object).getURI();
                iConnection = this.m_middleware.getConnected(uRI);
                message.setURI(uRI);
                iConnection.send(message);
                iTimer = message.getITimer();
                if (iTimer != null) {
                    iTimer.stop();
                }
                this.m_componentCache.put(busComponent.getIdentifier(), iConnection);
                return;
            }
        }
        catch (BusException busException) {
            vector.addElement(busException);
            s_logger.errorException(busException);
        }
        object = busComponent.getConnectionPoints();
        while (object.hasMoreElements()) {
            try {
                ConnectionPoint connectionPoint = (ConnectionPoint)object.nextElement();
                uRI = connectionPoint.getURI();
                iConnection = this.m_middleware.getConnected(uRI);
                message.setURI(uRI);
                iConnection.send(message);
                iTimer = message.getITimer();
                if (iTimer != null) {
                    iTimer.stop();
                }
                this.m_componentCache.put(busComponent.getIdentifier(), iConnection);
                return;
            }
            catch (BusException busException) {
                vector.addElement(busException);
                s_logger.errorException(busException);
            }
        }
        Object[] objectArray = new Throwable[vector.size()];
        vector.copyInto(objectArray);
        s_logger.errorException(new ExceptionGroup("Unable to send bucket from queue " + this.m_queueId + " with header " + string + " to Bus", (Throwable[])objectArray));
    }
}

