/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baan4GL;

import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baan4GL.QueueListenerImpl;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.eibus.connection.BusListener;
import com.eibus.connection.Message;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.profiling.ITimer;

class BusListenerImpl
implements BusListener {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baan4GL", "BusListenerImpl");
    private int m_queueId;
    private static IBaanVM s_iBaanVm = null;
    private ITimer m_timer = null;

    BusListenerImpl(int n) throws DirectoryException {
        if (s_iBaanVm == null) {
            try {
                s_iBaanVm = BucketUtils.getBaanVMInterface();
            }
            catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                s_logger.errorMessage("BusListenerImpl(): Failed to initialize IBaanVM interface!");
                s_logger.errorException(baanVMNotInstalledException);
                throw new DirectoryException(baanVMNotInstalledException.getMessage());
            }
        }
        s_logger.message("Constructed new bus listener that will notify queue: " + n);
        this.m_queueId = n;
    }

    public void onReceive(Message message) {
        s_logger.message("Received message from the bus");
        if (message.HasMessageDigest()) {
            s_logger.message("checking Message Digests ");
            if (!message.CheckMessageDigest()) {
                s_logger.message("Wrong Message Digest, message ignored !!");
                return;
            }
        }
        this.m_timer = message.getITimer();
        s_logger.message("Put (request) message to Queue with Id " + this.m_queueId);
        IBucket iBucket = s_iBaanVm.createBucket(message.getText());
        int n = s_iBaanVm.putBucket(this.m_queueId, iBucket);
        this.m_timer.split("to BaanVM");
        if (n < 0) {
            s_logger.message("Failed to put bucket: " + n);
            s_logger.message("Bucket was: " + new String(iBucket.getBucket()));
        } else {
            s_logger.message("Messages Currently in bshell (queue) = " + ++QueueListenerImpl.m_messagesInBshell);
        }
    }

    public void setITimer(ITimer iTimer) {
        this.m_timer = iTimer;
    }

    public ITimer getITimer() {
        return this.m_timer;
    }
}

