/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.baan4GL;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Text;
import com.baan.baanvm.IBaanVM;
import com.baan.baanvm.IBucket;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.baan4GL.BusListenerImpl;
import com.eibus.baan4GL.QueueListenerImpl;
import com.eibus.baanC.BaanVMNotInstalledException;
import com.eibus.baanC.BucketUtils;
import com.eibus.connection.BusListener;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.xml.dom.DocumentImpl;
import com.eibus.xml.util.DOMWriter;
import com.eibus.xml.util.NiceDOMWriter;
import java.util.Dictionary;
import java.util.Hashtable;

public class BusConnection {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.baan4GL", "BusConnection");
    static final boolean PRINT_DEBUG_INFO = false;
    static final String ERROR_DOC_NAME = "Error";
    static final String COMPONENT_NAME_TAG = "ComponentName";
    static final String ERROR_MESSAGE_TAG = "Message";
    static final String START_CONNECTION_FAILURE = "start_failed";
    static final String DIRSVC_FAILURE = "dirsvc_failed";
    static Dictionary s_middlewareConnections = new Hashtable();
    static IBaanVM s_iBaanVm = null;
    static boolean s_initialized = false;

    public static void initialize() throws DirectoryException {
        s_logger.message("Initializing busconnection");
        if (!s_initialized) {
            if (s_iBaanVm == null) {
                try {
                    s_iBaanVm = BucketUtils.getBaanVMInterface();
                }
                catch (BaanVMNotInstalledException baanVMNotInstalledException) {
                    s_logger.errorMessage("Busconnection.initialize: Unable to locate IBaanVM interface, please check BaanERP installation!");
                    s_logger.errorException(baanVMNotInstalledException);
                    throw new DirectoryException(baanVMNotInstalledException.getMessage());
                }
            }
            s_initialized = true;
            s_logger.message("First-time initialization of the BusConnection succeeded");
        }
        s_logger.message("Initialized BusConnection");
    }

    /*
     * Unable to fully structure code
     */
    public static void initialize4GLLocationService(String var0, int var1_1) {
        block10: {
            BusConnection.s_logger.message("initialize4GLLocationService(" + var0 + ", " + var1_1 + ") invocation");
            try {
                BusConnection.initialize();
                var2_2 = new DirectoryServiceProvider().getDirectoryService();
                BusConnection.s_logger.message("initialize4GLLocationService: Retrieving list of objects in the directory service");
                var3_4 = var2_2.findAllBusComponents(2000);
                if (var3_4 != null) ** GOTO lbl34
                var4_6 = BusConnection.s_iBaanVm.createBucket("No objects present in Directory Service", "failed");
                BusConnection.s_logger.message("initialize4GLLocationService: No objects retrieved from the directory service");
                if (BusConnection.s_iBaanVm.putBucket(var1_1, var4_6) < 0) {
                    var5_9 = new Object[]{var4_6};
                    BusConnection.s_logger.errorMessage("Failed to put bucket" + var5_9.toString());
                }
                return;
lbl-1000:
                // 1 sources

                {
                    var4_7 = (BusComponent)var3_4.nextElement();
                    var5_10 = null;
                    try {
                        var5_10 = var4_7.getCategories();
                    }
                    catch (AttributeNotSpecifiedException var6_11) {
                        // empty catch block
                    }
                    if (var0 != null && !var0.equals("")) {
                        var6_12 = false;
                        if (var5_10 != null) {
                            while (var5_10.hasMoreElements()) {
                                var7_14 = (String)var5_10.nextElement();
                                if (!var7_14.equalsIgnoreCase(var0)) continue;
                                var6_12 = true;
                                break;
                            }
                        }
                        if (!var6_12) continue;
                    }
                    if (BusConnection.s_iBaanVm.putBucket(var1_1, (IBucket)(var7_14 = BusConnection.s_iBaanVm.createBucket(var6_13 = new DOMWriter(var4_7.toDOM()).toString(), "add"))) >= 0) continue;
                    var8_15 = new Object[]{new String("identification bucket")};
                    BusConnection.s_logger.errorMessage("Failed to put bucket " + var8_15.toString());
                    return;
lbl34:
                    // 3 sources

                    ** while (var3_4.hasMoreElements())
                }
lbl35:
                // 1 sources

                BusConnection.s_logger.message("initialize4GLLocationService: all buscomponents returned, informing other party");
                var4_7 = BusConnection.s_iBaanVm.createBucket("Some content", "lastEntry");
                if (BusConnection.s_iBaanVm.putBucket(var1_1, (IBucket)var4_7) < 0) {
                    var5_10 = new Object[]{new String("last bucket")};
                    BusConnection.s_logger.errorMessage("Failed to put bucket " + var5_10.toString());
                    return;
                }
            }
            catch (Throwable var2_3) {
                BusConnection.s_logger.message("Failed to initialize directory: " + var2_3);
                BusConnection.s_logger.errorException(var2_3);
                var3_5 = BusConnection.s_iBaanVm.createBucket("" + var2_3, "failed");
                if (BusConnection.s_iBaanVm.putBucket(var1_1, var3_5) >= 0) break block10;
                var4_8 = new Object[]{new String("exception bucket")};
                BusConnection.s_logger.errorMessage("Failed to put bucket" + var4_8.toString());
                BusConnection.s_logger.errorException(var2_3);
            }
        }
        BusConnection.s_logger.message("initialize4GLLocationService(" + var0 + ", " + var1_1 + ") ready");
    }

    public static void startConnection(int n, int n2, String string, String string2) {
        s_logger.message("Using deprecated method: BusConnection.startConnection(int,int,String,String)");
        BusConnection.startConnection(n, n2, string);
    }

    public static void startConnection(int n, int n2, int n3, String string) {
        block5: {
            try {
                Object[] objectArray;
                BusConnection.initialize();
                Directory directory = new DirectoryServiceProvider().getDirectoryService();
                BusComponent busComponent = directory.retrieveBusComponent(string);
                ConnectionPoint connectionPoint = busComponent.getPreferredConnection();
                String string2 = connectionPoint.getPolicy();
                if (string2 != null && string2.equals("variable")) {
                    objectArray = new DOMWriter(busComponent.toDOM()).toString();
                    busComponent = new BusComponent((String)objectArray);
                }
                if (s_middlewareConnections.get(busComponent) != null) {
                    objectArray = new Object[]{string};
                    s_logger.errorMessage("Connection for " + string + " already exists");
                    throw new BusException("Connection already exists");
                }
                objectArray = new BusListenerImpl(n2);
                s_logger.message("Now opening connections for " + busComponent.getIdentifier());
                Middleware middleware = new Middleware(busComponent, (BusListener)objectArray);
                QueueListenerImpl queueListenerImpl = new QueueListenerImpl(n, middleware, busComponent, directory);
                s_iBaanVm.installListener(n, queueListenerImpl);
                s_logger.message("Now putting connection in hashtable");
                s_middlewareConnections.put(string, middleware);
                String string3 = new DOMWriter(busComponent.toDOM()).toString();
                IBucket iBucket = s_iBaanVm.createBucket(string3, "start");
                if (s_iBaanVm.putBucket(n3, iBucket) < 0) {
                    s_logger.errorMessage("Failed to put bucket 'start bucket'");
                }
                s_logger.message("Constructed connection for " + string);
            }
            catch (Throwable throwable) {
                s_logger.message("Failed to start connection for " + string + ": " + throwable);
                Document document = BusConnection.createErrorDocument(string, "Failed to start server for " + string + ": " + throwable);
                s_logger.message(new NiceDOMWriter(document).toString());
                IBucket iBucket = s_iBaanVm.createBucket(new DOMWriter(document).toString(), START_CONNECTION_FAILURE);
                int n4 = s_iBaanVm.putBucket(n3, iBucket);
                if (n4 >= 0) break block5;
                s_logger.errorMessage("Failed to put bucket 'exit bucket'");
            }
        }
    }

    private static Document createErrorDocument(String string, String string2) {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement(ERROR_DOC_NAME);
        documentImpl.appendChild(element);
        Element element2 = documentImpl.createElement(COMPONENT_NAME_TAG);
        Text text = documentImpl.createTextNode(string);
        element2.appendChild(text);
        element.appendChild(element2);
        Element element3 = documentImpl.createElement(ERROR_MESSAGE_TAG);
        text = documentImpl.createTextNode(string2);
        element3.appendChild(text);
        element.appendChild(element3);
        return documentImpl;
    }

    public static void startConnection(int n, int n2, String string) {
        s_logger.message("Using deprecated startConnection (without an admin queue). Using queue " + n2 + " as admin queue");
        BusConnection.startConnection(n, n2, n2, string);
    }

    public static void stopConnection(String string, int n) {
        block3: {
            try {
                BusConnection.initialize();
                Middleware middleware = (Middleware)s_middlewareConnections.remove(string);
                if (middleware != null) {
                    middleware.close();
                    IBucket iBucket = s_iBaanVm.createBucket("Stopped connections for " + string, "stop");
                    s_logger.message("Stopped connection for " + string);
                    if (s_iBaanVm.putBucket(n, iBucket) >= 0) break block3;
                    s_logger.errorMessage("Failed to put bucket 'stop bucket'");
                    break block3;
                }
                s_logger.errorMessage("Connection for component " + string + " cannot be found");
            }
            catch (BusException busException) {
                Object[] objectArray = new Object[]{busException.toString()};
                s_logger.errorMessage("Failed to stop connection.");
                s_logger.errorException(busException);
            }
        }
    }
}

