/*
 * Decompiled with CFR 0.152.
 */
package com.baan.tech.threadutil;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.baan.tech.BadStateException;
import com.baan.tech.UnexpectedStateChangeException;
import com.baan.tech.threadutil.IHandlerRoutine;

public class HandlerLoop {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.baan.tech.threadutil", "HandlerLoop");
    private static final ILogger s_innerLogger = LoggerFactory.createLogger("com.baan.tech.threadutil.HandlerLoop", "Implementation");
    public static final int HL_SUSPENDED = 0;
    public static final int HL_SUSPENDING = 1;
    public static final int HL_RUNNING = 2;
    public static final int HL_STOPPING = 3;
    public static final int HL_STOPPED = 4;
    private static final String[] STATENAMES = new String[]{"SUSPENDED", "SUSPENDING", "RUNNING", "STOPPING", "STOPPED"};
    private int state = 0;
    private IHandlerRoutine routine;
    private Thread runner = new Thread((Runnable)new Implementation(), this.toString());

    public HandlerLoop(IHandlerRoutine iHandlerRoutine) {
        this.routine = iHandlerRoutine;
        this.runner.start();
    }

    public synchronized int getState() {
        return this.state;
    }

    public String getStateString() {
        return STATENAMES[this.state];
    }

    public boolean start() {
        s_logger.flowEntry("start()");
        boolean bl = this.changeState(2);
        s_logger.flowExit("start()");
        return bl;
    }

    public void suspend() throws BadStateException, UnexpectedStateChangeException, InterruptedException {
        s_logger.flowEntry("suspend()");
        this.suspend(-1);
        s_logger.flowExit("suspend()");
    }

    public synchronized boolean suspend(int n) throws BadStateException, UnexpectedStateChangeException, InterruptedException {
        s_logger.flowEntry("suspend(int)");
        if (this.state == 0) {
            s_logger.flowExit("suspend(int)1");
            return true;
        }
        if (!this.changeState(1)) {
            throw new BadStateException(this + ": state was != 'running' (== " + STATENAMES[this.state] + " instead).");
        }
        if (n > 0) {
            this.wait(n);
        } else {
            this.wait();
        }
        if (this.state == 1 && n > 0) {
            s_logger.flowExit("suspend(int)2");
            return false;
        }
        if (this.state != 0) {
            throw new UnexpectedStateChangeException(this + ": changed state (to " + STATENAMES[this.state] + ") while 'suspending'.");
        }
        s_logger.flowExit("suspend(int)3");
        return true;
    }

    public void stop() throws InterruptedException {
        s_logger.flowEntry("stop()");
        this.stop(-1);
        s_logger.flowExit("stop()");
    }

    public synchronized boolean stop(int n) throws InterruptedException {
        s_logger.flowEntry("stop(int)");
        if (this.state == 4) {
            s_logger.flowExit("stop(int)1");
            return true;
        }
        this.changeState(3);
        if (n > 0) {
            this.wait(n);
        } else {
            this.wait();
        }
        if (this.state == 3 && n > 0) {
            s_logger.flowExit("stop(int)2");
            return false;
        }
        s_logger.flowExit("stop(int)3");
        return true;
    }

    public synchronized void destroy() {
        if (this.state == 4) {
            s_logger.flowExit("destroy()1");
            return;
        }
        this.runner.stop();
        this.changeState(4);
        this.cleanup();
        s_logger.flowExit("destroy()2");
    }

    public String toString() {
        return "com.baan.tech.threadutil.HandlerLoop using HandlerRoutine " + this.routine;
    }

    private synchronized boolean changeState(int n) {
        s_logger.flowEntry("changeState(int)");
        if (this.state == n) {
            s_logger.flowExit("changeState(int)1");
            return true;
        }
        switch (n) {
            case 0: {
                if (this.state == 1) break;
                s_logger.flowExit("changeState(int)2");
                return false;
            }
            case 1: {
                if (this.state == 2) break;
                s_logger.flowExit("changeState(int)3");
                return false;
            }
            case 2: {
                if (this.state == 0) break;
                s_logger.flowExit("changeState(int)4");
                return false;
            }
            case 3: {
                if (this.state != 4) break;
                s_logger.flowExit("changeState(int)5");
                return false;
            }
            case 4: {
                break;
            }
            default: {
                throw new RuntimeException(this + ": Attempt to change to illegal state (" + n + ").");
            }
        }
        this.state = n;
        this.notifyAll();
        s_logger.flowExit("changeState(int)6");
        return true;
    }

    private void cleanup() {
        s_logger.flowEntry("cleanup()");
        this.runner = null;
        this.routine = null;
        s_logger.flowExit("cleanup()");
    }

    private class Implementation
    implements Runnable {
        private Implementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                s_innerLogger.flowEntry("run()");
                boolean bl = false;
                while (!bl) {
                    HandlerLoop handlerLoop = HandlerLoop.this;
                    synchronized (handlerLoop) {
                        if (HandlerLoop.this.state == 1) {
                            HandlerLoop.this.changeState(0);
                        }
                        if (HandlerLoop.this.state == 0) {
                            try {
                                s_innerLogger.message("Entering suspended state...");
                                HandlerLoop.this.wait();
                                s_innerLogger.message("Left suspended state.");
                            }
                            catch (InterruptedException interruptedException) {
                                s_innerLogger.message("InterruptedException in handlerLoop.Implementation.run().");
                                s_innerLogger.errorException(interruptedException);
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        if (HandlerLoop.this.state != 2) {
                            bl = true;
                            continue;
                        }
                    }
                    HandlerLoop.this.routine.handleNextItem(HandlerLoop.this);
                }
                HandlerLoop.this.changeState(4);
                HandlerLoop.this.cleanup();
                s_innerLogger.flowExit("run()");
            }
            catch (Throwable throwable) {
                s_innerLogger.message("Exception thrown in IHandlerRoutine " + HandlerLoop.this.routine);
                s_innerLogger.errorException(throwable);
            }
        }
    }
}

